/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom;

import java.io.PrintStream;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionRawInterface;
import se.ericsson.cello.sudom.parser.dom.ParsedData;

public class OptimizedProductNumberAndRevisionData
extends ParsedData
implements ProductNumberAndRevisionRawInterface {
    protected String myProductNumber = null;
    protected String myRevision = null;
    protected String myProductNumberRaw = null;
    protected String myRevisionRaw = null;

    protected OptimizedProductNumberAndRevisionData() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"OptimizedProductNumberAndRevisionData( )");
        }
    }

    protected OptimizedProductNumberAndRevisionData(Locator locator) {
        super(locator);
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"OptimizedProductNumberAndRevisionData(Locator aLocator)", (String)("\n\taLocator: " + locator));
        }
    }

    protected void optimizeProductNumberAndRevision() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"optimizeProductNumberAndRevision( )");
        }
        this.optimizeProductNumber();
        this.optimizeRevision();
    }

    protected void optimizeProductNumber() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"optimizeProductNumber( )");
        }
        if (StringHandler.isContainingWhiteSpaceOrLowerCase(this.myProductNumber)) {
            this.myProductNumberRaw = this.myProductNumber;
            this.myProductNumber = StringHandler.optimize(this.myProductNumberRaw);
        }
    }

    protected void optimizeRevision() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"optimizeRevision( )");
        }
        if (StringHandler.isContainingWhiteSpaceOrLowerCase(this.myRevision)) {
            this.myRevisionRaw = this.myRevision;
            this.myRevision = StringHandler.optimize(this.myRevisionRaw);
        }
    }

    protected void print(PrintStream printStream, String string, String string2, String string3, String string4) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"print(PrintStream aPrintStream, String anIndentation)", (String)("aPrintStream: " + printStream + "\n\tanIndentation: " + string + "\n\taSubElementName: " + string2 + "\n\taProductNumberString: " + string3 + "\n\taRevisionString: " + string4));
        }
        printStream.println(string + "<" + string2);
        if (this.myProductNumber != null) {
            printStream.println(string + "  " + string3 + " = \"" + this.getProductNumberRaw() + "\"");
        }
        if (this.myRevision != null) {
            printStream.println(string + "  " + string4 + " = \"" + this.getRevisionRaw() + "\"");
        }
        printStream.println(string + "/>");
    }

    public String getProductNumber() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumber( )");
        }
        return this.myProductNumber;
    }

    public String getRevision() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRevision( )");
        }
        return this.myRevision;
    }

    public String getProductNumberRaw() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumberRaw( )");
        }
        if (this.myProductNumberRaw != null) {
            return this.myProductNumberRaw;
        }
        return this.myProductNumber;
    }

    public String getRevisionRaw() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRevisionRaw( )");
        }
        if (this.myRevisionRaw != null) {
            return this.myRevisionRaw;
        }
        return this.myRevision;
    }

    public void setProductNumber(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setProductNumber(String aProductNumber)", (String)("aProductNumber: " + string));
        }
        this.myProductNumber = string;
        this.optimizeProductNumber();
    }

    public void setRevision(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setRevision(String aRevision)", (String)("aRevision: " + string));
        }
        this.myRevision = string;
        this.optimizeRevision();
    }

    public String toString() {
        String string = "\n\tProductNumber: " + this.myProductNumber;
        if (this.myProductNumberRaw != null) {
            string = string + "\n\tProductNumberRaw: " + this.myProductNumberRaw;
        }
        string = string + "\n\tRevision: " + this.myRevision;
        if (this.myRevisionRaw != null) {
            string = string + "\n\tRevisionRaw: " + this.myRevisionRaw;
        }
        return string;
    }
}

