/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.installsequence;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.dom.installsequence.InstallSequence;
import se.ericsson.cello.sudom.parser.dom.installsequence.InstallSequenceSubElementName;
import se.ericsson.cello.sudom.parser.dom.installsequence.InstallStep;
import se.ericsson.cello.sudom.parser.dom.installsequence.InstallStepAttributeName;
import se.ericsson.cello.sudom.parser.dom.installsequence.InstallStepSubElementName;
import se.ericsson.cello.sudom.parser.dom.installsequence.SoftJvmUpgrade;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.Trigger;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.TriggerAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.TriggerSubSpecValue;
import se.ericsson.cello.sudom.parser.dom.validators.Validator;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class InstallSequenceValidator
extends Validator {
    public static void validate(InstallSequence installSequence, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid((Class)InstallSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)InstallSequenceValidator.class, (int)25, (String)"validate(InstallSequence anInstallSequence, Locator aLocator)", (String)("anInstallSequence: " + installSequence + "\n\taLocator: " + locator));
        }
        Vector vector = installSequence.getInstallSteps();
        Iterator iterator = vector.iterator();
        InstallStep installStep = null;
        int n = 0;
        int n2 = 0;
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            installStep = (InstallStep)iterator.next();
            InstallSequenceValidator.validateThatInstallStepContainsA_KnownSubElement(installStep);
            InstallSequenceValidator.validateThatSoftJvmUpgradeInInstallStepContainsA_KnownSubElement(installStep);
            n = InstallSequenceValidator.validateThatOneAndOnlyOneInstallStepContainsAnInstallLMs(installStep, locator, n, iterator.hasNext());
            n2 = InstallSequenceValidator.validateThatNoneOrOnlyOneInstallStepContainsA_PreUpgradeSu(installStep, n2);
            InstallSequenceValidator.validateThatLabelIsUniqueForAllInstallSteps(installStep, hashSet);
            InstallSequenceValidator.valdateThatTriggerInInstallStepContainsAllowedSubSpecValue(installStep);
        }
    }

    private static void validateThatInstallStepContainsA_KnownSubElement(InstallStep installStep) throws ValidateException {
        if (UpgradeTrace.valid((Class)InstallSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)InstallSequenceValidator.class, (int)25, (String)"validateThatInstallStepContainsA_KnownSubElement(InstallStep anInstallStep)", (String)("anInstallStep: " + installStep));
        }
        if (installStep.getPreUpgradeSu() == null && installStep.getInstallLMs() == null && installStep.getSoftJvmUpgrade() == null && installStep.getTrigger() == null && installStep.getRebootProgramUpgrade() == null) {
            String string = "\n\tAn " + InstallSequenceSubElementName.InstallStep.getValue() + " element must contain at least one sub element of known type.";
            InstallSequenceValidator.errorElementIsMissingNoSubElementWithLocatorString(InstallSequenceValidator.class, "validateThatInstallStepContainsA_KnownSubElement(InstallStep anInstallStep)", "InstallSequence", InstallSequenceSubElementName.InstallStep.getValue(), string, installStep.getLocatorString());
        }
    }

    private static void validateThatLabelIsUniqueForAllInstallSteps(InstallStep installStep, HashSet hashSet) throws ValidateException {
        if (UpgradeTrace.valid((Class)InstallSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)InstallSequenceValidator.class, (int)25, (String)"validateThatLabelIsUniqueForAllInstallSteps(InstallStep anInstallStep, HashSet aLabels)", (String)("anInstallStep: " + installStep + "\n\taLabels: " + hashSet));
        }
        if (!hashSet.add(installStep.getLabel().toUpperCase())) {
            String string = "\n\tThe value of this attribute must be unique among all " + InstallSequenceSubElementName.InstallStep.getValue() + " elements in this " + "InstallSequence" + ".";
            InstallSequenceValidator.errorIllegalAttributeValueWithLocatorString(InstallSequenceValidator.class, "validateThatLabelIsUniqueForAllInstallSteps(InstallStep anInstallStep, HashSet aLabels)", InstallSequenceSubElementName.InstallStep.getValue(), InstallStepAttributeName.Label.getValue(), installStep.getLabel(), string, installStep.getLocatorString());
        }
    }

    private static int validateThatNoneOrOnlyOneInstallStepContainsA_PreUpgradeSu(InstallStep installStep, int n) throws ValidateException {
        if (UpgradeTrace.valid((Class)InstallSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)InstallSequenceValidator.class, (int)25, (String)"validateThatNoneOrOnlyOneInstallStepContainsA_PreUpgradeSu(InstallStep anInstallStep, int aNumberOfInstallStepsContainingA_PreUpgradeSu)", (String)("anInstallStep: " + installStep + "\n\taNumberOfInstallStepsContainingA_PreUpgradeSu: " + n));
        }
        if (installStep.getPreUpgradeSu() != null && ++n > 1) {
            String string = "\n\tAn InstallSequence element is only allowed to contain one " + InstallSequenceSubElementName.InstallStep.getValue() + " element that contains a " + InstallStepSubElementName.PreUpgradeSu.getValue() + " element.";
            InstallSequenceValidator.errorUnexpectedElementWithLocatorString(InstallSequenceValidator.class, "validateThatNoneOrOnlyOneInstallStepContainsA_PreUpgradeSu(InstallStep anInstallStep, int aNumberOfInstallStepsContainingA_PreUpgradeSu)", "InstallSequence", InstallSequenceSubElementName.InstallStep.getValue(), InstallStepSubElementName.PreUpgradeSu.getValue(), string, installStep.getPreUpgradeSu().getLocatorString());
        }
        return n;
    }

    private static int validateThatOneAndOnlyOneInstallStepContainsAnInstallLMs(InstallStep installStep, Locator locator, int n, boolean bl) throws ValidateException {
        if (UpgradeTrace.valid((Class)InstallSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)InstallSequenceValidator.class, (int)25, (String)"validateThatOneAndOnlyOneInstallStepContainsAnInstallLMs(InstallStep anInstallStep, Locator aLocator, int aNumberOfInstallStepsContainingAnInstallLMs, boolean anIsInstallSequenceContainingMoreInstallSteps)", (String)("anInstallStep: " + installStep + "\n\taLocator: " + locator + "\n\taNumberOfInstallStepsContainingAnInstallLMs: " + n + "\n\tanIsInstallSequenceContainingMoreInstallSteps: " + bl));
        }
        String string = null;
        if (installStep.getInstallLMs() != null) {
            if (++n > 1) {
                string = "\n\tAn InstallSequence element is only allowed to contain one " + InstallSequenceSubElementName.InstallStep.getValue() + " element that contains an " + InstallStepSubElementName.InstallLMs.getValue() + " element.";
                InstallSequenceValidator.errorUnexpectedElementWithLocatorString(InstallSequenceValidator.class, "validateThatOneAndOnlyOneInstallStepContainsAnInstallLMs(InstallStep anInstallStep, Locator aLocator, int aNumberOfInstallStepsContainingAnInstallLMs, boolean anIsInstallSequenceContainingMoreInstallSteps)", "InstallSequence", InstallSequenceSubElementName.InstallStep.getValue(), InstallStepSubElementName.InstallLMs.getValue(), string, installStep.getInstallLMs().getLocatorString());
            }
        } else if (!bl && n == 0) {
            string = "\n\tAn InstallSequence element must contain one " + InstallSequenceSubElementName.InstallStep.getValue() + " element that contains an " + InstallStepSubElementName.InstallLMs.getValue() + " element.";
            InstallSequenceValidator.errorElementIsMissingOneElement(InstallSequenceValidator.class, "validateThatOneAndOnlyOneInstallStepContainsAnInstallLMs(InstallStep anInstallStep, Locator aLocator, int aNumberOfInstallStepsContainingAnInstallLMs, boolean anIsInstallSequenceContainingMoreInstallSteps)", "InstallSequence", InstallSequenceSubElementName.InstallStep.getValue(), InstallStepSubElementName.InstallLMs.getValue(), string, locator);
        }
        return n;
    }

    private static void validateThatSoftJvmUpgradeInInstallStepContainsA_KnownSubElement(InstallStep installStep) throws ValidateException {
        SoftJvmUpgrade softJvmUpgrade;
        if (UpgradeTrace.valid((Class)InstallSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)InstallSequenceValidator.class, (int)25, (String)"validateThatSoftJvmUpgradeInInstallStepContainsA_KnownSubElement(InstallStep anInstallStep)", (String)("anInstallStep: " + installStep));
        }
        if ((softJvmUpgrade = installStep.getSoftJvmUpgrade()) != null && softJvmUpgrade.getLoadJavaLMs().isEmpty() && softJvmUpgrade.getUnloadJavaLMs().isEmpty()) {
            String string = "\n\tA " + InstallStepSubElementName.SoftJvmUpgrade.getValue() + " element must contain at least one sub element of known type.";
            InstallSequenceValidator.errorElementIsMissingNoSubElementWithLocatorString(InstallSequenceValidator.class, "validateThatSoftJvmUpgradeInInstallStepContainsA_KnownSubElement(InstallStep anInstallStep)", InstallSequenceSubElementName.InstallStep.getValue(), InstallStepSubElementName.SoftJvmUpgrade.getValue(), string, softJvmUpgrade.getLocatorString());
        }
    }

    private static void valdateThatTriggerInInstallStepContainsAllowedSubSpecValue(InstallStep installStep) throws ValidateException {
        String string;
        Trigger trigger;
        if (UpgradeTrace.valid((Class)InstallSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)InstallSequenceValidator.class, (int)25, (String)"valdateThatTriggerInInstallStepContainsAllowedSubSpecValue(InstallStep anInstallStep)", (String)("anInstallStep: " + installStep));
        }
        if ((trigger = installStep.getTrigger()) != null && !TriggerSubSpecValue.isValuePreDefinedForInstallSequence(string = trigger.getSubSpec())) {
            if (TriggerSubSpecValue.isValuePreDefinedForPreCheckSequence(string)) {
                String string2 = "\n\tThe requested value is one of the values that is predefined for a VerifyUpgradeSequence,";
                if (TriggerSubSpecValue.isValuePreDefinedForVerifySequence(string)) {
                    string2 = "\n\tThe requested value is the value that is predefined for a VerifySequence,";
                } else if (TriggerSubSpecValue.isValuePreDefinedForVerifyUpdateSequence(string)) {
                    string2 = "\n\tThe requested value is the value that is predefined for a VerifyUpdateSequence,";
                }
                String string3 = "\n\tthis value is not allowed in an InstallSequence.";
                InstallSequenceValidator.errorIllegalAttributeValueWithLocatorString(InstallSequenceValidator.class, "valdateThatTriggerInInstallStepContainsAllowedSubSpecValue(InstallStep anInstallStep)", InstallSequenceSubElementName.InstallStep.getValue(), InstallStepSubElementName.Trigger.getValue(), TriggerAttributeName.SubSpec.getValue(), string, string2 + string3, trigger.getLocatorString());
            } else if (TriggerSubSpecValue.isValuePreDefinedForUpgradeSequence(string)) {
                String string4 = "\n\tThe requested value is one of the values that is predefined for an UpgradeSequence,\n\tthis value is not allowed in an InstallSequence.";
                InstallSequenceValidator.errorIllegalAttributeValueWithLocatorString(InstallSequenceValidator.class, "valdateThatTriggerInInstallStepContainsAllowedSubSpecValue(InstallStep anInstallStep)", InstallSequenceSubElementName.InstallStep.getValue(), InstallStepSubElementName.Trigger.getValue(), TriggerAttributeName.SubSpec.getValue(), string, string4, trigger.getLocatorString());
            }
        }
    }
}

