/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.initiate;

import java.io.File;
import java.util.Collection;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.ActualTypeOfUP;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUCF;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidSequencesInformation;
import se.ericsson.cello.sudom.parser.dom.CommonDocumentObjectInformation;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.cpp_up_version.CPP_UP_VersionProxyInterface;
import se.ericsson.cello.sudom.proxy.exceptions.UCF_ValidationException;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.sudom.proxy.nodetypespecificpiutypelist.NodeTypeSpecificPiuTypeListsProxyInterface;
import se.ericsson.cello.sudom.proxy.upcompatibilityindex.UP_CompatibilityIndexProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradelogic.UpgradeLogicProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.create.BaseUP_Data;
import se.ericsson.cello.upgradepackage.create.UpgradePackageCreator;
import se.ericsson.cello.upgradepackage.initiate.InitiateException;
import se.ericsson.cello.upgradepackage.main.HSI_VariantEnum;
import se.ericsson.cello.upgradepackage.main.handler.attributehandler.NSI_ElementPresentEnum;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.InitializeUP;
import se.ericsson.cello.upgradepackage.util.datacontainer.ValidationOfUCF;
import se.ericsson.cello.upgradepackage.util.enumer.RequestedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class Initiator {
    public void initiateMoData(UpgradePackageMoExtended upgradePackageMoExtended, File file, String string, String string2, String string3) throws InitiateException, UCF_ValidationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sinitiateMoData(UpgradePackageMoExtended anUP_MO, File anOriginalUCF, String aProductNumber, String aProductRevision, String anUCF_PathOnFtpServer)", "anUP_MO: " + upgradePackageMoExtended + "\n\tanOriginalUCF: " + file + "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tanUCF_PathOnFtpServer: " + string3);
        }
        Control control = null;
        Coordinator coordinator = null;
        DocumentObjectProxyInterface documentObjectProxyInterface = null;
        try {
            if (upgradePackageMoExtended.getRequestedTypeOfUP(null) == RequestedTypeOfUP.Undefined.getValue()) {
                UP_CompatibilityIndexProxyInterface uP_CompatibilityIndexProxyInterface;
                String string4;
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new ValidationOfUCF(this));
                documentObjectProxyInterface = this.validate(file, string, string2, string3);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new InitializeUP(this));
                control = Transaction.create();
                coordinator = Transaction.getCoordinator(control);
                CPP_UP_VersionProxyInterface cPP_UP_VersionProxyInterface = documentObjectProxyInterface.getCPP_UP_VersionProxyInterface();
                ProductDataContainer productDataContainer = cPP_UP_VersionProxyInterface.getCPP_UP_Version();
                if (productDataContainer != null) {
                    upgradePackageMoExtended.setCPP_UP_Version(productDataContainer, coordinator);
                }
                if ((string4 = (uP_CompatibilityIndexProxyInterface = documentObjectProxyInterface.getUP_CompatibilityIndexProxyInterface()).getIndex()) != null) {
                    upgradePackageMoExtended.setUP_CompatibilityIndex(string4, coordinator);
                }
                this.setBaseUP_Data(documentObjectProxyInterface, upgradePackageMoExtended, coordinator);
                this.setBasedOnUpgradePackages(documentObjectProxyInterface, upgradePackageMoExtended, coordinator);
                this.setValidSequencesInformation(documentObjectProxyInterface, upgradePackageMoExtended, coordinator);
                NodeTypeSpecificPiuTypeListsProxyInterface nodeTypeSpecificPiuTypeListsProxyInterface = documentObjectProxyInterface.getNodeTypeSpecificPiuTypeListsProxyInterface();
                Collection collection = nodeTypeSpecificPiuTypeListsProxyInterface.getNodeTypeSpecificPiuTypeLists();
                if (collection.isEmpty()) {
                    upgradePackageMoExtended.setNSI_ElementsPresent(NSI_ElementPresentEnum.NO);
                } else {
                    upgradePackageMoExtended.setNSI_ElementsPresent(NSI_ElementPresentEnum.YES);
                }
                this.setTypeOfUP(documentObjectProxyInterface, upgradePackageMoExtended, coordinator);
                this.setRequestedTypeOfUP(documentObjectProxyInterface, upgradePackageMoExtended, coordinator);
                UpgradeLogicProxyInterface upgradeLogicProxyInterface = documentObjectProxyInterface.getUpgradeLogicProxyInterface();
                if (upgradeLogicProxyInterface.getCompatibilityIndex() != -1) {
                    upgradePackageMoExtended.setSU_LogicCompatibilityIndex(upgradeLogicProxyInterface.getCompatibilityIndex(), coordinator);
                }
                if (documentObjectProxyInterface.getUpgradeLogicProxyInterface().getName() != null) {
                    upgradePackageMoExtended.setSU_LogicName(documentObjectProxyInterface.getUpgradeLogicProxyInterface().getName(), coordinator);
                }
                upgradePackageMoExtended.setSU_LMsProductDatas(documentObjectProxyInterface.getUpgradeLogicProxyInterface().getLoadModules(), coordinator);
                this.setHSI_Variant(documentObjectProxyInterface, upgradePackageMoExtended, coordinator);
                Transaction.commit(control);
            }
        }
        catch (UCF_ValidationException uCF_ValidationException) {
            throw uCF_ValidationException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "initiateMoData(UpgradePackageMoExtended anUP_MO)", "Throwable caught", throwable);
            Transaction.rollback(control);
            throw new InitiateException(throwable.toString());
        }
        finally {
            UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
        }
    }

    private void setTypeOfUP(DocumentObjectProxyInterface documentObjectProxyInterface, UpgradePackageMoExtended upgradePackageMoExtended, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setTypeOfUP(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_MO, Coordinator aCoordinator)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tanUP_MO: " + upgradePackageMoExtended + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        NodeTypeSpecificPiuTypeListsProxyInterface nodeTypeSpecificPiuTypeListsProxyInterface = documentObjectProxyInterface.getNodeTypeSpecificPiuTypeListsProxyInterface();
        Collection collection = nodeTypeSpecificPiuTypeListsProxyInterface.getNodeTypeSpecificPiuTypeLists();
        ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
        UpgradePackageMoExtended upgradePackageMoExtended2 = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null);
        TypeOfUCF typeOfUCF = null;
        typeOfUCF = upgradePackageMoExtended2 != null ? documentObjectProxyInterface.getTypeOfUCF(ActualTypeOfUP.getInstance(upgradePackageMoExtended2.getActualTypeOfUP(null))) : documentObjectProxyInterface.getTypeOfUCF();
        String string = null;
        if (typeOfUCF.equals(TypeOfUCF.Adapted)) {
            string = collection.isEmpty() ? "Standard" : "HwSensitive";
        } else if (typeOfUCF.equals(TypeOfUCF.Selective)) {
            string = "Selective";
        } else if (typeOfUCF.equals(TypeOfUCF.HW_Sensitive)) {
            string = "HwSensitive";
        } else if (typeOfUCF.equals(TypeOfUCF.DeltaAdapted)) {
            string = "Delta";
        } else if (typeOfUCF.equals(TypeOfUCF.DeltaHW_Sensitive)) {
            string = "Delta_HwSensitive";
        } else if (typeOfUCF.equals(TypeOfUCF.DeltaSelective)) {
            string = "Delta_Selective";
        } else {
            string = "Standard";
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "setTypeOfUP(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_MO, Coordinator aCoordinator)", "TypeOfUCF might be wrong. \n\ttheTypeOfUCF: " + typeOfUCF + "\n\ttheTypeOfUP (assuming): " + string);
            }
        }
        upgradePackageMoExtended.setTypeOfUP(this, string, coordinator);
    }

    private void setRequestedTypeOfUP(DocumentObjectProxyInterface documentObjectProxyInterface, UpgradePackageMoExtended upgradePackageMoExtended, Coordinator coordinator) throws MoAccessException {
        ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface;
        UpgradePackageMoExtended upgradePackageMoExtended2;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setRequestedTypeOfUP(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_MO, Coordinator aCoordinator)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tanUP_MO: " + upgradePackageMoExtended + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        TypeOfUCF typeOfUCF = documentObjectProxyInterface.getTypeOfUCF();
        RequestedTypeOfUP requestedTypeOfUP = RequestedTypeOfUP.getInstance(typeOfUCF.getValue());
        NodeTypeSpecificPiuTypeListsProxyInterface nodeTypeSpecificPiuTypeListsProxyInterface = documentObjectProxyInterface.getNodeTypeSpecificPiuTypeListsProxyInterface();
        Collection collection = nodeTypeSpecificPiuTypeListsProxyInterface.getNodeTypeSpecificPiuTypeLists();
        if (requestedTypeOfUP.equals(RequestedTypeOfUP.Adapted.getValue()) && !collection.isEmpty()) {
            requestedTypeOfUP = RequestedTypeOfUP.HW_Sensitive;
        }
        if (typeOfUCF.isDelta() && (upgradePackageMoExtended2 = (configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface()).getCurrentUpgradePackage(null)) != null) {
            int n = upgradePackageMoExtended2.getActualTypeOfUP(null);
            ActualTypeOfUP actualTypeOfUP = ActualTypeOfUP.getInstance(n);
            if (Trace.valid(UpgradePackageCreator.class, 20)) {
                Trace.debug(UpgradePackageCreator.class, 20, "setRequestedTypeOfUP(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_MO, Coordinator aCoordinator)", "\n\ttheActiveMasterActualTypeOfUP_IntValue: " + n + "\n\ttheActiveMasterActualTypeOfUP: " + actualTypeOfUP);
            }
            if (actualTypeOfUP.isAdapted()) {
                requestedTypeOfUP = RequestedTypeOfUP.DeltaAdapted;
            } else if (actualTypeOfUP.isHW_Sensitive()) {
                requestedTypeOfUP = RequestedTypeOfUP.DeltaHW_Sensitive;
            } else if (actualTypeOfUP.isSelective()) {
                requestedTypeOfUP = RequestedTypeOfUP.DeltaSelective;
            } else {
                Trace.warning(UpgradePackageCreator.class, "setRequestedTypeOfUP(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_MO, Coordinator aCoordinator)", "Received ActualTypeOfUP might be wrong,\n\treceived theActualTypeOfUP: " + actualTypeOfUP + "\n\treceived type: " + n + "\n\tAssuming RequestedTypeOfUP is Adapted. ");
                requestedTypeOfUP = RequestedTypeOfUP.Adapted;
            }
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setRequestedTypeOfUP(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_MO, Coordinator aCoordinator)", "\n\ttheTypeOfUCF: " + typeOfUCF + "\n\tReturning theRequestedTypeOfUP: " + requestedTypeOfUP);
        }
        upgradePackageMoExtended.setRequestedTypeOfUp(requestedTypeOfUP, coordinator);
    }

    private void setHSI_Variant(DocumentObjectProxyInterface documentObjectProxyInterface, UpgradePackageMoExtended upgradePackageMoExtended, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setHSI_Variant(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_MO, Coordinator aCoordinator)", "anUP_MO: " + upgradePackageMoExtended + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        NodeTypeSpecificPiuTypeListsProxyInterface nodeTypeSpecificPiuTypeListsProxyInterface = documentObjectProxyInterface.getNodeTypeSpecificPiuTypeListsProxyInterface();
        Collection collection = nodeTypeSpecificPiuTypeListsProxyInterface.getNodeTypeSpecificPiuTypeLists();
        int n = upgradePackageMoExtended.getActualTypeOfUP(coordinator);
        ActualTypeOfUP actualTypeOfUP = ActualTypeOfUP.getInstance(n);
        if (actualTypeOfUP.isDelta()) {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended2 = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null);
            if (upgradePackageMoExtended2 != null) {
                HSI_VariantEnum hSI_VariantEnum = upgradePackageMoExtended2.getHsiVariantInternal();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "setHSI_Variant(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_MO, Coordinator aCoordinator)", "theCurrent theHSI_Variant: " + hSI_VariantEnum);
                }
                upgradePackageMoExtended.setHsiVariant(hSI_VariantEnum);
            } else if (actualTypeOfUP.isHW_Sensitive()) {
                if (collection.isEmpty()) {
                    upgradePackageMoExtended.setHsiVariant(HSI_VariantEnum.HSI);
                } else {
                    upgradePackageMoExtended.setHsiVariant(HSI_VariantEnum.NSI);
                }
            } else {
                upgradePackageMoExtended.setHsiVariant(HSI_VariantEnum.NOT_VALID);
            }
        } else if (actualTypeOfUP.isHW_Sensitive()) {
            if (collection.isEmpty()) {
                upgradePackageMoExtended.setHsiVariant(HSI_VariantEnum.HSI);
            } else {
                upgradePackageMoExtended.setHsiVariant(HSI_VariantEnum.NSI);
            }
        } else {
            upgradePackageMoExtended.setHsiVariant(HSI_VariantEnum.NOT_VALID);
        }
    }

    private void setValidSequencesInformation(DocumentObjectProxyInterface documentObjectProxyInterface, UpgradePackageMoExtended upgradePackageMoExtended, Coordinator coordinator) throws MoAccessException {
        Object object;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setValidSequencesInformation(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_MO, Coordinator aCoordinator)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tanUP_MO: " + upgradePackageMoExtended + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
        UpgradePackageMoExtended upgradePackageMoExtended2 = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null);
        String string = null;
        String string2 = null;
        String string3 = null;
        if (upgradePackageMoExtended2 != null) {
            if (upgradePackageMoExtended2 instanceof UpgradePackageMoExtended) {
                string = upgradePackageMoExtended2.getBaseUP_ProductNumber(null);
                string2 = upgradePackageMoExtended2.getBaseUP_ProductRevision(null);
                object = ServiceFinder.getUpgradePackageMO_HandlerInterface();
                UpgradePackageMoExtended upgradePackageMoExtended3 = object.getUpgradePackageMo(string, string2);
                if (upgradePackageMoExtended3 != null) {
                    string3 = upgradePackageMoExtended3.getUP_CompatibilityIndex(null);
                } else if (Trace.valid(UpgradePackageCreator.class, 20)) {
                    Trace.debug(UpgradePackageCreator.class, 20, "create(ManagedObject aParent, AttrList anAttributeList, String anIdentifier, ManagedObject aSource, Coordinator aCoordinator)", "Not able to lookup the base UP MO to find the UP CompatilityIndex to use at the upgrade window check. This should not happen...\n\ttheCurrentUpgradePackageMo: " + upgradePackageMoExtended2 + "\n\ttheCurrentUpgradePackageProductNumber: " + string + "\n\ttheCurrentUpgradePackageProductRevision: " + string2);
                }
            }
        } else {
            string = upgradePackageMoExtended.getDocumentNumber(coordinator);
            string2 = upgradePackageMoExtended.getDocumentRevision(coordinator);
            string3 = upgradePackageMoExtended.getUP_CompatibilityIndex(coordinator);
        }
        object = documentObjectProxyInterface.getValidSequences(string, string2, string3);
        upgradePackageMoExtended.setSupportedUpgradeTypesStatus((ValidSequencesInformation)object);
    }

    private void setBasedOnUpgradePackages(DocumentObjectProxyInterface documentObjectProxyInterface, UpgradePackageMoExtended upgradePackageMoExtended, Coordinator coordinator) throws MoAccessException {
        TypeOfUCF typeOfUCF;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setBasedOnUpgradePackages(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_MO, Coordinator aCoordinator)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tanUP_MO: " + upgradePackageMoExtended + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        if ((typeOfUCF = documentObjectProxyInterface.getTypeOfUCF()).isDelta()) {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended2 = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(coordinator);
            if (upgradePackageMoExtended2 != null) {
                upgradePackageMoExtended.setBasedOnUpgradePackages(upgradePackageMoExtended2.getBasedOnUpgradePackages(coordinator), upgradePackageMoExtended2.getAdministrativeData(coordinator));
            } else if (Trace.valid(UpgradePackageCreator.class, 20)) {
                Trace.debug(this.getClass(), 20, "setBasedOnUpgradePackages(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_MO, Coordinator aCoordinator)", "Creation of a Delta UP when no current upgrade package exists i.e. it will only be possible to request for an installation\n\tof this UP's load modules. NOTE. It will not be possible to execute an upgrade to this UP.");
            }
        }
    }

    private void setBaseUP_Data(DocumentObjectProxyInterface documentObjectProxyInterface, UpgradePackageMoExtended upgradePackageMoExtended, Coordinator coordinator) throws MoAccessException {
        TypeOfUCF typeOfUCF;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setBaseUP_Data(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_MO, Coordinator aCoordinator)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tanUP_MO: " + upgradePackageMoExtended + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        if ((typeOfUCF = documentObjectProxyInterface.getTypeOfUCF()).isDelta()) {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended2 = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(coordinator);
            if (upgradePackageMoExtended2 != null) {
                String string = upgradePackageMoExtended2.getBaseUP_ProductNumber(coordinator);
                String string2 = upgradePackageMoExtended2.getBaseUP_ProductRevision(coordinator);
                String string3 = upgradePackageMoExtended2.getBaseUP_ProductName(coordinator);
                String string4 = upgradePackageMoExtended2.getBaseUP_UCF_Path(coordinator);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setBaseUP_Data(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpgradePackageMoExtended anUP_MO, Coordinator aCoordinator)", "The UP (product no. " + upgradePackageMoExtended.getDocumentNumber(coordinator) + " with revision " + upgradePackageMoExtended.getDocumentRevision(coordinator) + " is a Delta UP.\n\tThe base (root) UP has product " + "no. " + string + " and revision " + string2 + ".");
                }
                upgradePackageMoExtended.setBaseUP_Data(new BaseUP_Data(string, string2, string3, string4), coordinator);
            } else {
                Trace.warning(this.getClass(), "createBaseUP_Data(ProductData aProductData, Coordinator aCoordinator)", "Creation of a Delta UP when no current upgrade package exists i.e. it will only be possible to request for an installation\n\tof this UP's load modules. NOTE. It will not be possible to execute an upgrade to this UP.Delta UP product number: " + upgradePackageMoExtended.getDocumentRevision(coordinator) + "Delta UP product revision: " + upgradePackageMoExtended.getDocumentRevision(coordinator));
            }
        } else {
            upgradePackageMoExtended.setBaseUP_Data(new BaseUP_Data(upgradePackageMoExtended.getDocumentNumber(coordinator), upgradePackageMoExtended.getDocumentRevision(coordinator), upgradePackageMoExtended.getProductName(coordinator), upgradePackageMoExtended.getUpgradeControlFilePath(coordinator)), coordinator);
        }
    }

    private DocumentObjectProxyInterface validate(File file, String string, String string2, String string3) throws UCF_ValidationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validate(File anUCF, String aProductNumber, String aProductRevision, String anUCF_PathOnFtpServer)", "anUCF: " + SuLib.toString(file) + "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tanUCF_PathOnFtpServer: " + string3);
        }
        DocumentObjectProxyInterface documentObjectProxyInterface = null;
        try {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "validate(File anUCF, String aProductNumber, String aProductRevision, String anUCF_PathOnFtpServer)", "Parsing of the UCF is started.");
            }
            documentObjectProxyInterface = UCF_ParserFacade.parseAllMainElements(string, string2, file.getAbsolutePath(), true);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "validate(File anUCF, String aProductNumber, String aProductRevision, String anUCF_PathOnFtpServer)", "The UCF has been parsed.");
            }
            CommonDocumentObjectInformation.getInstance().printIgnoredUnknownAttributesWarnings(this.getClass(), "validate(File anUCF, String aProductNumber, String aProductRevision, String anUCF_PathOnFtpServer)");
            CommonDocumentObjectInformation.getInstance().printIgnoredUnknownSubElementsWarnings(this.getClass(), "validate(File anUCF, String aProductNumber, String aProductRevision, String anUCF_PathOnFtpServer)");
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "validate(File anUCF, String aProductNumber, String aProductRevision, String anUCF_PathOnFtpServer)", "Cross-reference validation of the UCF is started.");
            }
            documentObjectProxyInterface.validateUCF(string3);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "validate(File anUCF, String aProductNumber, String aProductRevision, String anUCF_PathOnFtpServer)", "The validation is finished.");
            }
            return documentObjectProxyInterface;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            throw new UCF_ValidationException(upgradeControlFileParserException.toString());
        }
        catch (UCF_ValidationException uCF_ValidationException) {
            throw uCF_ValidationException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "validate(File anUCF, String aProductNumber, String aProductRevision, String anUCF_PathOnFtpServer)", "Throwable caught: " + throwable, throwable);
            throw new UCF_ValidationException(throwable.toString());
        }
    }
}

