/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.install;

import java.util.Enumeration;
import java.util.Vector;
import se.ericsson.cello.equipment.suaccess.JvmMoSU_Access;
import se.ericsson.cello.managedelement.suaccess.WebServerMoSU_Access;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class AutoconfigureSelectiveInstall {
    public void configure(Coordinator coordinator) throws MoAccessException {
        SwAllocationMoSU_Access swAllocationMoSU_Access;
        ManagedObject managedObject;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "configure(Coordinator aCoordinator)", "aCoordinator: " + coordinator);
        }
        SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface();
        Vector vector = swAllocationMO_HandlerInterface.getConnectedSlots(coordinator);
        RepertoireMO_HandlerInterface repertoireMO_HandlerInterface = ServiceFinder.getRepertoireMO_HandlerInterface();
        try {
            if (!this.isWebServerConnected(vector)) {
                managedObject = repertoireMO_HandlerInterface.createRepertoire("Cello_WebServer", "Cello_WebServer", "Cello_WebServer", coordinator);
                swAllocationMoSU_Access = swAllocationMO_HandlerInterface.createSwAllocation("WebServer", "WebServer", coordinator);
                swAllocationMoSU_Access.actionAddSlot(((SingletonMoFactory)MoFactoryMgr.instance().lookup("WebServer")).getMo(), coordinator);
                swAllocationMoSU_Access.actionAddRepertoire(managedObject, coordinator);
                Trace.info(this.getClass(), "configure(Coordinator aCoordinator)", "Autoconfiguration due to Selective Install has been executed, i.e.\n\t1) A SwAllocation Mo with role 'WebServer' and a Repertoire Mo with name 'Cello_WebServer' has been created.\n\t2) The created Repertoire Mo and the WebServer Mo has been connected to the created SwAllocation Mo.");
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "configure(Coordinator aCoordinator)", "MoAccessException caught at autoconfiguration due to Selective Install (WebServer autoconfiguration).", moAccessException);
        }
        try {
            if (!this.isJVM_Connected(vector)) {
                managedObject = repertoireMO_HandlerInterface.createRepertoire("Cello_JVM", "Cello_JVM", "Cello_JVM", coordinator);
                swAllocationMoSU_Access = swAllocationMO_HandlerInterface.createSwAllocation("JVM", "JVM", coordinator);
                MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
                JvmMoSU_Access jvmMoSU_Access = (JvmMoSU_Access)((SingletonMoFactory)moFactory).getMo();
                swAllocationMoSU_Access.actionAddSlot((ManagedObject)jvmMoSU_Access, coordinator);
                swAllocationMoSU_Access.actionAddRepertoire(managedObject, coordinator);
                Trace.info(this.getClass(), "configure(Coordinator aCoordinator)", "Autoconfiguration due to Selective Install has been executed, i.e.\n\t1) A SwAllocation Mo with role 'JVM' and a Repertoire Mo with name 'Cello_JVM' has been created.\n\t2) The created Repertoire Mo and the JVM Mo has been connected to the created SwAllocation Mo.");
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "configure(Coordinator aCoordinator)", "MoAccessException caught at autoconfiguration due to Selective Install (JVM autoconfiguration).", moAccessException);
        }
    }

    private boolean isJVM_Connected(Vector vector) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isJVM_Connected(Vector aConnectedSlots)", "aConnectedSlots: " + vector);
        }
        Enumeration enumeration = vector.elements();
        ManagedObject managedObject = null;
        while (enumeration.hasMoreElements()) {
            managedObject = (ManagedObject)enumeration.nextElement();
            if (!(managedObject instanceof JvmMoSU_Access)) continue;
            return true;
        }
        return false;
    }

    private boolean isWebServerConnected(Vector vector) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isWebServerConnected(Vector aConnectedSlots)", "aConnectedSlots: " + vector);
        }
        Enumeration enumeration = vector.elements();
        ManagedObject managedObject = null;
        while (enumeration.hasMoreElements()) {
            managedObject = (ManagedObject)enumeration.nextElement();
            if (!(managedObject instanceof WebServerMoSU_Access)) continue;
            return true;
        }
        return false;
    }
}

