/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.piutypesupervisor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypePropertyListener;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypePropertySupportAdaptor;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypePropertySupportHandling;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.hwsensitive.PiuTypeStateInformationEvent;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class PiuTypePropertySupportHandler
implements PiuTypePropertySupportHandling,
PropertyChangeListener {
    private boolean myIsListening = false;
    private HashSet myListenersOnAllPiuTypes = new HashSet();
    private HashMap myListenersOnSpecificPiuTypes = new HashMap();

    public PiuTypePropertySupportHandler() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "PiuTypePropertySupportHandler( )");
        }
    }

    public void addAsListener(PiuTypePropertyListener piuTypePropertyListener) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListener(PiuTypePropertyListener aPiuTypePropertyListener)", "aPiuTypePropertyListener: " + piuTypePropertyListener);
        }
        this.myListenersOnAllPiuTypes.add(piuTypePropertyListener);
        if (!this.myIsListening) {
            ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.PiuTypeState, this);
            this.myIsListening = true;
        }
    }

    public void addAsListener(PiuTypePropertyListener piuTypePropertyListener, ManagedObject[] managedObjectArray) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListener(PiuTypePropertyListener aPiuTypePropertyListener, ManagedObject[] aPiuTypeMOs)", "aPiuTypePropertyListener: " + piuTypePropertyListener + "\n\taPiuTypeMOs: " + SuLib.toString(managedObjectArray));
        }
        PiuTypeMoSU_Access piuTypeMoSU_Access = null;
        ProductNumberAndRevision productNumberAndRevision = null;
        HashSet<PiuTypePropertyListener> hashSet = null;
        try {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                piuTypeMoSU_Access = (PiuTypeMoSU_Access)managedObjectArray[i];
                productNumberAndRevision = this.getKeyForListenersOnSpecificPiuType(piuTypeMoSU_Access);
                if (productNumberAndRevision == null) {
                    productNumberAndRevision = this.createKeyForListenersOnSpecificPiuType(piuTypeMoSU_Access);
                    hashSet = new HashSet<PiuTypePropertyListener>();
                } else {
                    hashSet = (HashSet<PiuTypePropertyListener>)this.myListenersOnSpecificPiuTypes.get(productNumberAndRevision);
                }
                hashSet.add(piuTypePropertyListener);
                this.myListenersOnSpecificPiuTypes.put(productNumberAndRevision, hashSet);
            }
            if (!this.myIsListening) {
                ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.PiuTypeState, this);
                this.myIsListening = true;
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "addAsListener(PiuTypePropertyListener aPiuTypePropertyListener, ManagedObject[] aPiuTypeMOs)", "Throwable caught when a client is trying add it self as listener,\n\taPiuTypePropertyListener: " + piuTypePropertyListener + "\n\taPiuTypeMOs: " + SuLib.toString(managedObjectArray) + "\n\tThrowable info: " + throwable);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent evt)", "evt: " + propertyChangeEvent);
        }
        try {
            if (propertyChangeEvent.getNewValue() instanceof PiuTypeStateInformationEvent) {
                PiuTypeStateInformationEvent piuTypeStateInformationEvent = (PiuTypeStateInformationEvent)propertyChangeEvent.getNewValue();
                this.sendNewStateToListenersOnAllPiuTypes(piuTypeStateInformationEvent.piuTypeMoSU_Access, piuTypeStateInformationEvent.isAllLM_FilesInstalled);
                this.sendNewStateToListenersOnSpecificPiuTypes(piuTypeStateInformationEvent.piuTypeMoSU_Access, piuTypeStateInformationEvent.isAllLM_FilesInstalled);
            } else {
                Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent evt)", "Unknown type of object received in a PropertyChangeEvent (ignored),\n\tExpected object: PiuTypeStateInformationEvent ,\n\tReceived object: " + propertyChangeEvent.getNewValue());
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "propertyChange(PropertyChangeEvent evt)", "Throwable caught when handling PiuType state change,\n\tevt: " + propertyChangeEvent + "\n\tThrowable info: " + throwable);
        }
    }

    public void removeAsListener(PiuTypePropertyListener piuTypePropertyListener) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListener(PiuTypePropertyListener aPiuTypepropertyListener)", "aPiuTypepropertyListener: " + piuTypePropertyListener);
        }
        this.myListenersOnAllPiuTypes.remove(piuTypePropertyListener);
        if (this.myListenersOnAllPiuTypes.isEmpty() && this.myListenersOnSpecificPiuTypes.isEmpty()) {
            ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.PiuTypeState, this);
            this.myIsListening = false;
        }
    }

    public void removeAsListener(PiuTypePropertyListener piuTypePropertyListener, ManagedObject[] managedObjectArray) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListener(PiuTypePropertyListener aPiuTypePropertyListener, ManagedObject[] aPiuTypeMOs)", "aPiuTypePropertyListener: " + piuTypePropertyListener + "\n\taPiuTypeMOs: " + SuLib.toString(managedObjectArray));
        }
        PiuTypeMoSU_Access piuTypeMoSU_Access = null;
        ProductNumberAndRevision productNumberAndRevision = null;
        HashSet hashSet = null;
        try {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                piuTypeMoSU_Access = (PiuTypeMoSU_Access)managedObjectArray[i];
                productNumberAndRevision = this.getKeyForListenersOnSpecificPiuType(piuTypeMoSU_Access);
                if (productNumberAndRevision == null) continue;
                hashSet = (HashSet)this.myListenersOnSpecificPiuTypes.get(productNumberAndRevision);
                hashSet.remove(piuTypePropertyListener);
                if (!hashSet.isEmpty()) continue;
                this.myListenersOnSpecificPiuTypes.remove(productNumberAndRevision);
            }
            if (this.myListenersOnAllPiuTypes.isEmpty() && this.myListenersOnSpecificPiuTypes.isEmpty()) {
                ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.PiuTypeState, this);
                this.myIsListening = false;
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "removeAsListener(PiuTypePropertyListener aPiuTypePropertyListener, ManagedObject[] aPiuTypeMOs)", "Throwable caught when a client is trying remove it self as listener,\n\taPiuTypePropertyListener: " + piuTypePropertyListener + "\n\taPiuTypeMOs: " + SuLib.toString(managedObjectArray) + "\n\tThrowable info: " + throwable);
        }
    }

    private ProductNumberAndRevision createKeyForListenersOnSpecificPiuType(PiuTypeMoSU_Access piuTypeMoSU_Access) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createKeyForListenersOnSpecificPiuTypes(PiuTypeMoSU_Access aPiuTypeMO)", "aPiuTypeMO: " + piuTypeMoSU_Access);
        }
        ProductNumberAndRevision productNumberAndRevision = null;
        productNumberAndRevision = ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3") ? new ProductNumberAndRevision(piuTypeMoSU_Access.getProductNumberOpt(null), piuTypeMoSU_Access.getProductRevisionOpt(null)) : new ProductNumberAndRevision(StringHandler.optimize(piuTypeMoSU_Access.getProductNumber(null)), StringHandler.optimize(piuTypeMoSU_Access.getProductRevision(null)));
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "createKeyForListenersOnSpecificPiuTypes(PiuTypeMoSU_Access aPiuTypeMO)", "RETURNS - theProductNumberAndRevision: " + productNumberAndRevision);
        }
        return productNumberAndRevision;
    }

    private ProductNumberAndRevision getKeyForListenersOnSpecificPiuType(PiuTypeMoSU_Access piuTypeMoSU_Access) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getKeyForListenersOnSpecificPiuType(PiuTypeMoSU_Access aPiuTypeMO)", "aPiuTypeMO: " + piuTypeMoSU_Access);
        }
        Iterator iterator = this.myListenersOnSpecificPiuTypes.keySet().iterator();
        ProductNumberAndRevision productNumberAndRevision = null;
        ProductNumberAndRevision productNumberAndRevision2 = this.createKeyForListenersOnSpecificPiuType(piuTypeMoSU_Access);
        while (iterator.hasNext() && !(productNumberAndRevision = (ProductNumberAndRevision)iterator.next()).equals(productNumberAndRevision2)) {
            productNumberAndRevision = null;
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getKeyForListenersOnSpecificPiuType(PiuTypeMoSU_Access aPiuTypeMO)", "Returns theExistingKey: " + productNumberAndRevision);
        }
        return productNumberAndRevision;
    }

    private void sendNewStateToListenersOnAllPiuTypes(PiuTypeMoSU_Access piuTypeMoSU_Access, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendNewStateToListenersOnAllPiuTypes(PiuTypeMoSU_Access aPiuTypeMO, boolean anIsLoadModuleFilesInstalled)", "aPiuTypeMO: " + piuTypeMoSU_Access + "\n\tanIsLoadModuleFilesInstalled: " + bl);
        }
        Iterator iterator = this.myListenersOnAllPiuTypes.iterator();
        PiuTypePropertyListener piuTypePropertyListener = null;
        while (iterator.hasNext()) {
            piuTypePropertyListener = (PiuTypePropertyListener)iterator.next();
            PiuTypePropertySupportAdaptor.instance().loadModuleFilesInstallState(piuTypePropertyListener, (ManagedObject)piuTypeMoSU_Access, bl);
        }
    }

    private void sendNewStateToListenersOnSpecificPiuTypes(PiuTypeMoSU_Access piuTypeMoSU_Access, boolean bl) throws MoAccessException {
        ProductNumberAndRevision productNumberAndRevision;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendNewStateToListenersOnSpecificPiuTypes(PiuTypeMoSU_Access aPiuTypeMO, boolean anIsLoadModuleFilesInstalled)", "aPiuTypeMO: " + piuTypeMoSU_Access + "\n\tanIsLoadModuleFilesInstalled: " + bl);
        }
        if ((productNumberAndRevision = this.getKeyForListenersOnSpecificPiuType(piuTypeMoSU_Access)) != null) {
            HashSet hashSet = (HashSet)this.myListenersOnSpecificPiuTypes.get(productNumberAndRevision);
            Iterator iterator = hashSet.iterator();
            PiuTypePropertyListener piuTypePropertyListener = null;
            while (iterator.hasNext()) {
                piuTypePropertyListener = (PiuTypePropertyListener)iterator.next();
                PiuTypePropertySupportAdaptor.instance().loadModuleFilesInstallState(piuTypePropertyListener, (ManagedObject)piuTypeMoSU_Access, bl);
            }
        }
    }
}

