/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.trace.writers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.upgradepackage.trace.datacontainer.LogContainer;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceInfoDataContainer;
import se.ericsson.cello.upgradepackage.trace.exception.LogFileNotInUseException;
import se.ericsson.cello.upgradepackage.trace.writers.TraceLogWriterInterface;
import se.ericsson.cello.upgradepackage.trace.writers.UpgradeTraceWriter;

public abstract class TraceLogWriter
extends UpgradeTraceWriter
implements TraceLogWriterInterface,
PropertyChangeListener {
    public void clearOut() throws LogFileNotInUseException {
        throw new LogFileNotInUseException("OutputMode is not to file or logService.");
    }

    public void flushOut() throws OperationNotAllowedException {
        throw new OperationNotAllowedException("The upgrade trace output is currently not directed to a file.", "UpgradeTrace");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void clear(TraceInfoDataContainer traceInfoDataContainer) {
    }

    protected String getLogMessageString(LogContainer logContainer) {
        return this.getLogMessageString(logContainer.getSloganTitle(), logContainer.getTimeStamp(), logContainer.getSU_Version(), logContainer.getTheClass(), logContainer.getClassName(), logContainer.getMethod(), logContainer.getMessage(), logContainer.getThrowable());
    }

    protected String getLogMessageString(String string, String string2, String string3, Class clazz, String string4, String string5, String string6, Throwable throwable) {
        String string7 = "\n" + string2 + ",  " + string3 + "\nClass:\t" + string4 + "\nMethod: " + string5;
        if (string6 != null) {
            string7 = string.equals("Log") ? string7 + "\n" + string + ":\t" + string6 : (string.equals("Debug") ? string7 + "\n" + string + ":  " + string6 : string7 + "\n" + string + ": " + string6);
        }
        if (throwable != null) {
            string7 = string7 + "\nThrowable: " + throwable;
            string7 = string7 + "\nStackTrace: " + this.getStackTrace(throwable);
        }
        return string7;
    }

    protected String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    protected String getLogInfoForTeLog(LogContainer logContainer) {
        String string = "\n\tLog Class: " + logContainer.getTheClass() + "\n\tLog Method: " + logContainer.getMethod() + "\n\tLog Message: " + logContainer.getMessage();
        if (logContainer.getThrowable() != null) {
            string = string + "\n\tLog Throwable: " + logContainer.getThrowable();
        }
        return string;
    }

    protected boolean isInSuSimEnvironment() {
        boolean bl = false;
        Properties properties = new Properties(System.getProperties());
        String string = properties.getProperty("SU_SIM");
        if (string != null && string.equals("yes")) {
            bl = true;
        }
        return bl;
    }
}

