/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade;

import java.util.EventObject;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.eqaccess.PIU_AdmStateListenerAcessInterface;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.AdminStateHasBeenSetEvent;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.NotifyWhenAdmStateHasBeenSetEvent;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.PIU_AdmStateHandlerException;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.PIU_AdmStateHandlerFactory;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.UpgradeablePIU_AdmStateListenerInterface;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;

public class PIU_AdmStateHandler
extends Thread
implements PIU_AdmStateListenerAcessInterface {
    private Vector myListOfPIUs = new Vector();
    private Vector myListOfPIUsWhereAdminStateHasBeenSet = new Vector();
    private boolean isAdmStatesSuccessfullySet = false;
    private boolean myContinueLoop = true;
    private UpgradeablePIU_AdmStateListenerInterface myUpgradeablePIU_AdmStateListenerInterface = null;
    private BlockingQueue myBlockingQueue = null;

    public PIU_AdmStateHandler() {
        super("PIU_AdmStateHandler");
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "PIU_AdmStateHandler()");
        }
    }

    public void admStateHasBeenSet(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "admStateHasBeenSet(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        if (this.myBlockingQueue != null) {
            this.myBlockingQueue.enqueue((Object)new AdminStateHasBeenSetEvent(this, genericUpgradeablePlugInUnit));
        } else {
            Trace.info(this.getClass(), "admStateHasBeenSet()", "A notification regarding the adm state has been received from a PIU MO when not expected (ignored).\n\tmyUpgradeablePIU_AdmStateListenerInterface: " + this.myUpgradeablePIU_AdmStateListenerInterface + "\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tmyListOfPIUs: " + this.getListOfPIUs() + "\n\tmyListOfPIUsWhereAdminStateHasBeenSet: " + this.getListOfPIUsWhereAdminStateHasBeenSet());
        }
    }

    public void waitingForAdminStateToBeSet(UpgradeablePIU_AdmStateListenerInterface upgradeablePIU_AdmStateListenerInterface) throws PIU_AdmStateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitingForAdminStateToBeSet(UpgradeablePIU_AdmStateListenerInterface anUpgradeablePIU_AdmStateListenerInterface)", "anUpgradeablePIU_AdmStateListenerInterface: " + upgradeablePIU_AdmStateListenerInterface);
        }
        if (!this.isListOfPIUsEmpty()) {
            if (this.myBlockingQueue == null) {
                Trace.error(this.getClass(), "waitingForAdminStateToBeSet(UpgradeablePIU_AdmStateListenerInterface anUpgradeablePIU_AdmStateListenerInterface)", "The queue used by the thread for handling of admin state of an upgradeable PIU has been stopped.\n\tCan't proceed the execution.");
                PIU_AdmStateHandlerFactory.instance().removePIU_AdmStateHandlers(this);
                throw new PIU_AdmStateHandlerException("The queue used by the thread for handling of admin state of an upgradeable PIU has been stopped.\n\tCan't proceed the execution.\n\tmyUpgradeablePIU_AdmStateListenerInterface: " + this.myUpgradeablePIU_AdmStateListenerInterface);
            }
            this.myBlockingQueue.enqueue((Object)new NotifyWhenAdmStateHasBeenSetEvent(this, upgradeablePIU_AdmStateListenerInterface));
            if (!this.waitForAdmStateSettingsCompleteIndication()) {
                Trace.error(this.getClass(), "waitingForAdminStateToBeSet(UpgradeablePIU_AdmStateListenerInterface anUpgradeablePIU_AdmStateListenerInterface)", "The setting of adm state for all requested PIUs failed (at least one PIU failed).\n\tRequested PIUs: " + this.getListOfPIUs() + "\n\tmyListOfPIUsWhereAdminStateHasBeenSet: " + this.getListOfPIUsWhereAdminStateHasBeenSet());
                PIU_AdmStateHandlerFactory.instance().removePIU_AdmStateHandlers(this);
                throw new PIU_AdmStateHandlerException("The setting of adm state for all requested PIUs failed (at least one PIU failed).\n\tRequested PIUs: " + this.getListOfPIUs() + "\n\tmyListOfPIUsWhereAdminStateHasBeenSet: " + this.getListOfPIUsWhereAdminStateHasBeenSet());
            }
        }
        PIU_AdmStateHandlerFactory.instance().removePIU_AdmStateHandlers(this);
    }

    public void setAdministrativeStateReq(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, int n, Coordinator coordinator) throws PIU_AdmStateHandlerException {
        try {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "setAdministrativeStateReq(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdminState, Coordinator aCoordinator)", "Setting administrative state on upgradable PlugInUnit.\n\tUpgradable PIU: " + genericUpgradeablePlugInUnit + "\n\tAdminState: " + n);
            }
            PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
            if (genericUpgradeablePlugInUnit instanceof PlugInUnitMoSU_Access) {
                boolean bl;
                if (this.myBlockingQueue == null) {
                    this.myBlockingQueue = new BlockingQueue();
                    this.start();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "setAdministrativeStateReq(int anAdminState, Coordinator aCoordinator)", "A thread has been requested to be started to handle adm state indication signal from the PIU MO.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator));
                    }
                }
                if (bl = pIU_MO_HandlerInterface.setAdministrativeStateUpgrade((PlugInUnitMoSU_Access)genericUpgradeablePlugInUnit, n, this, coordinator)) {
                    this.addUpgradePIU_ToListOfPIUs(genericUpgradeablePlugInUnit);
                }
            } else {
                pIU_MO_HandlerInterface.setAdministrativeState(genericUpgradeablePlugInUnit, n, coordinator);
            }
        }
        catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
            throw new PIU_AdmStateHandlerException("PIU_MO_HandlerException caught at execution of the setting of admin state for the upgradeable PluInUnit.Exception data: " + (Object)((Object)pIU_MO_HandlerException));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setAdministrativeStateReq(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "Throwable caught at execution of the setting of admin state for the upgradeable PluInUnit.", throwable);
            throw new PIU_AdmStateHandlerException("Throwable caught at execution of the setting of admin state for the upgradeable PluInUnit.Throwable data: " + throwable);
        }
    }

    public void setAdministrativeStateSwitchReq(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, int n, int n2, Coordinator coordinator) throws PIU_AdmStateHandlerException {
        try {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "setAdministrativeStateSwitchReq(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdminState, int aSwitchAtLockOrNot, Coordinator aCoordinator)", "Setting administrative state on upgradable PlugInUnit.\n\tUpgradable PIU: " + genericUpgradeablePlugInUnit + "\n\tAdminState: " + n);
            }
            PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
            if (genericUpgradeablePlugInUnit instanceof PlugInUnitMoSU_Access) {
                boolean bl;
                if (this.myBlockingQueue == null) {
                    this.myBlockingQueue = new BlockingQueue();
                    this.start();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "setAdministrativeStateSwitchReq(int anAdminState, int aSwitchAtLockOrNot, Coordinator aCoordinator)", "A thread has been requested to be started to handle adm state indication signals from the PIU MO.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taSwitchAtLockOrNot: " + n2 + "\n\taCoordinator: " + SuLib.toString(coordinator));
                    }
                }
                if (bl = pIU_MO_HandlerInterface.setAdministrativeStateSwitchUpgrade((PlugInUnitMoSU_Access)genericUpgradeablePlugInUnit, n, n2, this, coordinator)) {
                    this.addUpgradePIU_ToListOfPIUs(genericUpgradeablePlugInUnit);
                }
            } else {
                pIU_MO_HandlerInterface.setAdministrativeStateSwitch(genericUpgradeablePlugInUnit, n, n2, coordinator);
            }
        }
        catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
            throw new PIU_AdmStateHandlerException("PIU_MO_HandlerException caught at execution of the setting of admin state for the upgradeable PluInUnit.Exception data: " + pIU_MO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setAdministrativeStateSwitchReq(int anAdminState, int aSwitchAtLockOrNot, Coordinator aCoordinator)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taSwitchAtLockOrNot: " + n2 + "Throwable caught at execution of the setting of admin state for the upgradeable PluInUnit.", throwable);
            throw new PIU_AdmStateHandlerException("Throwable caught at execution of the setting of admin state for the upgradeable PluInUnit.Throwable data: " + throwable.toString());
        }
    }

    public void run() {
        this.waitForAdmStateToBeSet();
    }

    private void notifyAdmStatesCompleteSet() throws PIU_AdmStateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "notifyAdmStatesCompleteSet ()");
        }
        this.myContinueLoop = false;
    }

    private boolean waitForAdmStateSettingsCompleteIndication() throws PIU_AdmStateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForAdmStateSettingsCompleteIndication ()");
        }
        try {
            int n = 0;
            while (this.myContinueLoop) {
                TimeHandler.sleep(1000L);
                if (++n != 100 && n != 200 && n != 300 && n != 400 && n != 500 && n != 600) continue;
                Trace.log1(this.getClass(), "waitForAdmStateSettingsCompleteIndication()", "Waited " + n + " seconds");
            }
            return this.isAdmStatesSuccessfullySet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "waitForAdmStateSettingsCompleteIndication ()", "Throwable caught while waiting for adm state indications.\n\tmyListOfPIUs: " + this.getListOfPIUs() + "\n\tmyListOfPIUsWhereAdminStateHasBeenSet: " + this.getListOfPIUsWhereAdminStateHasBeenSet() + "\n\tError data:" + throwable.toString());
            throw new PIU_AdmStateHandlerException("Error caught while waiting for adm state indications.\n\tmyListOfPIUs: " + this.getListOfPIUs() + "\n\tmyListOfPIUsWhereAdminStateHasBeenSet: " + this.getListOfPIUsWhereAdminStateHasBeenSet() + "\n\tError data: " + throwable.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAdmStateToBeSet() {
        try {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "waitForAdmStateToBeSet ( )", "New THREAD handling the admin state for a PIU has been STARTED.\n\tmyListOfPIUs: " + this.getListOfPIUs());
            }
            boolean bl = true;
            while (bl) {
                EventObject eventObject;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "waitForAdmStateToBeSet ()", "Waiting for event objects to be received.");
                }
                EventObject eventObject2 = (EventObject)this.myBlockingQueue.dequeue();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "waitForAdmStateToBeSet ()", "Event object received - " + eventObject2.getClass().getName() + "Event data: " + eventObject2);
                }
                if (eventObject2 instanceof AdminStateHasBeenSetEvent) {
                    eventObject = (AdminStateHasBeenSetEvent)eventObject2;
                    if (this.existsUPIU_InListOfPIUs(eventObject.upgradeablePlugInUnit) && !this.existsUPIU_InListOfPIUsWhereAdmStateHasBeenSet(eventObject.upgradeablePlugInUnit)) {
                        this.addUpgradePIU_ToListOfPIUsWhereAdminStateHasBeenSet(eventObject.upgradeablePlugInUnit);
                    }
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "waitForAdmStateToBeSet ()", "Admin state has been set for an upgradeable PIU.\n\tupgradeablePlugInUnit: " + eventObject.upgradeablePlugInUnit + "\n\tmyListOfPIUs: " + this.getListOfPIUs() + "\n\tmyListOfPIUsWhereAdminStateHasBeenSet: " + this.getListOfPIUsWhereAdminStateHasBeenSet() + "\n\tmyUpgradeablePIU_AdmStateListenerInterface: " + this.myUpgradeablePIU_AdmStateListenerInterface);
                    }
                    if (this.myUpgradeablePIU_AdmStateListenerInterface == null || !this.isIndicationReceivedForAllPIUs()) continue;
                    this.isAdmStatesSuccessfullySet = true;
                    this.notifyAdmStatesCompleteSet();
                    bl = false;
                    continue;
                }
                if (eventObject2 instanceof NotifyWhenAdmStateHasBeenSetEvent) {
                    eventObject = (NotifyWhenAdmStateHasBeenSetEvent)eventObject2;
                    this.myUpgradeablePIU_AdmStateListenerInterface = ((NotifyWhenAdmStateHasBeenSetEvent)eventObject).upgradeablePIU_AdmStateListenerInterface;
                    if (this.isIndicationReceivedForAllPIUs()) {
                        this.isAdmStatesSuccessfullySet = true;
                        this.notifyAdmStatesCompleteSet();
                        bl = false;
                        continue;
                    }
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "waitForAdmStateToBeSet ()", "Waiting for adm state to be set for at least one more PIU.\n\tmyListOfPIUs: " + this.getListOfPIUs() + "\n\tmyListOfPIUsWhereAdminStateHasBeenSet: " + this.getListOfPIUsWhereAdminStateHasBeenSet());
                    continue;
                }
                Trace.error(this.getClass(), "waitForAdmStateToBeSet ()", "Unexpected event received while waiting for admin state change indication from PIU MO (ignoring).\n\tthe name of Event: " + eventObject2.getClass().getName() + "\n\tEvent data: " + eventObject2);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "run ( )", "The THREAD handling the admin state for an upgradeable PIU is going to be STOPPED.\n\tmyListOfPIUs: " + this.getListOfPIUs());
            }
        }
        catch (InterruptedException interruptedException) {
            Trace.error(this.getClass(), "waitForAdmStateToBeSet ()", "The wait mechanism for a response from the adm state set request was interrupted due to exception.\n\tInterruptedException: " + interruptedException.toString(), interruptedException);
            try {
                this.isAdmStatesSuccessfullySet = false;
                this.notifyAdmStatesCompleteSet();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "waitForAdmStateToBeSet ()", "The wait mechanism for a response from the adm state set request was interrupted due to exception.\n\tException: " + exception.toString(), exception);
            try {
                this.isAdmStatesSuccessfullySet = false;
                this.notifyAdmStatesCompleteSet();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        catch (Error error) {
            Trace.error(this.getClass(), "waitForAdmStateToBeSet ()", "The wait mechanism for a response from the adm state set request was interrupted due to exception.\n\tError: " + error.toString(), error);
            try {
                this.isAdmStatesSuccessfullySet = false;
                this.notifyAdmStatesCompleteSet();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            PIU_AdmStateHandlerFactory.instance().removePIU_AdmStateHandlers(this);
        }
    }

    private synchronized Vector getListOfPIUs() {
        return this.myListOfPIUs;
    }

    private synchronized Vector getListOfPIUsWhereAdminStateHasBeenSet() {
        return this.myListOfPIUsWhereAdminStateHasBeenSet;
    }

    private synchronized boolean isListOfPIUsEmpty() {
        return this.myListOfPIUs.isEmpty();
    }

    private synchronized void addUpgradePIU_ToListOfPIUs(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        this.myListOfPIUs.addElement(genericUpgradeablePlugInUnit);
    }

    private synchronized void addUpgradePIU_ToListOfPIUsWhereAdminStateHasBeenSet(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        this.myListOfPIUsWhereAdminStateHasBeenSet.addElement(genericUpgradeablePlugInUnit);
    }

    private synchronized boolean isIndicationReceivedForAllPIUs() {
        return this.myListOfPIUs.size() <= this.myListOfPIUsWhereAdminStateHasBeenSet.size();
    }

    private synchronized boolean existsUPIU_InListOfPIUs(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "existsUPIU_InListOfPIUs(Vector aPIU_List, GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit)", "\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        Iterator iterator = this.myListOfPIUs.iterator();
        GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit2 = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            genericUpgradeablePlugInUnit2 = (GenericUpgradeablePlugInUnit)iterator.next();
            if (!genericUpgradeablePlugInUnit2.toString().equals(genericUpgradeablePlugInUnit.toString())) continue;
            bl = true;
            break;
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "existsUPIU_InListOfPIUs(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit)", "RETURNS - theIsFound: " + bl);
        }
        return bl;
    }

    private synchronized boolean existsUPIU_InListOfPIUsWhereAdmStateHasBeenSet(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "existsUPIU_InListOfPIUsWhereAdmStateHasBeenSet(Vector aPIU_List, GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit)", "\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        Iterator iterator = this.myListOfPIUsWhereAdminStateHasBeenSet.iterator();
        GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit2 = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            genericUpgradeablePlugInUnit2 = (GenericUpgradeablePlugInUnit)iterator.next();
            if (!genericUpgradeablePlugInUnit2.toString().equals(genericUpgradeablePlugInUnit.toString())) continue;
            bl = true;
            break;
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "existsUPIU_InListOfPIUsWhereAdmStateHasBeenSet(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit)", "RETURNS - theIsFound: " + bl);
        }
        return bl;
    }
}

