/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.datacontainer;

import java.util.Vector;
import se.ericsson.cello.equipment.GenericProgramBase;
import se.ericsson.cello.moframework.ManagedObject;

public class ProgramsContainer {
    public static final String DISABLED_PROGRAMS = "disabled";
    public static final String MO_REMOVED_PROGRAMS = "MoRemovedException";
    public static final String OTHERS = "other";
    public static final int TYPE_ALL = 0;
    public static final int TYPE_DISABLED_PROGRAMS = 1;
    public static final int TYPE_MO_REMOVED_PROGRAMS = 2;
    public static final int TYPE_OTHERS = 3;
    public Vector allPgms = new Vector();
    public Vector disabledPgms = new Vector();
    public Vector moRemovePgms = new Vector();
    public Vector otherPgms = new Vector();

    public void addProgram(String string, GenericProgramBase genericProgramBase) {
        ProgramItem programItem = new ProgramItem(string, genericProgramBase);
        if (string.equals(DISABLED_PROGRAMS)) {
            this.disabledPgms.add(programItem);
        } else if (string.equals(MO_REMOVED_PROGRAMS)) {
            this.moRemovePgms.add(programItem);
        } else {
            this.otherPgms.add(programItem);
        }
        this.allPgms.add(programItem);
    }

    public Vector getPrograms(String string) {
        if (string.equals(DISABLED_PROGRAMS)) {
            return this.disabledPgms;
        }
        if (string.equals(MO_REMOVED_PROGRAMS)) {
            return this.moRemovePgms;
        }
        if (string.equals(OTHERS)) {
            return this.otherPgms;
        }
        Vector<GenericProgramBase> vector = new Vector<GenericProgramBase>();
        for (int i = 0; i < this.allPgms.size(); ++i) {
            ProgramItem programItem = (ProgramItem)this.allPgms.elementAt(i);
            if (!programItem.characterString.equals(string)) continue;
            vector.add(programItem.pgm);
        }
        return vector;
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.allPgms.size(); ++i) {
            ProgramItem programItem = (ProgramItem)this.allPgms.elementAt(i);
            string = string + programItem.toString();
        }
        return string;
    }

    public class ProgramItem {
        private String characterString;
        private GenericProgramBase pgm;

        public ProgramItem(String string, GenericProgramBase genericProgramBase) {
            this.characterString = string;
            this.pgm = genericProgramBase;
        }

        public String toString() {
            String string = "program is null";
            if (this.pgm != null) {
                string = ((ManagedObject)this.pgm).getLocalDistinguishedName();
            }
            return "\n\t Reason:" + this.characterString + "\n\t Program:" + string;
        }

        public GenericProgramBase getGenericProgram() {
            return this.pgm;
        }
    }
}

