/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.nsi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionInterface;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.commonpiutypelist.CommonPiuTypeListProxyInterface;
import se.ericsson.cello.sudom.proxy.nodetypespecificpiutypelist.NodeTypeSpecificPiuTypeListInterface;
import se.ericsson.cello.sudom.proxy.piutype.PiuTypesProxyInterface;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.nsi.NSI_SelectorException;
import se.ericsson.cello.upgradepackage.util.nsi.SelectedNodeTypeListInformation;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class NSI_Selector {
    private static final String EMPTY_STRING = "";
    private static final String WILDCARD = "*";
    private HashMap myNotMatchingConfiguredUPIUS = new HashMap();
    private HashMap myNotMatchingActualUPIUS = new HashMap();

    public SelectedNodeTypeListInformation getNodeTypeSpecificListName(String string, String string2, String string3) throws NSI_SelectorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeTypeSpecificListName(String anUCF_Path, String anUP_ProductNumber, String anUP_ProductRevision)", "anUCF_Path: " + string + "\n\tanUP_ProductNumber: " + string2 + "\n\tanUP_ProductRevision: " + string3);
        }
        DocumentObjectProxyInterface documentObjectProxyInterface = null;
        try {
            String[] stringArray = new String[]{"MandatoryPiuTypeList", "CommonPiuTypeList", "NodeTypeSpecificPiuTypeList", "PiuType"};
            documentObjectProxyInterface = UCF_ParserFacade.parseMainElements(string2, string3, string, stringArray);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "parseUCF(String anUCF_Path, String anUP_ProductNumber, String anUP_ProductRevision)", "Throwable caught,\n\tanUCF_Path: " + string + "\n\tanUP_ProductNumber: " + string2 + "\n\tanUP_ProductRevision: " + string3, throwable);
            throw new NSI_SelectorException(throwable.toString());
        }
        return this.getNodeTypeSpecificListName(documentObjectProxyInterface);
    }

    public SelectedNodeTypeListInformation getNodeTypeSpecificListName(DocumentObjectProxyInterface documentObjectProxyInterface) throws NSI_SelectorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeTypeSpecificListName(DocumentObjectProxyInterface aDocumentObjectProxyInterface)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface);
        }
        try {
            Object object;
            Object object2;
            CommonPiuTypeListProxyInterface commonPiuTypeListProxyInterface = documentObjectProxyInterface.getCommonPiuTypeListProxyInterface();
            ProductNumbersAndRevisions productNumbersAndRevisions = commonPiuTypeListProxyInterface.getProductNumbersAndRevisionsForPiuTypes();
            if (productNumbersAndRevisions.isEmpty() && !((ProductNumbersAndRevisions)(object2 = (object = documentObjectProxyInterface.getMandatoryPiuTypeListProxyInterface()).getProductNumbersAndRevisionsForPiuTypes())).isEmpty()) {
                productNumbersAndRevisions.addElements((ProductNumbersAndRevisions)object2);
            }
            object = documentObjectProxyInterface.getNodeTypeSpecificPiuTypeListsProxyInterface();
            object2 = object.getNodeTypeSpecificPiuTypeLists();
            UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
            Collection collection = upgradeablePIU_HandlerInterface.getUpgradeablePlugInUnits();
            ProductNumbersAndRevisions productNumbersAndRevisions2 = this.getUPIUsProductNumbersAndRevisions(collection);
            String string = this.getNodeTypeSpecificPiuTypeListBasedOnConfiguration(productNumbersAndRevisions2, (Collection)object2, productNumbersAndRevisions);
            if (string == null) {
                string = this.getAnyNodeTypeListMatchingActualUPIUs((Collection)object2, collection, productNumbersAndRevisions);
            }
            if (string == null && Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getNodeTypeSpecificListName(File anUCF_Path, String anUP_ProductNumber, String anUP_ProductRevision)", "No node type specific piu type list matches the actual configured PIUs");
            }
            SelectedNodeTypeListInformation selectedNodeTypeListInformation = new SelectedNodeTypeListInformation(string, this.myNotMatchingConfiguredUPIUS, this.myNotMatchingActualUPIUS);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getNodeTypeSpecificListName(File anUCF_Path, String anUP_ProductNumber, String anUP_ProductRevision)", "RETURNS - theSelectedNodeTypeListInformation: " + selectedNodeTypeListInformation);
            }
            return selectedNodeTypeListInformation;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "parseUCF(String anUCF_Path, String anUP_ProductNumber, String anUP_ProductRevision)", "Throwable caught,\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface, throwable);
            throw new NSI_SelectorException("Class name: " + this.getClass().getName() + "\n\tparseUCF(String anUCF_Path, String anUP_ProductNumber, String anUP_ProductRevision)" + "\n\tThrowable caught," + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private Collection createNodeTypeListFromActualConfiguration(Collection collection, DocumentObjectProxyInterface documentObjectProxyInterface) throws NSI_SelectorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "gecreateNodeTypeListFromActualConfiguration(Collection anUpgradeablePIUsPiuTypeMoDatas, DocumentObjectProxyInterface aDocumentObjectProxyInterface)", "anUpgradeablePIUsPiuTypeMoDatas: " + collection + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface);
        }
        try {
            ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
            PiuTypesProxyInterface piuTypesProxyInterface = documentObjectProxyInterface.getPiuTypesProxyInterface();
            ProductNumbersAndRevisions productNumbersAndRevisions2 = piuTypesProxyInterface.getProductNumberAndRevisionOfPiuTypes();
            ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
            Iterator iterator = collection.iterator();
            PiuTypeMoData piuTypeMoData = null;
            while (iterator.hasNext()) {
                piuTypeMoData = (PiuTypeMoData)iterator.next();
                productNumberAndRevisionInterface = piuTypeMoData.getProductNumberAndRevisionInterface();
                if (productNumbersAndRevisions2.contains(productNumberAndRevisionInterface)) {
                    if (productNumbersAndRevisions.contains(productNumberAndRevisionInterface)) continue;
                    productNumbersAndRevisions.addElement(productNumberAndRevisionInterface);
                    continue;
                }
                productNumberAndRevisionInterface = this.getMatchingPiuTypeForActualUPIU(piuTypeMoData.plugInUnit, productNumbersAndRevisions2);
                if (productNumberAndRevisionInterface != null) {
                    if (productNumbersAndRevisions.contains(productNumberAndRevisionInterface)) continue;
                    productNumbersAndRevisions.addElement(productNumberAndRevisionInterface);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "gecreateNodeTypeListFromActualConfiguration(Collection anUpgradeablePIUsPiuTypeMoDatas, DocumentObjectProxyInterface aDocumentObjectProxyInterface)", "The U-PIU do not match any PiuType specified in the UCF.\n\ttheUPIU_PiuTypeMoData: " + piuTypeMoData);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "gecreateNodeTypeListFromActualConfiguration(Collection anUpgradeablePIUsPiuTypeMoDatas, DocumentObjectProxyInterface aDocumentObjectProxyInterface)", "RETURNS - theActualNodeTypeSpcecificPiuTypeList: " + productNumbersAndRevisions);
            }
            return productNumbersAndRevisions.getElements();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "gecreateNodeTypeListFromActualConfiguration(Collection anUpgradeablePIUsPiuTypeMoDatas, DocumentObjectProxyInterface aDocumentObjectProxyInterface)", "Throwable caught,\n\tanUpgradeablePIUsPiuTypeMoDatas: " + collection + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface, throwable);
            throw new NSI_SelectorException(throwable.toString());
        }
    }

    public ProductNumberAndRevisionInterface getMatchingPiuTypeForActualUPIU(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, ProductNumbersAndRevisions productNumbersAndRevisions) throws NSI_SelectorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getMatchingPiuTypeForActualUPIU(GenericUpgradeablePlugInUnit anUPIU, ProductNumbersAndRevisions aProdNosAndRevsOfPiuTypes)", "anUPIU: " + genericUpgradeablePlugInUnit + "\n\taProdNosAndRevsOfPiuTypes: " + productNumbersAndRevisions);
        }
        try {
            if (genericUpgradeablePlugInUnit instanceof PlugInUnitMoSU_Access) {
                SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
                SlotMoSU_Access slotMoSU_Access = (SlotMoSU_Access)genericUpgradeablePlugInUnit.getParent();
                String string = slotMO_HandlerInterface.getSlotRState(slotMoSU_Access);
                String string2 = slotMO_HandlerInterface.getSlotProductNumber(slotMoSU_Access);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "isNodeTypeListMatchingActualUPIUs(Collection anUpgradeablePIUsPiuTypeMoDatas, NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "Product revision of the slot that holds the PlugInUnit: \n\ttheSlotProductNumber: " + string2 + "\n\ttheSlotRevision: " + string);
                }
                if (productNumbersAndRevisions.contains(string2, WILDCARD)) {
                    Trace.suTestLog(this.getClass(), "isNodeTypeListMatchingActualUPIUs(Collection anUpgradeablePIUsPiuTypeMoDatas, NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "Matches WILDCARD\n\ttheSlotProductNumber: " + string2 + "\n\tWILDCARD: " + WILDCARD);
                    return new ProductNumberAndRevision(string2, WILDCARD);
                }
                if (productNumbersAndRevisions.contains(string2, ProductNumberAndRevision.getShortProductRevision(string))) {
                    Trace.suTestLog(this.getClass(), "isNodeTypeListMatchingActualUPIUs(Collection anUpgradeablePIUsPiuTypeMoDatas, NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "Matches short revision\n\ttheSlotProductNumber: " + string2 + "\n\tShort rev: " + ProductNumberAndRevision.getShortProductRevision(string));
                    return new ProductNumberAndRevision(string2, ProductNumberAndRevision.getShortProductRevision(string));
                }
                if (productNumbersAndRevisions.contains(string2, string)) {
                    Trace.suTestLog(this.getClass(), "isNodeTypeListMatchingActualUPIUs(Collection anUpgradeablePIUsPiuTypeMoDatas, NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "Matches specific revision\n\ttheSlotProductNumber: " + string2 + "\n\tSpecific rev: " + string);
                    return new ProductNumberAndRevision(string2, string);
                }
                Trace.suTestLog(this.getClass(), "isNodeTypeListMatchingActualUPIUs(Collection anUpgradeablePIUsPiuTypeMoDatas, NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "DUPIU is not supported by the PiuTypes defined in the UCF\n\ttheSlotProductNumber: " + string2 + "\n\ttheSlotRevision: " + string);
                return null;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getMatchingPiuTypeForActualUPIU(GenericUpgradeablePlugInUnit anUPIU, ProductNumbersAndRevisions aProdNosAndRevsOfPiuTypes)", "U-PIU is not a PlugInUnit");
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getMatchingPiuTypeForActualUPIU(GenericUpgradeablePlugInUnit anUPIU)", "Throwable caught,\n\tanUPIU: " + genericUpgradeablePlugInUnit, throwable);
            throw new NSI_SelectorException(throwable.toString());
        }
    }

    private ProductNumbersAndRevisions getNodeTypeSpecificListProductNumbersAndRevisions(NodeTypeSpecificPiuTypeListInterface nodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions productNumbersAndRevisions) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeTypeSpecificListProductNumbersAndRevisions(NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions))", "aNodeTypeSpecificPiuTypeListInterface: " + nodeTypeSpecificPiuTypeListInterface);
        }
        Collection collection = nodeTypeSpecificPiuTypeListInterface.getProductNumberAndRevisionInterfacesForPiuTypes();
        Iterator iterator = collection.iterator();
        ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
        LinkedList<ProductNumberAndRevisionInterface> linkedList = new LinkedList<ProductNumberAndRevisionInterface>();
        while (iterator.hasNext()) {
            productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator.next();
            linkedList.add(productNumberAndRevisionInterface);
        }
        ProductNumbersAndRevisions productNumbersAndRevisions2 = new ProductNumbersAndRevisions();
        productNumbersAndRevisions2.addInterfacesAsElements(linkedList);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeTypeSpecificListProductNumbersAndRevisions(NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions))", "theProductNumbersAndRevisionsNodeTypeList (before adding common list): " + productNumbersAndRevisions2);
        }
        productNumbersAndRevisions2.addElements(productNumbersAndRevisions);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeTypeSpecificListProductNumbersAndRevisions(NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions))", "RETURNS - theProductNumbersAndRevisionsNodeTypeList: " + productNumbersAndRevisions2);
        }
        return productNumbersAndRevisions2;
    }

    private ProductNumbersAndRevisions getUPIUsProductNumbersAndRevisions(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUPIUsProductNumbersAndRevisions(Collection anUpgradeablePIUsPiuTypeMoDatas)", "anUpgradeablePIUsPiuTypeMoDatas: " + collection);
        }
        PiuTypeMoData piuTypeMoData = null;
        ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
        LinkedList<ProductNumberAndRevisionInterface> linkedList = new LinkedList<ProductNumberAndRevisionInterface>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            piuTypeMoData = (PiuTypeMoData)iterator.next();
            linkedList.add(piuTypeMoData.getProductNumberAndRevisionInterface());
        }
        productNumbersAndRevisions.addInterfacesAsElements(linkedList);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUPIUsProductNumbersAndRevisions(Collection anUpgradeablePIUsPiuTypeMoDatas)", "RETURNS - theUPIUsProductNumberAndRevisions: " + productNumbersAndRevisions);
        }
        return productNumbersAndRevisions;
    }

    private String getNodeTypeSpecificPiuTypeListBasedOnConfiguration(ProductNumbersAndRevisions productNumbersAndRevisions, Collection collection, ProductNumbersAndRevisions productNumbersAndRevisions2) throws NSI_SelectorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeTypeSpecificPiuTypeListBasedOnConfiguration(ProductNumbersAndRevisions aProductNumberAndRevisionsForUPIUsList, Collection aNodeTypeSpecificPiuTypeListInterfaces, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "aProductNumberAndRevisionsForUPIUsList: " + productNumbersAndRevisions + "\n\taNodeTypeSpecificPiuTypeListInterfaces: " + collection + "\n\taCommonPiuTypeListProductNumbersAndRevisions: " + productNumbersAndRevisions2);
        }
        try {
            Iterator iterator = collection.iterator();
            NodeTypeSpecificPiuTypeListInterface nodeTypeSpecificPiuTypeListInterface = null;
            String string = null;
            while (iterator.hasNext()) {
                nodeTypeSpecificPiuTypeListInterface = (NodeTypeSpecificPiuTypeListInterface)iterator.next();
                if (!this.isNodeTypeListMatchingConfiguredUPIUs(productNumbersAndRevisions, nodeTypeSpecificPiuTypeListInterface, productNumbersAndRevisions2)) continue;
                string = nodeTypeSpecificPiuTypeListInterface.getName();
                break;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getAnyNodeTypeListMatchingConfiguredUPIUs(Collection aNodeTypeSpecificPiuTypeListInterfaces, ProductNumbersAndRevisions anUPIUsProductNumberAndRevisions)", "RETURNS - " + string);
            }
            return string;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "parseUCF(String anUCF_Path, String anUP_ProductNumber, String anUP_ProductRevision)", "Throwable caught,\n\taProductNumberAndRevisionsForUPIUsList: " + productNumbersAndRevisions + "\n\taNodeTypeSpecificPiuTypeListInterfaces: " + collection, throwable);
            throw new NSI_SelectorException(throwable.toString());
        }
    }

    private String getAnyNodeTypeListMatchingActualUPIUs(Collection collection, Collection collection2, ProductNumbersAndRevisions productNumbersAndRevisions) throws NSI_SelectorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAnyNodeTypeListMatchingActualUPIUs(Collection aNodeTypeSpecificPiuTypeListInterfaces, ProductNumbersAndRevisions anUpgradeablePIUsPiuTypeMoDatas, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "aNodeTypeSpecificPiuTypeListInterfaces: " + collection + "\n\tanUpgradeablePIUsPiuTypeMoDatas: " + collection2 + "\n\taCommonPiuTypeListProductNumbersAndRevisions: " + productNumbersAndRevisions);
        }
        try {
            Iterator iterator = collection.iterator();
            NodeTypeSpecificPiuTypeListInterface nodeTypeSpecificPiuTypeListInterface = null;
            String string = null;
            while (iterator.hasNext()) {
                nodeTypeSpecificPiuTypeListInterface = (NodeTypeSpecificPiuTypeListInterface)iterator.next();
                if (!this.isNodeTypeListMatchingActualUPIUs(collection2, nodeTypeSpecificPiuTypeListInterface, productNumbersAndRevisions)) continue;
                string = nodeTypeSpecificPiuTypeListInterface.getName();
                break;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getAnyNodeTypeListMatchingActualUPIUs(Collection aNodeTypeSpecificPiuTypeListInterfaces, ProductNumbersAndRevisions anUpgradeablePIUsPiuTypeMoDatas)", "RETURNS - theMatchingNodeTypeListName: " + string);
            }
            return string;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getAnyNodeTypeListMatchingActualUPIUs(Collection aNodeTypeSpecificPiuTypeListInterfaces, ProductNumbersAndRevisions anUpgradeablePIUsPiuTypeMoDatas)", "aNodeTypeSpecificPiuTypeListInterfaces: " + collection + "\n\tanUpgradeablePIUsPiuTypeMoDatas: " + collection2, throwable);
            throw new NSI_SelectorException(throwable.toString());
        }
    }

    private boolean isActualSlotProdDataMatchingNodeTypeSpecificList(ProductNumbersAndRevisions productNumbersAndRevisions, PiuTypeMoData piuTypeMoData, String string, String string2) throws NSI_SelectorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isActualSlotProdDataMatchingNodeTypeSpecificList(ProductNumbersAndRevisions aProductNumbersAndRevisionsNodeTypeList, PiuTypeMoData anUPIUsPiuTypeMoData, String aSlotProductNumber, String aSlotRevision)", "aProductNumbersAndRevisionsNodeTypeList: " + productNumbersAndRevisions + "\n\tanUPIUsPiuTypeMoData: " + piuTypeMoData + "\n\taSlotProductNumber: " + string + "\n\taSlotRevision: " + string2);
        }
        try {
            if (string2 != null && !string2.equals(EMPTY_STRING)) {
                Trace.debug(this.getClass(), 20, "isActualSlotProdDataMatchingNodeTypeSpecificList(ProductNumbersAndRevisions aProductNumbersAndRevisionsNodeTypeList, PiuTypeMoData anUPIUsPiuTypeMoData, String aSlotProductNumber, String aSlotRevision)", " " + piuTypeMoData.productNumber.equals(string));
                if (!piuTypeMoData.productNumber.equals(string) || !piuTypeMoData.productRevision.equals(WILDCARD)) {
                    if (productNumbersAndRevisions.contains(string, WILDCARD)) {
                        if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "isActualSlotProdDataMatchingNodeTypeSpecificList(ProductNumbersAndRevisions aProductNumbersAndRevisionsNodeTypeList, PiuTypeMoData anUPIUsPiuTypeMoData, String aSlotProductNumber, String aSlotRevision)", "Is matching wildcard revision");
                        }
                        return true;
                    }
                } else if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "isActualSlotProdDataMatchingNodeTypeSpecificList(ProductNumbersAndRevisions aProductNumbersAndRevisionsNodeTypeList, PiuTypeMoData anUPIUsPiuTypeMoData, String aSlotProductNumber, String aSlotRevision)", "Already configured with wildcard revision (i.e. this data do not exist in node type specific list)");
                }
                if (!piuTypeMoData.productNumber.equals(string) || !piuTypeMoData.productRevision.equals(ProductNumberAndRevision.getShortProductRevision(string2))) {
                    if (productNumbersAndRevisions.contains(string, ProductNumberAndRevision.getShortProductRevision(string2))) {
                        if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "isActualSlotProdDataMatchingNodeTypeSpecificList(ProductNumbersAndRevisions aProductNumbersAndRevisionsNodeTypeList, PiuTypeMoData anUPIUsPiuTypeMoData, String aSlotProductNumber, String aSlotRevision)", "Is matching short revision: " + ProductNumberAndRevision.getShortProductRevision(string2));
                        }
                        return true;
                    }
                } else if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "isActualSlotProdDataMatchingNodeTypeSpecificList(ProductNumbersAndRevisions aProductNumbersAndRevisionsNodeTypeList, PiuTypeMoData anUPIUsPiuTypeMoData, String aSlotProductNumber, String aSlotRevision)", "Already configured with short revision (i.e. this data do not exist in node type specific list)");
                }
                if (!piuTypeMoData.productNumber.equals(string) || !piuTypeMoData.productRevision.equals(string2)) {
                    if (productNumbersAndRevisions.contains(string, string2)) {
                        if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "isActualSlotProdDataMatchingNodeTypeSpecificList(ProductNumbersAndRevisions aProductNumbersAndRevisionsNodeTypeList, PiuTypeMoData anUPIUsPiuTypeMoData, String aSlotProductNumber, String aSlotRevision)", "Is matching specific revision.");
                        }
                        return true;
                    }
                } else if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "isActualSlotProdDataMatchingNodeTypeSpecificList(ProductNumbersAndRevisions aProductNumbersAndRevisionsNodeTypeList, PiuTypeMoData anUPIUsPiuTypeMoData, String aSlotProductNumber, String aSlotRevision)", "Already configured with specific revision (i.e. this data do not exist in node type specific list)");
                }
                return false;
            }
            if (productNumbersAndRevisions.containsWithAnyRevisionRule(piuTypeMoData.productNumber, WILDCARD)) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "isActualSlotProdDataMatchingNodeTypeSpecificList(ProductNumbersAndRevisions aProductNumbersAndRevisionsNodeTypeList, PiuTypeMoData anUPIUsPiuTypeMoData, String aSlotProductNumber, String aSlotRevision)", "Is matching configured PiuType");
                }
                return true;
            }
            Trace.log1(this.getClass(), "isActualSlotProdDataMatchingNodeTypeSpecificList(ProductNumbersAndRevisions aProductNumbersAndRevisionsNodeTypeList, PiuTypeMoData anUPIUsPiuTypeMoData, String aSlotProductNumber, String aSlotRevision)", "The slot revision is null or an empty string. The configured revision can't be looked up to a specific, short or wildcard revision in UCF.And The configured piuType revision can't be looked up to a specific, short or wildcard revision in UCF.\n\tanUPIUsPiuTypeMoData: " + piuTypeMoData + "\n\taSlotRevision: " + string2);
            return false;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isActualSlotProdDataMatchingNodeTypeSpecificList(ProductNumbersAndRevisions aProductNumbersAndRevisionsNodeTypeList, PiuTypeMoData anUPIUsPiuTypeMoData, String aSlotProductNumber, String aSlotRevision)", "aProductNumbersAndRevisionsNodeTypeList: " + productNumbersAndRevisions + "\n\tanUPIUsPiuTypeMoData: " + piuTypeMoData + "\n\taSlotProductNumber: " + string + "\n\taSlotRevision: " + string2, throwable);
            throw new NSI_SelectorException(throwable.toString());
        }
    }

    public boolean isNodeTypeListMatchingActualUPIUs(Collection collection, NodeTypeSpecificPiuTypeListInterface nodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions productNumbersAndRevisions) throws NSI_SelectorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isNodeTypeListMatchingActualUPIUs(Collection anUpgradeablePIUsPiuTypeMoDatas, NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "anUpgradeablePIUsPiuTypeMoDatas: " + collection + "\n\taNodeTypeSpecificPiuTypeListInterface: " + nodeTypeSpecificPiuTypeListInterface + "\n\taCommonPiuTypeListProductNumbersAndRevisions: " + productNumbersAndRevisions);
        }
        try {
            ProductNumbersAndRevisions productNumbersAndRevisions2 = this.getNodeTypeSpecificListProductNumbersAndRevisions(nodeTypeSpecificPiuTypeListInterface, productNumbersAndRevisions);
            Iterator iterator = collection.iterator();
            PiuTypeMoData piuTypeMoData = null;
            boolean bl = true;
            while (iterator.hasNext()) {
                GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit;
                piuTypeMoData = (PiuTypeMoData)iterator.next();
                if (productNumbersAndRevisions2.contains(piuTypeMoData.productNumber, piuTypeMoData.productRevision)) continue;
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "isNodeTypeListMatchingActualUPIUs(Collection anUpgradeablePIUsPiuTypeMoDatas, NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "Is not matching, trying to find a matching using the actual revision from Slot\n\ttheUPIUsPiuTypeMoData.productNumber: " + piuTypeMoData.productNumber + "\n\ttheUPIUsPiuTypeMoData.productRevision: " + piuTypeMoData.productRevision);
                }
                if ((genericUpgradeablePlugInUnit = piuTypeMoData.plugInUnit) instanceof PlugInUnitMoSU_Access) {
                    SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
                    SlotMoSU_Access slotMoSU_Access = (SlotMoSU_Access)genericUpgradeablePlugInUnit.getParent();
                    String string = slotMO_HandlerInterface.getSlotRState(slotMoSU_Access);
                    String string2 = slotMO_HandlerInterface.getSlotProductNumber(slotMoSU_Access);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "isNodeTypeListMatchingActualUPIUs(Collection anUpgradeablePIUsPiuTypeMoDatas, NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "Product revision of the slot that holds the PlugInUnit: \n\ttheSlotProductNumber: " + string2 + "\n\ttheSlotRevision: " + string);
                    }
                    if (this.isActualSlotProdDataMatchingNodeTypeSpecificList(productNumbersAndRevisions2, piuTypeMoData, string2, string)) continue;
                    bl = false;
                    this.addNotMatchingActualUPIU(nodeTypeSpecificPiuTypeListInterface.getName(), string2, string);
                    break;
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "isNodeTypeListMatchingActualUPIUs(Collection anUpgradeablePIUsPiuTypeMoDatas, NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "PlugInUnit refering to PiuType is not instance of PlugInUnitMoSU_Access.\n\tNot able to collect actual product number and revision for board inserted in node.\n\tThe PlugInUnit: " + genericUpgradeablePlugInUnit);
                }
                bl = false;
                break;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isNodeTypeListMatchingConfiguredUPIUs(ProductNumbersAndRevisions aProductNumberAndRevisionsForUPIUs, NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "RETURNS - theIsNodeTypeListMatching: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isNodeTypeListMatchingActualUPIUs(Collection anUpgradeablePIUsPiuTypeMoDatas, Collection aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "anUpgradeablePIUsPiuTypeMoDatas: " + collection + "\n\taNodeTypeSpecificPiuTypeListInterface: " + nodeTypeSpecificPiuTypeListInterface, throwable);
            throw new NSI_SelectorException(throwable.toString());
        }
    }

    private boolean isNodeTypeListMatchingConfiguredUPIUs(ProductNumbersAndRevisions productNumbersAndRevisions, NodeTypeSpecificPiuTypeListInterface nodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions productNumbersAndRevisions2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isNodeTypeListMatchingConfiguredUPIUs(ProductNumbersAndRevisions aProductNumberAndRevisionsForUPIUs, NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "aProductNumberAndRevisionsForUPIUs: " + productNumbersAndRevisions + "\n\taNodeTypeSpecificPiuTypeListInterface: " + nodeTypeSpecificPiuTypeListInterface + "\n\taCommonPiuTypeListProductNumbersAndRevisions: " + productNumbersAndRevisions2);
        }
        ProductNumbersAndRevisions productNumbersAndRevisions3 = this.getNodeTypeSpecificListProductNumbersAndRevisions(nodeTypeSpecificPiuTypeListInterface, productNumbersAndRevisions2);
        Iterator iterator = productNumbersAndRevisions.getElements().iterator();
        ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
        boolean bl = true;
        while (iterator.hasNext()) {
            productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator.next();
            if (productNumbersAndRevisions3.contains(productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision())) continue;
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isNodeTypeListMatchingConfiguredUPIUs(ProductNumbersAndRevisions aProductNumberAndRevisionsForUPIUs, NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "Configured U-PIU is not present in current node type specific piu type list.\n\ttheProductNumberAndRevisionInterfaceUPIU.getProductNumber(): " + productNumberAndRevisionInterface.getProductNumber() + "\n\ttheProductNumberAndRevisionInterfaceUPIU.getRevision(): " + productNumberAndRevisionInterface.getRevision() + "\n\taNodeTypeSpecificPiuTypeListInterface: " + nodeTypeSpecificPiuTypeListInterface);
            }
            bl = false;
            this.addNotMatchingConfiguredUPIU(nodeTypeSpecificPiuTypeListInterface.getName(), productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision());
            break;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isNodeTypeListMatchingConfiguredUPIUs(ProductNumbersAndRevisions aProductNumberAndRevisionsForUPIUs, NodeTypeSpecificPiuTypeListInterface aNodeTypeSpecificPiuTypeListInterface, ProductNumbersAndRevisions aCommonPiuTypeListProductNumbersAndRevisions)", "RETURNS - " + bl);
        }
        return bl;
    }

    private void addNotMatchingConfiguredUPIU(String string, String string2, String string3) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addNotMatchingConfiguredUPIU(String aNodeTypeSpecificPiuTypeListName, String aUPIU_ProductNumber, String aUPIU_ProductRevision)", "aNodeTypeSpecificPiuTypeListName: " + string + "\n\taUPIU_ProductNumber: " + string2 + "\n\taUPIU_ProductRevision: " + string3);
        }
        this.myNotMatchingConfiguredUPIUS.put(string, new ProductNumberAndRevision(string2, string3));
    }

    private void addNotMatchingActualUPIU(String string, String string2, String string3) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addNotMatchingActualUPIU(String aNodeTypeSpecificPiuTypeListName, String aUPIU_ProductNumber, String aUPIU_ProductRevision)", "aNodeTypeSpecificPiuTypeListName: " + string + "\n\taUPIU_ProductNumber: " + string2 + "\n\taUPIU_ProductRevision: " + string3);
        }
        this.myNotMatchingActualUPIUS.put(string, new ProductNumberAndRevision(string2, string3));
    }
}

