/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.empatcher;

import java.io.File;
import java.util.SortedSet;
import java.util.TreeSet;
import se.ericsson.security.empatcher.CommandLineParameters;

public class FoundLaxFilesSet
extends TreeSet {
    private static final long serialVersionUID = 1538031073577430691L;
    private final boolean isDebugOn;

    public FoundLaxFilesSet(String[] laxPaths) {
        this(false, laxPaths);
    }

    public FoundLaxFilesSet(boolean isDebugSet, String[] laxPaths) {
        this.isDebugOn = isDebugSet;
        TreeSet<File> paths = new TreeSet<File>();
        for (int i = 0; i < laxPaths.length; ++i) {
            File path = new File(laxPaths[i]);
            if (!path.exists()) {
                CommandLineParameters.commandLineError("Can't find " + path);
            }
            if (path.isFile() && !this.isLax(path)) {
                CommandLineParameters.commandLineError("Specified file '" + path + "' doesn't have extension '.lax'!");
            }
            path = path.getAbsoluteFile();
            paths.add(path);
        }
        for (File path : paths) {
            SortedSet foundBelow = this.findLaxFiles(path);
            this.addAll(foundBelow);
        }
        System.out.println();
    }

    private SortedSet findLaxFiles(File path) {
        TreeSet<File> found = new TreeSet<File>();
        if (this.isLax(path)) {
            found.add(path);
        }
        if (this.isIntrestingDir(path)) {
            File[] entries = path.listFiles();
            if (null != entries) {
                for (int i = 0; i < entries.length; ++i) {
                    System.out.print(".");
                    File entry = entries[i];
                    SortedSet foundBelow = this.findLaxFiles(entry);
                    found.addAll(foundBelow);
                }
            } else {
                this.printDebug("Ignored : " + path);
            }
        } else {
            this.printDebug("Ignored : " + path);
        }
        return found;
    }

    private boolean isIntrestingDir(File f) {
        if (!f.isDirectory()) {
            return false;
        }
        String[] IGNORED = new String[]{"CXC", "Uninstall_"};
        String basename = f.getName();
        for (int i = 0; i < IGNORED.length; ++i) {
            String p = IGNORED[i];
            if (!basename.startsWith(p)) continue;
            return false;
        }
        return true;
    }

    private boolean isLax(File path) {
        String p = path.toString();
        boolean endsWithLax = p.endsWith(".lax");
        boolean result = endsWithLax && path.isFile();
        return result;
    }

    private void printDebug(String msg) {
        if (this.isDebugOn) {
            System.out.println("DEBUG:   " + msg);
        }
    }
}

