/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import se.ericsson.security.launcher.ApplicationClassLoader;
import se.ericsson.security.launcher.ApplicationConfiguration;
import se.ericsson.security.launcher.ApplicationWrapper;
import se.ericsson.security.launcher.EmClassLoader;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherEventDispatcher;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.VersionedLauncherInterface;
import se.ericsson.security.launcher.cache.CachedApplication;
import se.ericsson.security.launcher.cache.CachedFile;
import se.ericsson.security.launcher.testmode.TmUtilities;
import se.ericsson.security.launcher.testmode.TmUtilitiesExt;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ApplicationFactory {
    APPLICATION_FACTORY;

    private static final EmLogger LOG;
    private static int launchedApplications;
    private HashMap<EmClassLoader, ApplicationClassLoader> classLoaders = new HashMap(2);
    private LauncherEventDispatcher launcherEventDispatcher = null;

    private ApplicationFactory() {
        this.classLoaders.put(EmClassLoader.SECURITY_CLASS_LOADER, new ApplicationClassLoader(EmClassLoader.SECURITY_CLASS_LOADER.name(), new URL[0], ApplicationFactory.class.getClassLoader(), LauncherInterface.class.getClassLoader()));
        this.classLoaders.put(EmClassLoader.COMMON_CLASS_LOADER, new ApplicationClassLoader(EmClassLoader.COMMON_CLASS_LOADER.name(), new URL[0], (ClassLoader)this.classLoaders.get((Object)EmClassLoader.SECURITY_CLASS_LOADER), LauncherInterface.class.getClassLoader()));
        ApplicationClassLoader commonCL = this.classLoaders.get((Object)EmClassLoader.COMMON_CLASS_LOADER);
        URL semlaUrl = TmUtilities.getSafeSemlaUrl();
        if (semlaUrl != null) {
            commonCL.addURL(semlaUrl);
        }
        TmUtilities.setStubStarter(TmUtilitiesExt.findStubStarter(commonCL));
    }

    public Launchable createApplication(ApplicationConfiguration configuration, boolean is_appl, CachedApplication[] cachedApplication, Properties arguments, Launchable parent_ref, ClassLoader securityClassloader, VersionedLauncherInterface launcher) throws LauncherException {
        ApplicationClassLoader classloader = this.createClassLoader(configuration.getApplicationName(), cachedApplication, securityClassloader, false);
        if (this.launcherEventDispatcher == null) {
            this.launcherEventDispatcher = new LauncherEventDispatcher();
            this.launcherEventDispatcher.push(this.launcherEventDispatcher);
        }
        Properties props = (Properties)configuration.getApplicationParameters().clone();
        props.putAll((Map<?, ?>)arguments);
        LOG.fine("Doing new ApplicationWrapper: props: " + props, new Object[0]);
        ApplicationWrapper wr = new ApplicationWrapper(classloader, configuration, is_appl, props.getProperty("hostname"), props, launcher, parent_ref);
        String groupName = configuration.getApplicationName() + '-' + ++launchedApplications;
        ThreadGroup tg = new ThreadGroup(groupName);
        Thread t = new Thread(tg, wr);
        t.start();
        Launchable toReturn = wr.getInstance();
        return toReturn;
    }

    public ApplicationClassLoader createClassLoader(String name, CachedApplication[] cachedApplication, ClassLoader parentLoader, boolean forSecurity) throws LauncherException {
        Object[] theCommonURLs = null;
        URL[] theApplURLs = null;
        URL[] theSecURLs = new URL[]{};
        theCommonURLs = this.getUrlsToCachedFiles(cachedApplication[1]);
        theApplURLs = this.getUrlsToCachedFiles(cachedApplication[0]);
        if (forSecurity) {
            int i;
            theSecURLs = new URL[theCommonURLs.length + theApplURLs.length];
            for (i = 0; i < theCommonURLs.length; ++i) {
                theSecURLs[i] = theCommonURLs[i];
            }
            while (i < theCommonURLs.length + theApplURLs.length) {
                theSecURLs[i] = theApplURLs[i - theCommonURLs.length];
                ++i;
            }
        }
        ApplicationClassLoader securityClassLoader = this.classLoaders.get((Object)EmClassLoader.SECURITY_CLASS_LOADER);
        securityClassLoader.addURLs(theSecURLs);
        if (forSecurity) {
            return securityClassLoader;
        }
        ApplicationClassLoader commonClassLoader = this.classLoaders.get((Object)EmClassLoader.COMMON_CLASS_LOADER);
        if (parentLoader.equals(((Object)((Object)this)).getClass().getClassLoader())) {
            LOG.fine("Changed parentLoader from classloader of 'this' : " + parentLoader + " to commonClassLoader " + commonClassLoader, new Object[0]);
            parentLoader = commonClassLoader;
        }
        try {
            commonClassLoader.addURLs((URL[])theCommonURLs);
        }
        catch (Exception e) {
            LOG.severe("Failed adding URL:s to common classloader!\n   URLs=" + Arrays.toString(theCommonURLs), e);
        }
        ApplicationClassLoader classloader = new ApplicationClassLoader(name, theApplURLs, parentLoader, LauncherInterface.class.getClassLoader());
        return classloader;
    }

    public ApplicationClassLoader addUrlsToClassPath(EmClassLoader emClassLoader, URL[] urls) {
        this.logUrls("Adding the following URLs to " + emClassLoader.toString() + ": ", urls);
        ApplicationClassLoader classLoader = this.classLoaders.get((Object)emClassLoader);
        classLoader.addURLs(urls);
        this.logUrls("Classloader " + emClassLoader.toString() + " now contain the following URLs: ", classLoader.getURLs());
        return classLoader;
    }

    private URL[] getUrlsToCachedFiles(CachedApplication cachedApplication) throws LauncherException {
        Vector<URL> urls = new Vector<URL>();
        for (CachedFile f : cachedApplication) {
            LOG.finest(f.getFileName(), new Object[0]);
            try {
                urls.add(new URL("file", "", f.getFileName()));
            }
            catch (MalformedURLException e) {
                throw new LauncherException(e);
            }
        }
        return urls.toArray(new URL[0]);
    }

    private void logUrls(String msg, URL[] urls) {
        if (LOG.getLogger().isLoggable(Level.FINEST)) {
            StringBuffer sb = new StringBuffer(msg);
            for (URL url : urls) {
                sb.append(url.toString());
                sb.append("\n\r");
            }
            LOG.finest(sb.toString(), new Object[0]);
        }
    }

    static {
        LOG = EmLogger.LAUNCHER;
        launchedApplications = 0;
    }
}

