/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.cache;

import java.security.CodeSource;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.utils.EmLogger;

class TrustedCertificateManager {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private X509Certificate[] trustedCerts;

    TrustedCertificateManager() {
    }

    X509Certificate[] getTrustedcerts() throws LauncherException {
        CodeSource thisCodeSource = this.getClass().getProtectionDomain().getCodeSource();
        LOG.finest("Trying to get the certificate from launcher jar-file", new Object[0]);
        Certificate[] certificates = thisCodeSource.getCertificates();
        if (certificates == null) {
            LOG.warning("No trusted certificate found.", new Object[0]);
            return new X509Certificate[0];
        }
        LOG.finest("Got trusted certificates: " + certificates.toString() + " from launcher jar-file.\n", new Object[0]);
        this.trustedCerts = new X509Certificate[certificates.length];
        for (int i = 0; i < certificates.length; ++i) {
            if (certificates[i] instanceof X509Certificate) {
                X509Certificate x509Cert = (X509Certificate)certificates[i];
                try {
                    x509Cert.checkValidity();
                    this.trustedCerts[i] = x509Cert;
                    LOG.fine("Added trusted certificate with SubjectDN: " + x509Cert.getSubjectDN() + "\n", new Object[0]);
                    continue;
                }
                catch (CertificateException ce) {
                    LOG.severe("Certificate with SubjectDN=" + x509Cert.getSubjectDN() + " is not valid", new Object[0]);
                    throw new LauncherException("Certificate with SubjectDN=" + x509Cert.getSubjectDN() + " is not valid", (Throwable)ce);
                }
            }
            LOG.severe("Trusted Certificate is not X509. Type= " + certificates[i].getType(), new Object[0]);
            throw new LauncherException("Trusted Certificate is not X509. Type= " + certificates[i].getType());
        }
        return this.trustedCerts;
    }
}

