/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.eprops;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractionLevel
implements Comparable<AbstractionLevel> {
    public final String TITLE;
    public final PresentationLevel PRESENTATION_LEVEL;
    public final int SORT_ORDER;
    public final String HELP_TEXT;

    public AbstractionLevel(String title, PresentationLevel presentationLevel, int sortOrder, String helpMessage) {
        this.TITLE = title;
        this.PRESENTATION_LEVEL = presentationLevel;
        this.SORT_ORDER = sortOrder;
        this.HELP_TEXT = helpMessage == null ? "" : helpMessage;
    }

    public AbstractionLevel(String title, int sortOrder, String helpMessage) {
        this(title, PresentationLevel.DETAIL, sortOrder, "");
    }

    public AbstractionLevel(String title, int sortOrder) {
        this(title, PresentationLevel.DETAIL, sortOrder, "");
    }

    public String getTitle() {
        return this.TITLE;
    }

    public int getSortOrder() {
        return this.SORT_ORDER;
    }

    public String getHelpText() {
        return this.HELP_TEXT;
    }

    @Override
    public int compareTo(AbstractionLevel other) {
        if (this.PRESENTATION_LEVEL != other.PRESENTATION_LEVEL) {
            return this.PRESENTATION_LEVEL.compareTo(other.PRESENTATION_LEVEL);
        }
        if (this.SORT_ORDER != other.SORT_ORDER) {
            return this.SORT_ORDER - other.SORT_ORDER;
        }
        int nameCompare = String.CASE_INSENSITIVE_ORDER.compare(this.TITLE, other.TITLE);
        return nameCompare;
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractionLevel) {
            return 0 == this.compareTo((AbstractionLevel)other);
        }
        return false;
    }

    public int hashCode() {
        return this.SORT_ORDER;
    }

    public String toString() {
        return this.TITLE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PresentationLevel {
        MESSAGE,
        DETAIL,
        NONE;

    }
}

