/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.util;

import java.io.IOException;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import javax.management.InstanceNotFoundException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import se.ericsson.security.launcher.testmode.TmProperty;
import se.ericsson.security.launcher.util.DynamicX509TrustManager;
import se.ericsson.security.utils.EmLogger;

public class EmasUtilities {
    private static EmLogger LOG = EmLogger.LAUNCHER;
    private static final EmasUtilities instance = new EmasUtilities();
    private SSLContext sslContext = null;
    private static final String WINDOWS_SEPARATOR = "\\";
    private static final String FILE_SEPARATOR = "file.separator";

    private EmasUtilities() {
        try {
            this.sslContext = this.createSSLContext();
        }
        catch (Exception e) {
            LOG.severe("Couldn't prepare the SSLContext", e);
        }
    }

    private SSLContext createSSLContext() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException, InstanceNotFoundException {
        TrustManager[] trustManagers = new TrustManager[]{DynamicX509TrustManager.getInstance()};
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, trustManagers, new SecureRandom());
        return context;
    }

    public void enableNECertificateValidation(URLConnection urlConnection) {
        if (urlConnection instanceof HttpsURLConnection) {
            if (TmProperty.TEST_MODE.isSet()) {
                LOG.info("TEST_MODE is set, not using production TrustStore", new Object[0]);
            } else {
                LOG.finest("Enabling certificate validation for: " + urlConnection.getURL().toExternalForm(), new Object[0]);
                ((HttpsURLConnection)urlConnection).setSSLSocketFactory(this.sslContext.getSocketFactory());
            }
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
        }
    }

    public static boolean runningOnWindows() {
        String fileSeparator = System.getProperty(FILE_SEPARATOR);
        return WINDOWS_SEPARATOR.equals(fileSeparator);
    }

    public static EmasUtilities getInstance() {
        return instance;
    }
}

