/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import se.ericsson.security.utils.EmLogger;

public class UrlUtilities {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String PROTOCOL_SEPARATOR = "://";
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private static Map<String, String> protocolCache = new HashMap<String, String>();

    public static URL getURL(String defaultProtocol, String address, String defaultPort, String path) {
        Pattern uri;
        Matcher m;
        if (address == null || address.trim().length() == 0) {
            return null;
        }
        if (defaultProtocol != null && defaultProtocol.length() > 0 && !address.contains(PROTOCOL_SEPARATOR)) {
            address = defaultProtocol + PROTOCOL_SEPARATOR + address;
        }
        if (defaultPort != null && defaultPort.trim().length() > 0 && (m = (uri = Pattern.compile("^(([a-zA-Z\\.\\+]*)://)?([a-zA-Z0-9\\.\\+\\-\\[\\]:]+?)(:(\\d{1,5}))?")).matcher(address)).matches() && m.group(5) == null) {
            address = address + ":" + defaultPort;
        }
        if (path != null) {
            address = address + path;
        }
        return UrlUtilities.getURL(address);
    }

    public static URL getURL(String address) {
        if (address == null || address.trim().length() == 0) {
            return null;
        }
        URL url = null;
        if (address.contains(PROTOCOL_SEPARATOR)) {
            url = UrlUtilities.createURLFromString(address);
        } else {
            String cachedProtocol = UrlUtilities.getCachedProtocol(address);
            if (cachedProtocol != null) {
                LOG.fine("Found cached protocol (" + cachedProtocol + ") for address " + address, new Object[0]);
                address = cachedProtocol + PROTOCOL_SEPARATOR + address;
                url = UrlUtilities.createURLFromString(address);
            } else {
                url = UrlUtilities.getUrlWithHttpOrHttps(address);
                if (url != null) {
                    UrlUtilities.setCachedProtocol(url);
                }
            }
        }
        if (url != null && url.getPort() == -1) {
            try {
                url = new URL(url.getProtocol(), url.getHost(), url.getDefaultPort(), url.getPath());
            }
            catch (MalformedURLException e) {
                LOG.warning("Failed creating new URL with default port for " + url, e);
                return null;
            }
        }
        LOG.fine("Returning URL " + url + " for address " + address, new Object[0]);
        return url;
    }

    private static URL createURLFromString(String address) {
        try {
            return new URL(address);
        }
        catch (MalformedURLException e) {
            LOG.fine(address + " is not a valid URL", e);
            return null;
        }
    }

    private static URL getUrlWithHttpOrHttps(String address) {
        ArrayList<ConnectionAttempt> connections = new ArrayList<ConnectionAttempt>();
        LinkedBlockingQueue<ConnectionResult> resultQueue = new LinkedBlockingQueue<ConnectionResult>();
        URL httpUrl = null;
        URL httpsUrl = null;
        try {
            httpUrl = new URL("http://" + address);
            httpsUrl = new URL("https://" + address);
            connections.add(new ConnectionAttempt(httpUrl, resultQueue));
            connections.add(new ConnectionAttempt(httpsUrl, resultQueue));
            for (ConnectionAttempt ca : connections) {
                new Thread(ca).start();
            }
        }
        catch (MalformedURLException e) {
            LOG.fine(address + " is not a valid URL", e);
            return null;
        }
        try {
            ConnectionResult connectionResult = (ConnectionResult)resultQueue.take();
            if (!connectionResult.success) {
                connectionResult = (ConnectionResult)resultQueue.take();
            }
            for (ConnectionAttempt ca : connections) {
                ca.suppressTimeoutResult();
            }
            if (connectionResult.success) {
                LOG.fine("Successful response from " + connectionResult.url, new Object[0]);
                return connectionResult.url;
            }
            LOG.fine("Invalid responses from " + httpUrl + " and " + httpsUrl, new Object[0]);
            return null;
        }
        catch (InterruptedException e) {
            LOG.severe("Interrupted while waiting for ConnectionResult", e);
            return null;
        }
    }

    private static String getHostAndPort(String address) {
        try {
            URL url = new URL("http://" + address);
            return url.getHost() + ":" + url.getPort();
        }
        catch (MalformedURLException e) {
            LOG.fine("Could not get host and port from " + address, new Object[0]);
            return null;
        }
    }

    private static String getCachedProtocol(String address) {
        String hostAndPort = UrlUtilities.getHostAndPort(address);
        if (hostAndPort != null) {
            return protocolCache.get(hostAndPort);
        }
        return null;
    }

    private static void setCachedProtocol(URL url) {
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        protocolCache.put(host + ":" + port, protocol);
        if (port == url.getDefaultPort()) {
            protocolCache.put(host + ":-1", protocol);
        }
    }

    private static class ConnectionResult {
        private final URL url;
        private final boolean success;

        public ConnectionResult(URL url, boolean success) {
            this.url = url;
            this.success = success;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectionAttempt
    implements Runnable {
        private final URL url;
        private final BlockingQueue<ConnectionResult> queue;
        private boolean suppressTimeoutResult = false;

        public ConnectionAttempt(URL url, BlockingQueue<ConnectionResult> queue) {
            this.url = url;
            this.queue = queue;
        }

        @Override
        public void run() {
            String thread = "Thread " + Thread.currentThread().getName() + " - ";
            LOG.fine(thread + "Trying to connect to " + this.url, new Object[0]);
            boolean success = false;
            try {
                HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
                int responseCode = connection.getResponseCode();
                success = responseCode != -1;
                LOG.fine(thread + "Got response code " + responseCode + " from " + this.url, new Object[0]);
            }
            catch (SSLHandshakeException e) {
                success = true;
                LOG.fine(thread + "Got response on " + this.url + " but with SSLHandshakeException", e);
            }
            catch (IOException e) {
                if (this.suppressTimeoutResult) {
                    return;
                }
                LOG.fine(thread + "Connection to " + this.url + " failed because of IOException.", e);
            }
            catch (RuntimeException e) {
                LOG.fine(thread + "Connection to " + this.url + " failed because of RuntimeException", e);
            }
            this.queue.add(new ConnectionResult(this.url, success));
        }

        public void suppressTimeoutResult() {
            this.suppressTimeoutResult = true;
        }
    }
}

