/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.starter.investigator;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.security.starter.investigator.EmApplicationInfo;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmApplicationInfoFactory {
    private static final EmLogger LOG = EmLogger.STARTER;
    private static final String NODE_TYPE = "Node type";
    private static final String APPLICATION_TYPE = "Application type";
    private static final String CABINET_VIEWER = "CabViewer";
    private static final String ELEMENT_MANAGER = "Element Manager";
    private static final String PRESENTATION_NAME = "PresentationName";
    private static final String CONFIGURATION_FILE_PATH = "ConfigurationFilePath";
    private static final String RESOURCE_TYPE_START = "Resource resourceType";
    private static final String ICON = "\"Icon\"";
    private static final String RESOURCE_NAME = "ResourceName";
    private static final String RESOURCE_PATH = "ResourcePath";
    private static final String RESOURCE_REF_SEE = "ResourceRefSee";
    private static final String RESOURCE_END = "/Resource";
    private static final String APPLICATION_END = "/Application";

    public static ArrayList<EmApplicationInfo> constructEmAppInfos(String fileContents) {
        ArrayList<EmApplicationInfo> emAppInfos = new ArrayList<EmApplicationInfo>();
        StringTokenizer tok = new StringTokenizer(fileContents, "<>");
        boolean pickPresentationName = false;
        boolean pickConfigFileName = false;
        boolean iconResourceFound = false;
        boolean pickIconResourceName = false;
        boolean pickIconResourcePath = false;
        boolean pickIconResourceRefSee = false;
        String nodetype = "";
        EmApplicationInfo tempEmApplicationInfo = null;
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            if (str.startsWith(NODE_TYPE)) {
                nodetype = str.substring(NODE_TYPE.length()).replace('\"', ' ');
                nodetype = nodetype.replace('=', ' ');
                nodetype = nodetype.trim();
                continue;
            }
            if (str.startsWith(APPLICATION_TYPE)) {
                String typeName = str.substring(APPLICATION_TYPE.length());
                typeName.substring(0, typeName.length());
                typeName = typeName.replace('=', ' ');
                typeName = typeName.replace("\"", " ");
                typeName = typeName.trim();
                if (null != tempEmApplicationInfo) {
                    if (!tempEmApplicationInfo.getApplicationType().equalsIgnoreCase(CABINET_VIEWER)) {
                        emAppInfos.add(tempEmApplicationInfo);
                    } else {
                        tempEmApplicationInfo = null;
                    }
                }
                tempEmApplicationInfo = new EmApplicationInfo(typeName);
                tempEmApplicationInfo.setNodeType(nodetype);
                continue;
            }
            if (pickPresentationName) {
                tempEmApplicationInfo.setPresentationName(str);
                if (str.endsWith(ELEMENT_MANAGER) || "EM".equals(tempEmApplicationInfo.getApplicationType())) {
                    tempEmApplicationInfo.setDefault(true);
                }
                pickPresentationName = false;
                continue;
            }
            if (str.equalsIgnoreCase(PRESENTATION_NAME)) {
                pickPresentationName = true;
                continue;
            }
            if (pickConfigFileName) {
                tempEmApplicationInfo.setConfigFileName(str);
                pickConfigFileName = false;
                continue;
            }
            if (str.equalsIgnoreCase(CONFIGURATION_FILE_PATH)) {
                pickConfigFileName = true;
                continue;
            }
            if (str.startsWith(RESOURCE_TYPE_START) && str.indexOf(ICON) > 0) {
                iconResourceFound = true;
                continue;
            }
            if (iconResourceFound && str.equalsIgnoreCase(RESOURCE_NAME)) {
                pickIconResourceName = true;
                continue;
            }
            if (iconResourceFound && str.equalsIgnoreCase(RESOURCE_PATH)) {
                pickIconResourcePath = true;
                continue;
            }
            if (iconResourceFound && str.equalsIgnoreCase(RESOURCE_REF_SEE)) {
                pickIconResourceRefSee = true;
                continue;
            }
            if (pickIconResourceName) {
                tempEmApplicationInfo.setIconResourceName(str);
                pickIconResourceName = false;
                continue;
            }
            if (pickIconResourcePath) {
                tempEmApplicationInfo.setIconResourcePath(str);
                pickIconResourcePath = false;
                continue;
            }
            if (pickIconResourceRefSee) {
                tempEmApplicationInfo.setIconResourceRefSee(str);
                pickIconResourceRefSee = false;
                continue;
            }
            if (str.equalsIgnoreCase(RESOURCE_END)) {
                iconResourceFound = false;
                continue;
            }
            if (!str.equalsIgnoreCase(APPLICATION_END)) continue;
            if (!tempEmApplicationInfo.getApplicationType().equals(CABINET_VIEWER)) {
                emAppInfos.add(tempEmApplicationInfo);
            }
            tempEmApplicationInfo = null;
        }
        for (EmApplicationInfo app : emAppInfos) {
            LOG.finest("empappInfo: " + app, new Object[0]);
        }
        return emAppInfos;
    }
}

