/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import java.util.ArrayList;
import se.ericsson.cello.commandlog.logcontentcontrol.InspectorRepository;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.managedelement.DataCollectionGenerationMoGen;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddressValidation;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class DataCollectionGenerationMoImpl
extends DataCollectionGenerationMoGen
implements LogContentInspector {
    private int MAX_LEN_DCG_TYPE = 6;
    private int MIN_LEN_DCG_TYPE = 1;
    private int MAX_LEN_USERNAME = 21;
    private int MAX_LEN_FILEPATH = 255;
    private static final String CONFIGURE_EXT_DCG_SERVER = "configureExtDcgServer";

    public DataCollectionGenerationMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, maoFroIndicationHandler);
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "DataCollectionGeneration");
    }

    public DataCollectionGenerationMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "DataCollectionGeneration");
    }

    public void actionRunDcg(String string, int n, Coordinator coordinator) throws MoAccessException {
        int n2;
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n3 = this.getDcgState(coordinator);
        if (n3 == 1) {
            throw new ActionNotAllowedException("Currently DCG action is ongoing.", "DataCollectionGeneration");
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) == 'e' || string.charAt(n2) == 'm' || string.charAt(n2) == 'i' || string.charAt(n2) == 'a' || string.charAt(n2) == 's' || string.charAt(n2) == 'x') continue;
            throw new IllegalAttributeValueException("dcgType", "Dcg options : e, m, a, i, s, x and their combinations without repititions is allowed ", "DataCollectionGeneration");
        }
        if (string.length() >= this.MIN_LEN_DCG_TYPE && string.length() <= this.MAX_LEN_DCG_TYPE) {
            for (n2 = 0; n2 < string.length(); ++n2) {
                for (int i = n2 + 1; i < string.length(); ++i) {
                    if (string.charAt(n2) != string.charAt(i)) continue;
                    throw new IllegalAttributeValueException("dcgType", "Dcg options : e, m, a, i, s, x and their combinations without repititions is allowed.", "DataCollectionGeneration");
                }
            }
        } else {
            throw new IllegalAttributeValueException(string, "Dcg options : e, m, a, i, s, x and their combinations without repititions is allowed.", "DataCollectionGeneration");
        }
        if (n != 1 && n != 0) {
            throw new IllegalAttributeValueException("destination", "Invalid location of destination directory, should be 0 : LOCAL or 1 : EXTERNAL ", "DataCollectionGeneration");
        }
        if (n == 1 && (this.getDcgExtServer(coordinator).getValue("dcgServerAddress").equals("") || this.getDcgExtServer(coordinator).getValue("filePath").equals(""))) {
            throw new OperationNotAllowedException("DCG external server is not configured ", "DataCollectionGeneration");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new StringParameter("runDcg_dcgType", string));
        arrayList.add(new SignedIntParameter("runDcg_destination", n));
        this.froProxy.actionWithoutCfm(coordinator, this.getFroId(coordinator), 101, arrayList);
    }

    public void actionConfigureExtDcgServer(String string, String string2, String string3, String string4, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (string2.length() > this.MAX_LEN_USERNAME) {
            throw new ValueOutOfRangeException("configureExtDcgServer_username", "DataCollectionGeneration");
        }
        if (string3.length() > this.MAX_LEN_USERNAME) {
            throw new ValueOutOfRangeException("configureExtDcgServer_password", "DataCollectionGeneration");
        }
        if (string4.length() > this.MAX_LEN_FILEPATH) {
            throw new ValueOutOfRangeException("configureExtDcgServer_filePath", "DataCollectionGeneration");
        }
        IpAddressValidation.validateHostName((String)string, (String)"DataCollectionGeneration", (String)"");
        String string5 = string4.substring(string4.length() - 4, string4.length());
        if (!string5.equalsIgnoreCase(".zip")) {
            throw new IllegalAttributeValueException("Filepath must end with .zip", "filePath", "DataCollectionGeneration");
        }
        ArrayList<StringParameter> arrayList = new ArrayList<StringParameter>();
        arrayList.add(new StringParameter("configureExtDcgServer_address", string));
        arrayList.add(new StringParameter("configureExtDcgServer_username", string2));
        arrayList.add(new StringParameter("configureExtDcgServer_password", string3));
        arrayList.add(new StringParameter("configureExtDcgServer_filePath", string4));
        this.froProxy.actionWithoutCfm(coordinator, this.getFroId(coordinator), 102, arrayList);
    }

    public Object[] hideHazardousAttributeValues(AttrList attrList) {
        return null;
    }

    public Object[] hideHazardousActionParameters(String string, Object[] objectArray) {
        try {
            if (string.equalsIgnoreCase(CONFIGURE_EXT_DCG_SERVER)) {
                objectArray[2] = "*****";
                return objectArray;
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + runtimeException));
            return null;
        }
    }
}

