/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import java.util.Iterator;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.PmServiceMo;
import se.ericsson.cello.managedelement.SystemFunctionsMoImpl;
import se.ericsson.cello.mao.GeneralErrorException;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.cello.pms.ne.PmAttributeSetting;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class PmServiceMoImpl
extends ManagedObjectBase
implements PmServiceMo {
    private MoData data;
    private static final int PM_DATA_VOLUME_LENGTH = 9;
    private static final int MO_DATA_REVISION_6 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;
    private static PmServiceMoImpl instance = null;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    static synchronized PmServiceMoImpl instance() {
        try {
            if (instance == null) {
                instance = new PmServiceMoImpl();
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            MessageLog.traceError((Class)PmServiceMoImpl.class, (String)"Create instance of PmService MO failed", (Throwable)moNameAlreadyTakenException);
        }
        return instance;
    }

    private PmServiceMoImpl() throws MoNameAlreadyTakenException {
        super((ManagedObject)SystemFunctionsMoImpl.instance(), "PmService", "1", null);
    }

    synchronized void registerData() {
        if (this.data == null) {
            try {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec"));
                ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
                Iterator iterator = serviceRepository.getServices(PmAttributeSetting.class);
                PmAttributeSetting pmAttributeSetting = null;
                if (!iterator.hasNext()) {
                    throw new GeneralErrorException("PmAttributeSetting service not found", "PmAttributeSetting", 0);
                }
                pmAttributeSetting = (PmAttributeSetting)iterator.next();
                this.data = new MoData(this.getLocalDistinguishedName(), "PmService", true, coordinator);
                this.data.registerPersistentAttr((Attribute)new IntegerAttribute("maxNoOfCounters", true, 65000));
                pmAttributeSetting.setMaxNoOfCounters(((IntegerAttribute)this.data.getAttribute("maxNoOfCounters")).getValue(null));
                this.data.registerPersistentAttr((Attribute)new IntegerAttribute("maxNoOfMonitors", true, 10));
                pmAttributeSetting.setMaxNoOfMonitors(((IntegerAttribute)this.data.getAttribute("maxNoOfMonitors")).getValue(null));
                this.data.registerPersistentAttr((Attribute)new IntegerAttribute("maxNoOfPmFiles", true, 200));
                pmAttributeSetting.setMaxNoOfPmFiles(((IntegerAttribute)this.data.getAttribute("maxNoOfPmFiles")).getValue(null));
                this.data.registerPersistentAttr((Attribute)new IntegerAttribute("minorAlarmCeasingDelta", true, 5));
                pmAttributeSetting.setMinorAlarmCeasingLevel(100 - ((IntegerAttribute)this.data.getAttribute("minorAlarmCeasingDelta")).getValue(null));
                String string = this.getDefaultPmVolume();
                this.data.registerPersistentAttr((Attribute)new StringAttribute("performanceDataVolume", true, string));
                pmAttributeSetting.setPerformanceDataPath(((StringAttribute)this.data.getAttribute("performanceDataVolume")).getValue(null) + "pm_data/");
                this.data.registerPersistentAttr((Attribute)new IntegerAttribute("transactionTimeOut", true, 60));
                pmAttributeSetting.setTransactionTimeout(((IntegerAttribute)this.data.getAttribute("transactionTimeOut")).getValue(null));
                this.data.registerPersistentAttr((Attribute)new IntegerAttribute("warningAlarmLimitPercent", true, 80));
                pmAttributeSetting.setWarningAlarmThreshold(((IntegerAttribute)this.data.getAttribute("warningAlarmLimitPercent")).getValue(null));
                this.data.registerPersistentAttr((Attribute)new IntegerAttribute("warningAlarmCeasingDelta", true, 5));
                pmAttributeSetting.setWarningAlarmCeasingLevel(((IntegerAttribute)this.data.getAttribute("warningAlarmLimitPercent")).getValue(null) - ((IntegerAttribute)this.data.getAttribute("warningAlarmCeasingDelta")).getValue(null));
                this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, ""));
                this.data.setRevision(6000);
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                control.getTerminator().commit();
            }
            catch (TransactionRequiredException transactionRequiredException) {
                MessageLog.traceError(this.getClass(), (String)"start of PmService failed", (Throwable)transactionRequiredException);
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                MessageLog.traceError(this.getClass(), (String)"start of PmService failed", (Throwable)transactionRolledBackException);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"start of PmService failed", (Throwable)inactiveTransactionException);
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError(this.getClass(), (String)"start of PmService failed", (Throwable)moAccessException);
            }
        }
    }

    public void recover(MoData moData) {
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("maxNoOfCounters");
        moDataRecoveryHelper.assertAttribute("maxNoOfMonitors");
        moDataRecoveryHelper.assertAttribute("maxNoOfPmFiles");
        moDataRecoveryHelper.assertAttribute("minorAlarmCeasingDelta");
        moDataRecoveryHelper.assertAttribute("performanceDataVolume");
        moDataRecoveryHelper.assertAttribute("transactionTimeOut");
        moDataRecoveryHelper.assertAttribute("warningAlarmLimitPercent");
        moDataRecoveryHelper.assertAttribute("warningAlarmCeasingDelta");
        moDataRecoveryHelper.assertAttribute("userLabel");
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        PmAttributeSetting pmAttributeSetting = (PmAttributeSetting)serviceRepository.getService(PmAttributeSetting.class);
        if (pmAttributeSetting != null) {
            pmAttributeSetting.setMaxNoOfCounters(((IntegerAttribute)this.data.getAttribute("maxNoOfCounters")).getValue(null));
            pmAttributeSetting.setMaxNoOfMonitors(((IntegerAttribute)this.data.getAttribute("maxNoOfMonitors")).getValue(null));
            pmAttributeSetting.setMaxNoOfPmFiles(((IntegerAttribute)this.data.getAttribute("maxNoOfPmFiles")).getValue(null));
            pmAttributeSetting.setMinorAlarmCeasingLevel(100 - ((IntegerAttribute)this.data.getAttribute("minorAlarmCeasingDelta")).getValue(null));
            pmAttributeSetting.setPerformanceDataPath(((StringAttribute)this.data.getAttribute("performanceDataVolume")).getValue(null) + "pm_data/");
            pmAttributeSetting.setTransactionTimeout(((IntegerAttribute)this.data.getAttribute("transactionTimeOut")).getValue(null));
            pmAttributeSetting.setWarningAlarmThreshold(((IntegerAttribute)this.data.getAttribute("warningAlarmLimitPercent")).getValue(null));
            pmAttributeSetting.setWarningAlarmCeasingLevel(((IntegerAttribute)this.data.getAttribute("warningAlarmLimitPercent")).getValue(null) - ((IntegerAttribute)this.data.getAttribute("warningAlarmCeasingDelta")).getValue(null));
        } else {
            moDataRecoveryHelper.fail("PmAttributeSetting service not found");
        }
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getMinorAlarmCeasingDelta(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("minorAlarmCeasingDelta", coordinator);
    }

    public void setMinorAlarmCeasingDelta(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("minorAlarmCeasingDelta", new Integer(n), coordinator);
    }

    public int getMaxNoOfMonitors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxNoOfMonitors", coordinator);
    }

    public void setMaxNoOfMonitors(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("maxNoOfMonitors", new Integer(n), coordinator);
    }

    public int getMaxNoOfPmFiles(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxNoOfPmFiles", coordinator);
    }

    public void setMaxNoOfPmFiles(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("maxNoOfPmFiles", new Integer(n), coordinator);
    }

    public String getPerformanceDataPath(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("performanceDataPath", coordinator);
    }

    public String getPerformanceDataVolume(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("performanceDataVolume", coordinator);
    }

    public void setPerformanceDataVolume(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("performanceDataVolume", string, coordinator);
    }

    public String getPmServiceId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("PmServiceId", coordinator);
    }

    public int getWarningAlarmLimitPercent(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("warningAlarmLimitPercent", coordinator);
    }

    public void setWarningAlarmLimitPercent(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("warningAlarmLimitPercent", new Integer(n), coordinator);
    }

    public int getWarningAlarmCeasingDelta(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("warningAlarmCeasingDelta", coordinator);
    }

    public void setWarningAlarmCeasingDelta(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("warningAlarmCeasingDelta", new Integer(n), coordinator);
    }

    public int getMaxNoOfCounters(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxNoOfCounters", coordinator);
    }

    public void setMaxNoOfCounters(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("maxNoOfCounters", new Integer(n), coordinator);
    }

    public int getTransactionTimeOut(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("transactionTimeOut", coordinator);
    }

    public void setTransactionTimeOut(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("transactionTimeOut", new Integer(n), coordinator);
    }

    public boolean getSystemSuspended(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("systemSuspended", coordinator);
    }

    public void setSystemSuspended(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("systemSuspended", bl, coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException, GeneralErrorException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        Iterator iterator = serviceRepository.getServices(PmAttributeSetting.class);
        if (!iterator.hasNext()) {
            throw new GeneralErrorException("PmAttributeSetting service not found", "PmAttributeSetting", 0);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxNoOfCounters")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("maxNoOfCounters")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxNoOfMonitors")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("maxNoOfMonitors")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxNoOfPmFiles")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("maxNoOfPmFiles")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("minorAlarmCeasingDelta")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("minorAlarmCeasingDelta")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("PmServiceId")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("performanceDataPath")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("performanceDataVolume")).getValue(coordinator) + "pm_data";
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("performanceDataVolume")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("performanceDataVolume")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("transactionTimeOut")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("transactionTimeOut")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("warningAlarmCeasingDelta")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("warningAlarmCeasingDelta")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("warningAlarmLimitPercent")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("warningAlarmLimitPercent")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("systemSuspended")) {
                objectArray[i] = PmsPortalImpl.getPortal().isSystemSuspended();
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "PmService");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException, GeneralErrorException {
        int n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        Iterator iterator = serviceRepository.getServices(PmAttributeSetting.class);
        PmAttributeSetting pmAttributeSetting = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (!iterator.hasNext()) {
            throw new GeneralErrorException("PmAttributeSetting service not found", "PmAttributeSetting", 0);
        }
        pmAttributeSetting = (PmAttributeSetting)iterator.next();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("minorAlarmCeasingDelta")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? PmServiceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("minorAlarmCeasingDelta", "PmService");
                }
                n4 = (Integer)objectArray[n];
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("warningAlarmCeasingDelta")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? PmServiceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("warningAlarmCeasingDelta", "PmService");
                }
                n3 = (Integer)objectArray[n];
                continue;
            }
            if (!stringArray[n].equalsIgnoreCase("warningAlarmLimitPercent")) continue;
            if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? PmServiceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                throw new WrongAttributeTypeException("warningAlarmLimitPercent", "PmService");
            }
            n2 = (Integer)objectArray[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("userLabel")) {
                if (!objectArray[n].getClass().equals(class$java$lang$String == null ? PmServiceMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "PmService");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[n]), (String)"userLabel", (String)"PmService", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("maxNoOfCounters")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? PmServiceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("maxNoOfCounters", "PmService");
                }
                MoAttributeValidator.checkIntegerAttribute((String)"maxNoOfCounters", (int)((Integer)objectArray[n]), (int)10000, (int)7500000, (String)"PmService");
                try {
                    coordinator.registerResource((Resource)new TxResource((Integer)objectArray[n], -1, -1, -1, null, -1, -1, -1, pmAttributeSetting));
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    MessageLog.traceError(this.getClass(), (String)"setting MaxNoOfCtrs:  ", (Throwable)inactiveTransactionException);
                }
                ((IntegerAttribute)this.data.getAttribute("maxNoOfCounters")).setValue((Integer)objectArray[n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("maxNoOfMonitors")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? PmServiceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("maxNoOfMonitors", "PmService");
                }
                MoAttributeValidator.checkIntegerAttribute((String)"maxNoOfMonitors", (int)((Integer)objectArray[n]), (int)1, (int)30, (String)"PmService");
                try {
                    coordinator.registerResource((Resource)new TxResource(-1, (Integer)objectArray[n], -1, -1, null, -1, -1, -1, pmAttributeSetting));
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    MessageLog.traceError(this.getClass(), (String)"setting MaxNoOfMonitors:  ", (Throwable)inactiveTransactionException);
                }
                ((IntegerAttribute)this.data.getAttribute("maxNoOfMonitors")).setValue((Integer)objectArray[n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("maxNoOfPmFiles")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? PmServiceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("maxNoOfPmFiles", "PmService");
                }
                MoAttributeValidator.checkIntegerAttribute((String)"maxNoOfPmFiles", (int)((Integer)objectArray[n]), (int)10, (int)200, (String)"PmService");
                try {
                    coordinator.registerResource((Resource)new TxResource(-1, -1, (Integer)objectArray[n], -1, null, -1, -1, -1, pmAttributeSetting));
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    MessageLog.traceError(this.getClass(), (String)"setting MaxNoOfPmFiles:  ", (Throwable)inactiveTransactionException);
                }
                ((IntegerAttribute)this.data.getAttribute("maxNoOfPmFiles")).setValue((Integer)objectArray[n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("minorAlarmCeasingDelta")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? PmServiceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("minorAlarmCeasingDelta", "PmService");
                }
                MoAttributeValidator.checkIntegerAttribute((String)"minorAlarmCeasingDelta", (int)((Integer)objectArray[n]), (int)1, (int)30, (String)"PmService");
                int[] nArray = this.getAlarmValues(n2, n3, n4, coordinator);
                this.checkAlarmCeasingLimits(nArray, coordinator);
                try {
                    coordinator.registerResource((Resource)new TxResource(-1, -1, -1, 100 - (Integer)objectArray[n], null, -1, -1, -1, pmAttributeSetting));
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    MessageLog.traceError(this.getClass(), (String)"setting Minor Alarm Ceasing Delta:  ", (Throwable)inactiveTransactionException);
                }
                ((IntegerAttribute)this.data.getAttribute("minorAlarmCeasingDelta")).setValue((Integer)objectArray[n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("performanceDataVolume")) {
                if (!objectArray[n].getClass().equals(class$java$lang$String == null ? PmServiceMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("performanceDataVolume", "PmService");
                }
                this.checkPmDataVolume((String)objectArray[n]);
                try {
                    coordinator.registerResource((Resource)new TxResource(-1, -1, -1, -1, (String)objectArray[n] + "pm_data/", -1, -1, -1, pmAttributeSetting));
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    MessageLog.traceError(this.getClass(), (String)"setting Performance Data Volume:  ", (Throwable)inactiveTransactionException);
                }
                ((StringAttribute)this.data.getAttribute("performanceDataVolume")).setValue((String)objectArray[n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("transactionTimeOut")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? PmServiceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("transactionTimeOut", "PmService");
                }
                MoAttributeValidator.checkIntegerAttribute((String)"transactionTimeOut", (int)((Integer)objectArray[n]), (int)60, (int)600, (String)"PmService");
                try {
                    coordinator.registerResource((Resource)new TxResource(-1, -1, -1, -1, null, (Integer)objectArray[n], -1, -1, pmAttributeSetting));
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    MessageLog.traceError(this.getClass(), (String)"setting Transaction TimeOut:  ", (Throwable)inactiveTransactionException);
                }
                ((IntegerAttribute)this.data.getAttribute("transactionTimeOut")).setValue((Integer)objectArray[n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("warningAlarmCeasingDelta")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? PmServiceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("warningAlarmCeasingDelta", "PmService");
                }
                MoAttributeValidator.checkIntegerAttribute((String)"warningAlarmCeasingDelta", (int)((Integer)objectArray[n]), (int)1, (int)20, (String)"PmService");
                int[] nArray = this.getAlarmValues(n2, n3, n4, coordinator);
                this.checkAlarmCeasingLimits(nArray, coordinator);
                this.checkWarningAlarm(nArray, coordinator);
                try {
                    coordinator.registerResource((Resource)new TxResource(-1, -1, -1, -1, null, -1, nArray[0] - (Integer)objectArray[n], -1, pmAttributeSetting));
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    MessageLog.traceError(this.getClass(), (String)"setting AlarmCeasingLevel:  ", (Throwable)inactiveTransactionException);
                }
                ((IntegerAttribute)this.data.getAttribute("warningAlarmCeasingDelta")).setValue((Integer)objectArray[n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("warningAlarmLimitPercent")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? PmServiceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("warningAlarmLimitPercent", "PmService");
                }
                MoAttributeValidator.checkIntegerAttribute((String)"warningAlarmLimitPercent", (int)((Integer)objectArray[n]), (int)0, (int)100, (String)"PmService");
                int[] nArray = this.getAlarmValues(n2, n3, n4, coordinator);
                this.checkWarningAlarm(nArray, coordinator);
                try {
                    coordinator.registerResource((Resource)new TxResource(-1, -1, -1, -1, null, -1, nArray[0] - nArray[1], (Integer)objectArray[n], pmAttributeSetting));
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    MessageLog.traceError(this.getClass(), (String)"setting AlarmLimitPercent:  ", (Throwable)inactiveTransactionException);
                }
                ((IntegerAttribute)this.data.getAttribute("warningAlarmLimitPercent")).setValue((Integer)objectArray[n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("systemSuspended")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Boolean == null ? PmServiceMoImpl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException("systemSuspended", "PmService");
                }
                boolean bl = (Boolean)objectArray[n];
                try {
                    if (bl) {
                        PmsPortalImpl.getPortal().suspendPerformanceMonitorings();
                        continue;
                    }
                    PmsPortalImpl.getPortal().resumePerformanceMonitorings();
                    continue;
                }
                catch (Exception exception) {
                    MessageLog.traceError(this.getClass(), (String)("Problem setting systemSuspended to " + bl), (Throwable)exception);
                    throw new GeneralErrorException("", "Unable to set systemSuspended to " + bl + ": " + exception, 0);
                }
            }
            throw new NoSuchAttributeException(stringArray[n], "PmService");
        }
    }

    private void checkWarningAlarm(int[] nArray, Coordinator coordinator) throws MoAccessException {
        int n = nArray[0];
        int n2 = nArray[1];
        if (n <= n2) {
            throw new OperationNotAllowedException("Condition warningAlarmLimitPercent > warningAlarmCeasingDelta must be fulfilled", "PmService");
        }
    }

    private void checkAlarmCeasingLimits(int[] nArray, Coordinator coordinator) throws MoAccessException {
        int n = nArray[2];
        int n2 = 100 - n;
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = n3 - n4;
        if (n2 < n5) {
            throw new OperationNotAllowedException("Condition minorAlarmCeasingLimit >= warningAlarmCeasingLimit must be fulfilled", "PmService");
        }
    }

    private int[] getAlarmValues(int n, int n2, int n3, Coordinator coordinator) throws MoAccessException {
        if (n == -1) {
            n = (Integer)this.getAttribute("warningAlarmLimitPercent", coordinator);
        }
        if (n2 == -1) {
            n2 = (Integer)this.getAttribute("warningAlarmCeasingDelta", coordinator);
        }
        if (n3 == -1) {
            n3 = (Integer)this.getAttribute("minorAlarmCeasingDelta", coordinator);
        }
        int[] nArray = new int[]{n, n2, n3};
        return nArray;
    }

    private String getDefaultPmVolume() {
        if (System.getProperty("SIM") == null) {
            return "/c/";
        }
        return DEFAULT_HOST_PMVOLUME;
    }

    private void checkPmDataVolume(String string) throws MoAccessException {
        if (!string.endsWith("/")) {
            throw new IllegalAttributeValueException(string, this.getType());
        }
        if (string.startsWith("/c")) {
            if (string.length() != 3) {
                throw new IllegalAttributeValueException(string, this.getType());
            }
        } else if (string.startsWith("/p")) {
            if (string.length() != 9) {
                throw new IllegalAttributeValueException(string, this.getType());
            }
            for (int i = 2; i < string.length() - 1; ++i) {
                char c = string.charAt(i);
                if (c >= '0' && c <= '9') continue;
                throw new IllegalAttributeValueException(string, this.getType());
            }
        } else if (string.startsWith("/r")) {
            if (string.length() != 9) {
                throw new IllegalAttributeValueException(string, this.getType());
            }
            for (int i = 2; i < string.length() - 1; ++i) {
                char c = string.charAt(i);
                if (c >= '0' && c <= '9') continue;
                throw new IllegalAttributeValueException(string, this.getType());
            }
        } else {
            throw new IllegalAttributeValueException(string, this.getType());
        }
    }

    public String getType() {
        return "PmService";
    }

    private static class TxResource
    implements Resource {
        private int maxNoOfCounters = -1;
        private int maxNoOfMonitors = -1;
        private int maxNoOfPmFiles = -1;
        private int minorAlarmCeasingLevel = -1;
        private String performanceDataPath = null;
        private int txTimeOut = -1;
        private int warningAlarmCeasingLevel = -1;
        private int alarmThreshold = -1;
        private PmAttributeSetting pmAttrSett;

        public TxResource(int n, int n2, int n3, int n4, String string, int n5, int n6, int n7, PmAttributeSetting pmAttributeSetting) {
            this.maxNoOfCounters = n;
            this.maxNoOfMonitors = n2;
            this.maxNoOfPmFiles = n3;
            this.minorAlarmCeasingLevel = n4;
            this.performanceDataPath = string;
            this.txTimeOut = n5;
            this.warningAlarmCeasingLevel = n6;
            this.alarmThreshold = n7;
            this.pmAttrSett = pmAttributeSetting;
        }

        public void commit() {
            Thread thread = new Thread(new Runnable(this){
                private final /* synthetic */ TxResource this$0;
                {
                    this.this$0 = txResource;
                }

                public void run() {
                    if (TxResource.access$000(this.this$0) != -1) {
                        TxResource.access$100(this.this$0).setMaxNoOfCounters(TxResource.access$000(this.this$0));
                    }
                    if (TxResource.access$200(this.this$0) != -1) {
                        TxResource.access$100(this.this$0).setMaxNoOfMonitors(TxResource.access$200(this.this$0));
                    }
                    if (TxResource.access$300(this.this$0) != -1) {
                        TxResource.access$100(this.this$0).setMaxNoOfPmFiles(TxResource.access$300(this.this$0));
                    }
                    if (TxResource.access$400(this.this$0) != -1) {
                        TxResource.access$100(this.this$0).setMinorAlarmCeasingLevel(TxResource.access$400(this.this$0));
                    }
                    if (TxResource.access$500(this.this$0) != null) {
                        TxResource.access$100(this.this$0).setPerformanceDataPath(TxResource.access$500(this.this$0));
                    }
                    if (TxResource.access$600(this.this$0) != -1) {
                        TxResource.access$100(this.this$0).setTransactionTimeout(TxResource.access$600(this.this$0));
                    }
                    if (TxResource.access$700(this.this$0) != -1) {
                        TxResource.access$100(this.this$0).setWarningAlarmCeasingLevel(TxResource.access$700(this.this$0));
                    }
                    if (TxResource.access$800(this.this$0) != -1) {
                        TxResource.access$100(this.this$0).setWarningAlarmThreshold(TxResource.access$800(this.this$0));
                    }
                }
            });
            thread.start();
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
        }

        static /* synthetic */ int access$000(TxResource txResource) {
            return txResource.maxNoOfCounters;
        }

        static /* synthetic */ PmAttributeSetting access$100(TxResource txResource) {
            return txResource.pmAttrSett;
        }

        static /* synthetic */ int access$200(TxResource txResource) {
            return txResource.maxNoOfMonitors;
        }

        static /* synthetic */ int access$300(TxResource txResource) {
            return txResource.maxNoOfPmFiles;
        }

        static /* synthetic */ int access$400(TxResource txResource) {
            return txResource.minorAlarmCeasingLevel;
        }

        static /* synthetic */ String access$500(TxResource txResource) {
            return txResource.performanceDataPath;
        }

        static /* synthetic */ int access$600(TxResource txResource) {
            return txResource.txTimeOut;
        }

        static /* synthetic */ int access$700(TxResource txResource) {
            return txResource.warningAlarmCeasingLevel;
        }

        static /* synthetic */ int access$800(TxResource txResource) {
            return txResource.alarmThreshold;
        }
    }
}

