/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.managedelement.NtpServerMo;
import se.ericsson.cello.managedelement.StructDstRuleImpl;
import se.ericsson.cello.managedelement.TimeSettingMoGen;
import se.ericsson.cello.managedelement.mom.EnumDstMonth;
import se.ericsson.cello.managedelement.mom.StructDstRule;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.ParameterNames;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.mao.StringChecksUtils;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.util.library.Lib;

public class TimeSettingMoImpl
extends TimeSettingMoGen {
    private static final int NODE_UTCT_TIME_MIN = 0;
    private static final int TIMESETTING_FRO_ID = 1;
    private static final int DST_DAY_RULE_MAX_LENGTH = 9;
    private static final int MONTH_FIRST_DAY = 1;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public TimeSettingMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, maoFroIndicationHandler);
    }

    public TimeSettingMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, true, froProxy, maoFroIndicationHandler);
    }

    public void addParameterNames(ParameterNames parameterNames) {
        parameterNames.add("dstEndRuleString");
        parameterNames.add("dstStartRuleString");
    }

    protected void validateTimeOffset(String string, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateTimeOffset(string, setRequestContext);
        this.validateFormat(string, "", "[-]dd:dd", "Should be in the form [-]hh:mm");
    }

    private void validateFormat(String string, String string2, String string3, String string4) throws IllegalAttributeValueException {
        boolean bl = true;
        if (!string.equals(string2)) {
            bl = StringChecksUtils.validateFormatWithOptionalChars((String)string, (String)string3);
        }
        if (!bl) {
            throw new IllegalAttributeValueException("Wrong attribute format." + string4, "TimeSetting");
        }
    }

    protected void validateDaylightSavingTimeOffset(String string, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateDaylightSavingTimeOffset(string, setRequestContext);
        this.validateSimpleFormat(string, "", "dd:dd", " Should be in the form hh:mm");
    }

    private void validateSimpleFormat(String string, String string2, String string3, String string4) throws IllegalAttributeValueException {
        boolean bl = true;
        if (!string.equals(string2)) {
            bl = StringChecksUtils.validateFormat((String)string, (String)string3);
        }
        if (!bl) {
            throw new IllegalAttributeValueException("Wrong attribute format. " + string4, "TimeSetting");
        }
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return 1;
    }

    protected void validateGpsToUtcLeapSecondsChangeDate(String string, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateGpsToUtcLeapSecondsChangeDate(string, setRequestContext);
        this.validateFormat(string, "", "[-]dddd-dd-dd", "Should be in the form [-]yyyy-mm-dd)");
    }

    private Object getOfDeprecatedAttributes(GetRequestContext getRequestContext, String string, String string2) throws MoAccessException {
        StringParameter stringParameter = (StringParameter)getRequestContext.getParameter(string);
        if (stringParameter == null) {
            throw new FroRequestFailedException("TimeSetting", "Missing parameter from FRO: " + string2, "getAttributes", -1);
        }
        return stringParameter.getValue();
    }

    protected Object handleGetDaylightSavingTimeStartDate(GetRequestContext getRequestContext) throws MoAccessException {
        return this.getOfDeprecatedAttributes(getRequestContext, "dstStartRuleString", "daylightSavingTimeStartDate");
    }

    private void setOfDeprecatedAttributes(String string, String string2, SetRequestContext setRequestContext, String string3, String string4, String string5) throws MoAccessException {
        String string6 = "";
        if (string != null && string != string6) {
            if (string.equals(string2)) {
                throw new OperationNotAllowedException("The daylightSavingStartDate and daylightSavingEndDate must not be equal", "TimeSetting");
            }
            this.validateSimpleFormat(string, string6, "dddd-dd-dd dd:dd", " Should be in the form yyyy-mm-dd hh:mm");
            this.validateStringDstDates(string, string3);
        }
        setRequestContext.addParameter(this.froProxy, (Parameter)new StringParameter(string5, string));
        if (string != null) {
            Struct struct = TimeSettingMoImpl.convertStringDsttoStructDst(string);
            setRequestContext.addParameter(this.froProxy, (Parameter)StructDstRuleImpl.toStructParameter(struct, "TimeSetting", string4));
            setRequestContext.addAvcNotification(string4, (Object)struct);
        }
        setRequestContext.addAvcNotification(string3, (Object)string);
    }

    protected void handleSetDaylightSavingTimeStartDate(String string, SetRequestContext setRequestContext) throws MoAccessException {
        String string2 = this.getDaylightSavingTimeEndDate(setRequestContext.getCoordinator());
        this.setOfDeprecatedAttributes(string, string2, setRequestContext, "daylightSavingTimeStartDate", "daylightSavingTimeStartRule", "dstStartRuleString");
    }

    protected Object handleGetDaylightSavingTimeEndDate(GetRequestContext getRequestContext) throws MoAccessException {
        return this.getOfDeprecatedAttributes(getRequestContext, "dstEndRuleString", "daylightSavingTimeEndDate");
    }

    protected void handleSetDaylightSavingTimeEndDate(String string, SetRequestContext setRequestContext) throws MoAccessException {
        String string2 = this.getDaylightSavingTimeStartDate(setRequestContext.getCoordinator());
        this.setOfDeprecatedAttributes(string, string2, setRequestContext, "daylightSavingTimeEndDate", "daylightSavingTimeEndRule", "dstEndRuleString");
    }

    protected Object handleGetDaylightSavingTimeOffDate(GetRequestContext getRequestContext) throws MoAccessException {
        return this.getOfDeprecatedAttributes(getRequestContext, "dstEndRuleString", "daylightSavingTimeOffDate");
    }

    protected void handleSetDaylightSavingTimeOffDate(String string, SetRequestContext setRequestContext) throws MoAccessException {
        String string2 = this.getDaylightSavingTimeOnDate(setRequestContext.getCoordinator());
        this.setOfDeprecatedAttributes(string, string2, setRequestContext, "daylightSavingTimeOffDate", "daylightSavingTimeEndRule", "dstEndRuleString");
    }

    protected Object handleGetDaylightSavingTimeOnDate(GetRequestContext getRequestContext) throws MoAccessException {
        return this.getOfDeprecatedAttributes(getRequestContext, "dstStartRuleString", "daylightSavingTimeOnDate");
    }

    protected void handleSetDaylightSavingTimeOnDate(String string, SetRequestContext setRequestContext) throws MoAccessException {
        String string2 = this.getDaylightSavingTimeOffDate(setRequestContext.getCoordinator());
        this.setOfDeprecatedAttributes(string, string2, setRequestContext, "daylightSavingTimeOnDate", "daylightSavingTimeStartRule", "dstStartRuleString");
    }

    public void actionSetNodeUTCTime(long l, Coordinator coordinator) throws MoAccessException {
        Object object;
        if (l < 0L) {
            throw new ValueOutOfRangeException("TimeSetting", "NodeUTCTime can not be set to a time before January 1,1970, 00:00:00 GMT.");
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        MoIterator moIterator = MoRepository.instance().lookupType("NtpServer");
        while (moIterator != null && moIterator.hasMoreElements()) {
            object = (NtpServerMo)moIterator.nextElement();
            if (!object.getServiceActive(coordinator)) continue;
            throw new ActionNotAllowedException("TimeSetting", "serviceActive must be false on all NtpServer. " + object.getLocalDistinguishedName() + " is active");
        }
        object = new ArrayList();
        ((ArrayList)object).add(new UnsignedIntParameter("nodeUTCTime", l /= 1000L));
        this.froProxy.actionWithCfm(coordinator, 1, 101, (Collection)object);
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        if (setRequestContext.isIncludedInRequest("daylightSavingTimeStartRule")) {
            Struct struct = (Struct)setRequestContext.getAttributeFromRequest("daylightSavingTimeStartRule");
            String string = this.getDaylightSavingTimeEndDate(coordinator);
            this.addDstRulesInSet(struct, string, "dstStartRuleString", "daylightSavingTimeStartRule", setRequestContext, "dstEndRuleString");
        } else if (setRequestContext.isIncludedInRequest("daylightSavingTimeEndRule")) {
            Struct struct = (Struct)setRequestContext.getAttributeFromRequest("daylightSavingTimeEndRule");
            String string = this.getDaylightSavingTimeStartDate(coordinator);
            this.addDstRulesInSet(struct, string, "dstEndRuleString", "daylightSavingTimeEndRule", setRequestContext, "dstEndRuleString");
        }
    }

    private void addDstRulesInSet(Struct struct, String string, String string2, String string3, SetRequestContext setRequestContext, String string4) throws MoAccessException {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        Coordinator coordinator = setRequestContext.getCoordinator();
        boolean bl = false;
        boolean bl2 = false;
        String string5 = this.validateDstRule(struct, n);
        setRequestContext.addParameter(this.froProxy, (Parameter)new StringParameter(string2, string5));
        String string6 = (String)struct.getValue("time");
        String string7 = (String)struct.getValue("dayRule");
        if (string6.equals("24:00") && string7.length() == 1 || string7.length() == 2) {
            struct = TimeSettingMoImpl.convertStringDsttoStructDst(string5);
            setRequestContext.replaceParameter(this.froProxy, (Parameter)StructDstRuleImpl.toStructParameter(struct, "TimeSetting", string3));
        }
        if (!string.equals("") && !string5.equals("")) {
            if (string3.equalsIgnoreCase("daylightSavingTimeEndRule")) {
                bl = this.compareStartandEndRules(string5, string);
                if (!bl) {
                    bl2 = this.checkDstDatesTimeDiff(string5, string);
                }
            } else {
                bl = this.compareStartandEndRules(string, string5);
                if (!bl) {
                    bl2 = this.checkDstDatesTimeDiff(string, string5);
                }
            }
            if (bl || bl2) {
                Struct struct2 = string3.equalsIgnoreCase("daylightSavingTimeEndRule") ? struct : this.getDaylightSavingTimeEndRule(coordinator);
                String string8 = this.validateDstRule(struct2, ++n);
                setRequestContext.replaceParameter(this.froProxy, (Parameter)new StringParameter(string4, string8));
            }
        }
    }

    private boolean checkDstDatesTimeDiff(String string, String string2) {
        try {
            Date date = this.format.parse(string2);
            Date date2 = this.format.parse(string);
            long l = date2.getTime() - date.getTime();
            long l2 = l / 3600000L;
            if (l2 < 24L) {
                return true;
            }
        }
        catch (ParseException parseException) {
            MessageLog.traceError(this.getClass(), (String)("parse exception: " + parseException.toString()));
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String validateDstRule(Struct struct, int n) throws MoAccessException {
        String string;
        Struct struct2 = struct;
        boolean bl = this.isDeFaultValues(struct);
        if (bl) {
            return "";
        }
        String string2 = "0";
        String string3 = (String)struct2.getValue("time");
        this.checktimeRange(string3);
        int n2 = (Integer)struct2.getValue("month");
        MoGenUtil.checkEnumAttribute((String)"month", (int)n2, (int[])EnumDstMonth.VALUES_ARRAY, (String)"TimeSetting");
        String string4 = Integer.toString(n2);
        if (string4.length() == 1) {
            string4 = string2.concat(string4);
        }
        if ((string = (String)struct2.getValue("dayRule")) != null) {
            int n3;
            if (string.length() > 9) {
                throw new ValueOutOfRangeException("Invalid dayRule given", "dayRule", "TimeSetting");
            }
            if (string.length() == 1) {
                this.validateSimpleFormat(string, "", "d", "dayRule should be in the format d if dayRule is of single digit");
                if (string.equals(string2)) {
                    throw new IllegalAttributeValueException("dayRule value cannot be 0", "dayRule", "TimeSetting");
                }
                string = string2.concat(string);
            } else if (string.length() == 2) {
                this.validateSimpleFormat(string, "", "dd", "should be in the format dd if dayRule is of double digit");
                int n4 = Integer.parseInt(string);
                n3 = this.getMonthLastDate(n2, n);
                if (n4 < 1) throw new IllegalAttributeValueException("dayRule value cannot be greater than the last date of the given month", "dayRule", "TimeSetting");
                if (n4 > n3) {
                    throw new IllegalAttributeValueException("dayRule value cannot be greater than the last date of the given month", "dayRule", "TimeSetting");
                }
            } else if (string.startsWith("last")) {
                if (string.length() != 7) throw new IllegalAttributeValueException("if dayRule starts with last then it should be in the format DDD, where DDD can be Sun, Mon, Tue, Wed, Thu, Fri, Sat", "dayRule", "TimeSetting");
                String string5 = string.substring(4);
                this.validateDDD(string5);
                n3 = this.getDayOfWeek(string5);
                int n5 = this.getLastDDDdate(n3, n2, n);
                string = Integer.toString(n5);
            } else {
                int n6;
                int n7;
                if (string.length() > 9) throw new IllegalAttributeValueException("Wrong format of dayRule entered", "dayRule", "TimeSetting");
                if (Lib.containsWhiteSpace((String)string)) {
                    string = Lib.removeWhiteSpaces((String)string);
                }
                String string6 = string.substring(0, 3);
                this.validateDDD(string6);
                n3 = this.getMonthLastDate(n2, n);
                String string7 = "";
                int n8 = 0;
                if (string.length() == 6) {
                    this.validateSimpleFormat(string, "", "www>=d", "should be in the format DDD >= N");
                    string7 = string.substring(5);
                    n8 = Integer.parseInt(string7);
                }
                if (string.length() == 7) {
                    this.validateSimpleFormat(string, "", "www>=dd", "should be in the format DDD >= N");
                    string7 = string.substring(5);
                    n8 = Integer.parseInt(string7);
                    if (n8 > n3) {
                        throw new IllegalAttributeValueException(string7 + " should not be greater than last date of the given month", "dayRule", "TimeSetting");
                    }
                }
                if ((n7 = this.getDDDdate(n8, n6 = this.getDayOfWeek(string6), n3, n2, n)) == 0) {
                    throw new IllegalAttributeValueException("There is no " + string6 + " greater than " + string7, "dayRule", "TimeSetting");
                }
                string = Integer.toString(n7);
                if (string.length() == 1) {
                    string = string2.concat(string);
                }
            }
        }
        String string8 = n + "-" + string4 + "-" + string + " " + string3;
        String string9 = "";
        try {
            Date date = this.format.parse(string8);
            return this.format.format(date);
        }
        catch (ParseException parseException) {
            MessageLog.traceError(this.getClass(), (String)("parse exception: " + parseException.toString()));
        }
        return string9;
    }

    private boolean isDeFaultValues(Struct struct) throws MoAccessException {
        String string = (String)struct.getValue("dayRule");
        String string2 = (String)struct.getValue("time");
        int n = (Integer)struct.getValue("month");
        if (n == 1) {
            if (string.equals("") && !string2.equals("")) {
                throw new IllegalAttributeValueException("If given dayRule and month are  of default values then the value of time entered should be default", "TimeSetting");
            }
            if (string2.equals("") && !string.equals("")) {
                throw new IllegalAttributeValueException("If given time and month are  of default values then the value of dayRule entered should be default", "TimeSetting");
            }
            if (string.equals("") && string2.equals("")) {
                return true;
            }
        } else {
            if (string.equals("")) {
                if (n == 1 && string2.equals("")) {
                    return true;
                }
                throw new IllegalAttributeValueException("if given dayRule is of default value then the other values of struct entered should be default", "TimeSetting");
            }
            if (string2.equals("")) {
                if (n == 1 && string.equals("")) {
                    return true;
                }
                throw new IllegalAttributeValueException("if given time is of default value then the other values of struct entered should be default", "TimeSetting");
            }
        }
        return false;
    }

    private void validateDDD(String string) throws IllegalAttributeValueException {
        this.validateSimpleFormat(string, "", "www", "should be in the format DDD");
        if (!(string.equalsIgnoreCase("Sun") || string.equalsIgnoreCase("Mon") || string.equalsIgnoreCase("Tue") || string.equalsIgnoreCase("Wed") || string.equalsIgnoreCase("Thu") || string.equalsIgnoreCase("Fri") || string.equalsIgnoreCase("Sat"))) {
            throw new IllegalAttributeValueException("DDD can only be Sun, Mon, Tue, Wed, Thu, Fri, Sat", "dayRule", "TimeSetting");
        }
    }

    private int getDDDdate(int n, int n2, int n3, int n4, int n5) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n5, n4 - 1, n);
        int n6 = calendar.get(7);
        int n7 = 0;
        if (n2 == n6) {
            return n;
        }
        n7 = n6 < n2 ? n2 - n6 : (n2 += 7) - n6;
        if (n + n7 > n3) {
            return 0;
        }
        return n + n7;
    }

    private int getLastDDDdate(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        int n4 = this.getMonthLastDate(n2, n3);
        calendar.set(n3, n2 - 1, n4);
        int n5 = calendar.get(7);
        int n6 = 0;
        if (n == n5) {
            return n4;
        }
        n6 = n5 > n ? n5 - n : (n5 += 7) - n;
        return n4 - n6;
    }

    private int getDayOfWeek(String string) {
        if (string.equalsIgnoreCase("Sun")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Mon")) {
            return 2;
        }
        if (string.equalsIgnoreCase("Tue")) {
            return 3;
        }
        if (string.equalsIgnoreCase("Wed")) {
            return 4;
        }
        if (string.equalsIgnoreCase("Thu")) {
            return 5;
        }
        if (string.equalsIgnoreCase("Fri")) {
            return 6;
        }
        if (string.equalsIgnoreCase("Sat")) {
            return 7;
        }
        return 0;
    }

    private int getMonthLastDate(int n, int n2) {
        switch (n) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return n2 % 4 == 0 && n2 % 100 != 0 || n2 % 400 == 0 ? 29 : 28;
    }

    private static Struct convertStringDsttoStructDst(String string) {
        if (string.equals("")) {
            StructImpl structImpl = new StructImpl(StructDstRule.ELEMENT_NAMES, StructDstRule.ELEMENT_DEFAULTVALUES);
            return structImpl;
        }
        String string2 = string.substring(5, 7);
        String string3 = string.substring(8, 10);
        String string4 = string.substring(11);
        if (string3.startsWith("0")) {
            string3 = string3.substring(1);
        }
        if (string2.startsWith("0")) {
            string2 = string2.substring(1);
        }
        int n = Integer.parseInt(string2);
        Struct struct = StructDstRule.createStruct(string3, n, string4);
        return struct;
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl();
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
            Iterator iterator = map.keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                SignedIntParameter signedIntParameter;
                string = (String)iterator.next();
                if (string.equals("daylightSavingTimeOn")) {
                    signedIntParameter = (SignedIntParameter)map.get("daylightSavingTimeOn");
                    if (!signedIntParameter.getBoolean()) {
                        Calendar calendar;
                        String string2;
                        boolean bl;
                        Control control = null;
                        TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                        control = transactionFactory.create(3600);
                        Coordinator coordinator = control.getCoordinator();
                        String string3 = this.getDaylightSavingTimeStartDate(coordinator);
                        String string4 = this.getDaylightSavingTimeEndDate(coordinator);
                        if (!string4.equals("") && !string3.equals("") && (bl = this.compareStartandEndRules(string4, string2 = this.format.format((calendar = Calendar.getInstance()).getTime())))) {
                            Struct struct = this.getDaylightSavingTimeEndRule(coordinator);
                            int n = Integer.parseInt(string4.substring(0, 4));
                            String string5 = this.validateDstRule(struct, n + 1);
                            Struct struct2 = this.getDaylightSavingTimeStartRule(coordinator);
                            int n2 = Integer.parseInt(string3.substring(0, 4));
                            String string6 = this.validateDstRule(struct2, n2 + 1);
                            String[] stringArray = new String[]{"dstEndRuleString", "dstStartRuleString"};
                            Object[] objectArray = new Object[]{string5, string6};
                            SetRequestContextImpl setRequestContextImpl2 = new SetRequestContextImpl(stringArray, objectArray, coordinator);
                            setRequestContextImpl2.addParameter(this.froProxy, (Parameter)new StringParameter("dstEndRuleString", string5));
                            setRequestContextImpl2.addParameter(this.froProxy, (Parameter)new StringParameter("dstStartRuleString", string6));
                            setRequestContextImpl2.sendSetRequest(this.froProxy, this.getFroId(coordinator));
                            setRequestContextImpl2.sendAvcNotifications((ManagedObject)this);
                        }
                        control.getTerminator().commit();
                    }
                    setRequestContextImpl.addAvcNotification("daylightSavingTimeOn", (Object)signedIntParameter.getBoolean());
                    continue;
                }
                if (string.equals("gpsToUtcLeapSeconds")) {
                    signedIntParameter = (SignedIntParameter)map.get("gpsToUtcLeapSeconds");
                    setRequestContextImpl.addAvcNotification("gpsToUtcLeapSeconds", (Object)new Integer(signedIntParameter.getValue()));
                    continue;
                }
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag not found");
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(this.getClass(), (String)("rollback exception: " + transactionRolledBackException.toString()));
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)("Invalid Transaction Exception: " + inactiveTransactionException.toString()));
        }
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    private boolean compareStartandEndRules(String string, String string2) {
        try {
            Date date = this.format.parse(string2);
            Date date2 = this.format.parse(string);
            if (date2.before(date)) {
                return true;
            }
        }
        catch (ParseException parseException) {
            MessageLog.traceError(this.getClass(), (String)("parse exception: " + parseException.toString()));
        }
        return false;
    }

    private void validateStringDstDates(String string, String string2) throws MoAccessException {
        int n = Integer.parseInt(string.substring(0, 4));
        String string3 = string.substring(5, 7);
        String string4 = string.substring(8, 10);
        String string5 = string.substring(11);
        this.checktimeRange(string5);
        if (string3.startsWith("0")) {
            string3 = string3.substring(1);
        }
        int n2 = Integer.parseInt(string3);
        MoGenUtil.checkEnumAttribute((String)"month", (int)n2, (int[])EnumDstMonth.VALUES_ARRAY, (String)"TimeSetting");
        if (string4.startsWith("0")) {
            string4 = string4.substring(1);
        }
        int n3 = this.getMonthLastDate(n2, n);
        int n4 = Integer.parseInt(string4);
        if (n4 > n3) {
            throw new ValueOutOfRangeException(string2, "TimeSetting", "the day entered is greater than" + n3 + " that is the last date of the given month");
        }
    }

    private void checktimeRange(String string) throws MoAccessException {
        if (string != null) {
            this.validateSimpleFormat(string, "", "dd:dd", "time should be in the format dd:dd");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            if (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = Integer.parseInt(string2);
                if (n < 0 || n > 24) {
                    throw new ValueOutOfRangeException("hour should be in the range 0 to 24", "time", "TimeSetting");
                }
                String string3 = stringTokenizer.nextToken();
                int n2 = Integer.parseInt(string3);
                if (n == 24 && n2 != 0) {
                    throw new ValueOutOfRangeException("if hour is 24 then minute can only be 0", "time", "TimeSetting");
                }
                if (n2 < 0 || n2 > 59) {
                    throw new ValueOutOfRangeException("minute should be in the range 0 to 59", "time", "TimeSetting");
                }
            }
        }
    }

    protected Object onGetAttributes(GetRequestContext getRequestContext, String string, Object object) throws MoAccessException {
        if (string.equalsIgnoreCase("nodeUTCTime")) {
            UnsignedIntParameter unsignedIntParameter = (UnsignedIntParameter)getRequestContext.getParameter("nodeUTCTime");
            object = new Long(unsignedIntParameter.getValue() * 1000L);
        } else if (string.equalsIgnoreCase("daylightSavingTimeEndRule") || string.equalsIgnoreCase("daylightSavingTimeStartRule")) {
            Calendar calendar = Calendar.getInstance();
            int n = calendar.get(1);
            StructParameter structParameter = (StructParameter)getRequestContext.getParameter(string);
            String string2 = this.validateDstRule(StructDstRuleImpl.toStruct(structParameter), n);
            StringParameter stringParameter = string.equalsIgnoreCase("daylightSavingTimeStartRule") ? (StringParameter)getRequestContext.getParameter("dstStartRuleString") : (StringParameter)getRequestContext.getParameter("dstEndRuleString");
            if (string2.equals("") && !string2.equals(stringParameter.getValue())) {
                Control control = null;
                try {
                    TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                    control = transactionFactory.create(3600);
                    Coordinator coordinator = control.getCoordinator();
                    Struct struct = TimeSettingMoImpl.convertStringDsttoStructDst(stringParameter.getValue());
                    String[] stringArray = new String[]{string};
                    Object[] objectArray = new Object[]{struct};
                    SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)StructDstRuleImpl.toStructParameter(struct, "TimeSetting", string));
                    setRequestContextImpl.sendSetRequest(this.froProxy, this.getFroId(coordinator));
                    setRequestContextImpl.addAvcNotification(string, (Object)struct);
                    setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
                    control.getTerminator().commit();
                    return struct;
                }
                catch (TransactionRolledBackException transactionRolledBackException) {
                    MessageLog.traceError(this.getClass(), (String)("rollback exception: " + transactionRolledBackException.toString()));
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    MessageLog.traceError(this.getClass(), (String)("Inactive Transaction Exception: " + inactiveTransactionException.toString()));
                }
            }
            return StructDstRuleImpl.toStruct(structParameter);
        }
        return object;
    }
}

