/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.masu.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import se.ericsson.cello.emas.masu.applications.LockView;
import se.ericsson.cello.support.gui.gengui.SyntaxException;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;

public class LockController
extends AbstractApplicationController
implements ActionListener {
    public LockView view;

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("LOCK")) {
            this.lock();
            this.getApplication().stopApplication();
        } else if (event.getActionCommand().equals("CANCEL")) {
            this.getApplication().stopApplication();
        }
    }

    public boolean canStop() {
        return true;
    }

    protected void init() {
        this.view = (LockView)this.getView();
        this.getApplication().setTitle("LOCK_TITLE", null);
        try {
            this.view.type.setValue("ADMSTATE.SHUTTING_DOWN");
        }
        catch (SyntaxException e) {
            // empty catch block
        }
        MOProxy mo = new MOProxy((String)this.getParameter("LDNLIST"));
        this.view.ldnField.setValue(mo.getDN());
        this.setButtonListeners();
    }

    protected void afterVisible() {
    }

    protected void beforeVisible() {
        this.view.setToolTipsOnLabels();
    }

    protected void stop() {
        this.view.okButton.removeActionListener(this);
        this.view.cancelButton.removeActionListener(this);
        this.view.stop();
    }

    private void setButtonListeners() {
        this.view.okButton.setActionListener(this, "LOCK");
        this.view.cancelButton.setActionListener(this, "CANCEL");
    }

    private void lock() {
        Integer shuttingDownInteger;
        Integer lockedInteger = new Integer(0);
        Integer value = shuttingDownInteger = new Integer(2);
        String result = this.view.type.getValue();
        if (result.equals("ADMSTATE.LOCKED")) {
            value = lockedInteger;
        }
        try {
            MOProxy.beginTransaction();
            MOProxy myMo = new MOProxy((String)this.getParameter("LDNLIST"));
            myMo.setAttribute("administrativeState", value);
            MOProxy.endTransaction(true);
        }
        catch (CSException c) {
            try {
                MOProxy.endTransaction(false);
            }
            catch (CSException s) {
                Log.logError("error rolling back");
            }
            this.reportException(c, "LOCK_ERROR", null);
        }
    }
}

