/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import org.omg.CORBA.Object;
import se.ericsson.cello.support.gui.CheckConnectionTimeout;
import se.ericsson.cello.support.gui.CheckConnectionToNode;
import se.ericsson.cello.support.gui.CheckReconnectTimeoutThread;
import se.ericsson.cello.support.gui.ConnectionStatus;
import se.ericsson.cello.support.gui.ConnectionSupervisorInterface;
import se.ericsson.cello.support.gui.ListenerConnectionLost;
import se.ericsson.cello.support.gui.TryToReconnectToNotoficationService;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.proxy.CSFacade;

public class ConnectionSupervisionController
extends Thread {
    private Object server;
    private ConnectionSupervisorInterface requestor;
    private CheckConnectionToNode checkNodeThread;
    private CheckConnectionTimeout checkTimeoutThread;
    private CheckReconnectTimeoutThread checkReconnectTimeoutThread;
    private TryToReconnectToNotoficationService tryToReconnectToNotoficationService;
    private int interval;
    private long testStart = 0L;
    protected static final boolean CONNECTION_OK = true;
    protected static final boolean CONNECTION_NOT_OK = false;
    static long threadnumber = 0L;
    static long checkthreadnumber = 0L;
    static long checktimerthreadnumber = 0L;
    private boolean alreadyWarned = false;
    private boolean keepChecking = true;
    private boolean performNewCheck = true;
    private boolean reconnectStatus = false;
    private boolean doReConnectIsRunning = false;
    private static final int TIMEOUT_PERIOD = 15;
    private static final int INTERVAL_TIMEOUT_PERIOD_INTERVAL = 5;
    private static final int MAX_TIMEOUT_VALUE = 60;
    private static final int TIMEOUT_PERIOD_RECONNECT = 15;
    private static final int INTERVAL_TIMEOUT_PERIOD_RECONNECT = 5;
    private ListenerConnectionLost connectionLostListener = null;

    public ConnectionSupervisionController(Object server, ConnectionSupervisorInterface requestor, int interval) {
        ++threadnumber;
        this.server = server;
        this.requestor = requestor;
        this.interval = interval * 1000;
    }

    public void run() {
        block3: {
            this.setName("ConnectionSupervisionController_" + threadnumber);
            Log.trace("Starting ConnectionSupervisionController ID\n " + this.getName());
            try {
                while (this.keepChecking) {
                    ConnectionSupervisionController.sleep(this.interval);
                    if (!this.performNewCheck || this.doReConnectIsRunning) continue;
                    this.performNewCheck = false;
                    this.alreadyWarned = false;
                    this.checkNodeThread = new CheckConnectionToNode(this.server, this);
                    this.checkNodeThread.setName("CheckConnectionToNode_" + checkthreadnumber++);
                    this.checkNodeThread.start();
                    this.checkTimeoutThread = new CheckConnectionTimeout(this, 15, 5);
                    this.checkTimeoutThread.setName("CheckConnectionTimeout_" + checktimerthreadnumber++);
                    this.checkTimeoutThread.start();
                }
            }
            catch (InterruptedException ie) {
                if (this.checkTimeoutThread == null) break block3;
                this.checkTimeoutThread.quit();
            }
        }
        Log.trace("ConnectionSupervisionController dead");
    }

    protected void nodeCheckCompleted(boolean status) {
        Log.trace("nodeCheckCompleted: Connection " + (status ? "OK" : "DOWN") + (this.alreadyWarned ? ", allready warned" : ""));
        if (this.checkTimeoutThread != null && this.checkTimeoutThread.isAlive()) {
            this.checkTimeoutThread.quit();
        }
        if (status) {
            this.performNewCheck = true;
        } else {
            if (this.connectionLostListener != null) {
                this.connectionLostListener.connectionLost();
            }
            this.doReConnect();
            this.alreadyWarned = true;
        }
    }

    protected void reconnectCheckCompleted(boolean status) {
        Log.trace("reconnectCheckCompleted: Connection " + (status ? "OK" : "DOWN") + (this.alreadyWarned ? ", allready warned" : ""));
        if (this.checkReconnectTimeoutThread != null) {
            this.checkReconnectTimeoutThread.quit();
        }
        this.reconnectStatus = status;
    }

    protected void timeoutWarning(int timeoutValue) {
        this.alreadyWarned = true;
        if (60 <= timeoutValue) {
            if (this.checkNodeThread != null && this.checkNodeThread.isAlive()) {
                this.checkNodeThread.interrupt();
            }
            if (this.checkTimeoutThread != null) {
                this.checkTimeoutThread.quit();
            }
            this.doReConnect();
        }
    }

    protected void timeoutWarningReconnect(int timeoutValue) {
        Log.trace("timeoutWarningReconnect");
        if (60 <= timeoutValue) {
            if (this.tryToReconnectToNotoficationService != null && this.tryToReconnectToNotoficationService.isAlive()) {
                this.tryToReconnectToNotoficationService.interrupt();
            }
            if (this.checkReconnectTimeoutThread != null) {
                this.checkReconnectTimeoutThread.quit();
            }
        }
    }

    private void doReConnect() {
        Log.logWarning("Connection lost towards the node.");
        this.doReConnectIsRunning = true;
        CSFacade csFacade = CSFacade.getInstance();
        boolean reconnectSucceded = false;
        this.testStart = System.currentTimeMillis();
        int tmp_interval = this.interval * 2;
        while (!reconnectSucceded) {
            boolean exitNow = false;
            while (!this.reconnectStatus) {
                this.requestor.connectionWarning(this.timeSinceTestStart(), ConnectionStatus.TRANSIENT_LOSS);
                try {
                    ConnectionSupervisionController.sleep(tmp_interval);
                    if (this.reconnectStatus) continue;
                    this.tryToReconnectToNotoficationService = new TryToReconnectToNotoficationService(this, csFacade);
                    this.tryToReconnectToNotoficationService.setName("tryToReconnectToNotoficationService_" + checkthreadnumber++);
                    this.tryToReconnectToNotoficationService.start();
                    if (this.checkReconnectTimeoutThread != null && this.checkReconnectTimeoutThread.isAlive()) {
                        this.checkReconnectTimeoutThread.quit();
                    }
                    this.checkReconnectTimeoutThread = new CheckReconnectTimeoutThread(this, 15, 5);
                    this.checkReconnectTimeoutThread.setName("CheckConnectionTimeoutReconnect_" + checktimerthreadnumber++);
                    this.checkReconnectTimeoutThread.start();
                }
                catch (Exception ie) {
                    if (this.checkReconnectTimeoutThread == null) continue;
                    this.checkReconnectTimeoutThread.quit();
                }
            }
            boolean showdialog = true;
            if (this.requestor.connectionRestored(showdialog)) {
                reconnectSucceded = true;
                this.performNewCheck = true;
                continue;
            }
            this.requestor.connectionWarning(this.timeSinceTestStart(), ConnectionStatus.TRANSIENT_LOSS);
        }
        Log.trace("Done in doReConnect");
    }

    public void quit() {
        Log.trace("ConnectionSupervisionController quit() ID " + this.getName());
        this.keepChecking = false;
        if (this.checkNodeThread != null) {
            if (this.checkNodeThread.isAlive()) {
                this.checkNodeThread.interrupt();
            }
            this.checkNodeThread = null;
        }
        if (this.checkTimeoutThread != null) {
            this.checkTimeoutThread.quit();
            this.checkTimeoutThread = null;
        }
        if (this.tryToReconnectToNotoficationService != null && this.tryToReconnectToNotoficationService.isAlive()) {
            this.tryToReconnectToNotoficationService.interrupt();
            this.tryToReconnectToNotoficationService = null;
        }
        if (this.checkReconnectTimeoutThread != null) {
            this.checkReconnectTimeoutThread.quit();
            this.checkReconnectTimeoutThread = null;
        }
        if (this.isAlive()) {
            this.interrupt();
        }
    }

    private int timeSinceTestStart() {
        return (int)((System.currentTimeMillis() - this.testStart) / 1000L);
    }

    public void setListenerConnectionLost(ListenerConnectionLost listener) {
        this.connectionLostListener = listener;
    }
}

