/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class EmasProperties
extends Properties {
    private static Properties extensions = null;
    String view_pre = null;
    String element_pre = null;
    static ArrayList extensionFilesArray = null;
    private final String EXT = "ext.";

    public EmasProperties() {
    }

    public EmasProperties(Properties properties) {
        super(properties);
    }

    public void setExtensions(String extensionFiles) {
        if (extensions == null) {
            extensions = new Properties();
        }
        if (extensionFiles != null && !extensionFiles.equals("")) {
            StringTokenizer st = new StringTokenizer(extensionFiles, ",");
            extensionFilesArray = new ArrayList();
            while (st.hasMoreTokens()) {
                extensionFilesArray.add(st.nextToken());
            }
        }
        if (extensionFilesArray != null && extensionFilesArray.size() > 0) {
            for (int i = 0; i < extensionFilesArray.size(); ++i) {
                String file = ((String)extensionFilesArray.get(i)).trim();
                String extFile = "/resources/" + file;
                int inx = file.indexOf("/");
                if (inx == 0 || inx == 1) {
                    extFile = "/resources/" + file.substring(inx + 1);
                }
                try {
                    InputStream stream = EmasProperties.class.getResourceAsStream(extFile);
                    extensions.load(new BufferedInputStream(stream));
                    continue;
                }
                catch (Exception e) {
                    Log.logError("Cannot load extended properties from " + extFile + " properties");
                }
            }
        }
    }

    public static String getEMProperty(Properties p, String key) {
        String value = null;
        EmasProperties emasProp = null;
        if (p instanceof Properties) {
            value = p.getProperty(key);
        } else if (p instanceof EmasProperties) {
            emasProp = (EmasProperties)p;
            value = emasProp.getProperty(key);
        }
        return value;
    }

    public static boolean isExtended(Properties p, String key) {
        boolean extended = false;
        String value = null;
        String mykey = null;
        String view_pref = null;
        String element_pref = null;
        if (view_pref == null) {
            view_pref = p.getProperty("viewprefix");
        }
        if (element_pref == null) {
            element_pref = p.getProperty("elementprefix");
        }
        if (extensions != null) {
            if (view_pref != null) {
                mykey = view_pref + key;
                value = extensions.getProperty(mykey);
            } else {
                mykey = element_pref + key;
                value = extensions.getProperty(mykey);
            }
        }
        extended = null != value;
        return extended;
    }

    public String getProperty(String key) {
        String value = null;
        String mykey = null;
        if (this.view_pre == null) {
            this.view_pre = super.getProperty("viewprefix");
        }
        if (this.element_pre == null) {
            this.element_pre = super.getProperty("elementprefix");
        }
        if (extensions != null) {
            if (this.view_pre != null) {
                mykey = this.view_pre + key;
                value = extensions.getProperty(mykey);
            } else {
                mykey = this.element_pre + key;
                value = extensions.getProperty(mykey);
            }
        }
        if (value == null) {
            if (this.view_pre != null) {
                mykey = this.view_pre + key;
                value = super.getProperty(mykey);
            } else {
                mykey = this.element_pre + key;
                value = super.getProperty(mykey);
            }
            if (value == null) {
                mykey = key;
                value = super.getProperty(mykey);
            }
        }
        return value;
    }

    public Object setProperty(String key, String value) {
        Object x = super.setProperty(key, value);
        if (key.equals("viewprefix")) {
            this.view_pre = value;
        } else if (key.equals("elementprefix")) {
            this.element_pre = value;
        }
        return x;
    }

    public boolean extendProperties(String fileName) {
        int dot = fileName.lastIndexOf(46);
        if (dot == -1) {
            Log.logError("Cannot load extended properties from " + fileName + ". File name should end with ." + "ext." + "properties.");
            return false;
        }
        int lastSlash = fileName.lastIndexOf(47);
        if (lastSlash != -1) {
            fileName = fileName.substring(lastSlash + 1);
        }
        dot = fileName.lastIndexOf(46);
        String extPropName = "/resources/" + fileName.substring(0, dot + 1) + "ext." + fileName.substring(dot + 1);
        try {
            InputStream stream = EmasProperties.class.getResourceAsStream(extPropName);
            super.load(new BufferedInputStream(stream));
        }
        catch (Exception e) {
            Log.logNotify("No extended properties to load from " + extPropName);
            return false;
        }
        return true;
    }
}

