/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import se.ericsson.cello.support.gui.EmasProperties;
import se.ericsson.cello.support.gui.PropertiesInterface;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class PropertiesHelper
extends EmasProperties {
    private String fileName;
    private static Map myPropertiesMap = new HashMap();

    private PropertiesHelper() {
    }

    public PropertiesHelper(String file) {
        this.fileName = file;
        try {
            InputStream stream = this.getClass().getResourceAsStream(this.fileName);
            this.load(new BufferedInputStream(stream));
        }
        catch (IOException io) {
            Log.logError("IO Error reading properties file " + this.fileName, io);
        }
    }

    public static Properties getProperties(String fileName) {
        EmasProperties properties = new EmasProperties();
        try {
            InputStream stream = PropertiesHelper.class.getResourceAsStream(fileName);
            properties.load(new BufferedInputStream(stream));
        }
        catch (Exception e) {
            Log.logError("Cannot load properties from " + fileName, e);
        }
        return properties;
    }

    public static Properties getProperties(String fileName, String aPackage) {
        PropertiesInterface propertiesInterface;
        Properties tmpProp;
        Object manager = myPropertiesMap.get(aPackage);
        if (manager != null && (tmpProp = (propertiesInterface = (PropertiesInterface)manager).getProperties(fileName)) != null) {
            return new EmasProperties(tmpProp);
        }
        try {
            Class<?> aClass = Class.forName(aPackage + ".ManagerPropertiesHolder");
            Constructor<?> constructor = aClass.getConstructor(new Class[0]);
            manager = constructor.newInstance(new Object[0]);
            myPropertiesMap.put(aPackage, manager);
            PropertiesInterface propertiesInterface2 = (PropertiesInterface)manager;
            Properties tmpProp2 = propertiesInterface2.getProperties(fileName);
            if (tmpProp2 != null) {
                return new EmasProperties(tmpProp2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PropertiesHelper.getProperties(fileName);
    }

    public String getAssertedProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            Log.logError("Property " + key + " not found in " + this.fileName);
        }
        return value;
    }
}

