/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import se.ericsson.cello.support.gui.SortedList;

public class SortedArrayList
extends ArrayList
implements SortedList {
    Comparator comparator = null;
    boolean isSorted = false;
    boolean lazySorting;

    public SortedArrayList() {
        this.setLazySorting(true);
    }

    public SortedArrayList(Comparator comp) {
        this.setComparator(comp);
        this.setLazySorting(true);
    }

    public final boolean isLazySorting() {
        return this.lazySorting;
    }

    public final void setLazySorting(boolean v) {
        this.lazySorting = v;
    }

    public void setComparator(Comparator newComparator) {
        this.comparator = newComparator;
        this.isSorted = false;
        this.sortIfBusySorting();
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public boolean add(Object o) {
        super.add(o);
        this.isSorted = false;
        this.sortIfBusySorting();
        return true;
    }

    public boolean addAll(Collection c) {
        boolean listChanged = super.addAll(c);
        this.isSorted = !listChanged;
        this.sortIfBusySorting();
        return listChanged;
    }

    public Object set(int index, Object element) {
        this.sortIfNeeded();
        Object previousElement = super.set(index, element);
        this.isSorted = false;
        this.sortIfBusySorting();
        return previousElement;
    }

    public boolean sort() {
        Object[] sortArray = super.toArray();
        boolean arrayChanged = false;
        if (this.comparator == null) {
            Arrays.sort(sortArray);
        } else {
            Arrays.sort(sortArray, this.comparator);
        }
        for (int i = 0; i < sortArray.length; ++i) {
            Object newObjectAtPosition = sortArray[i];
            Object oldObjectAtPosition = super.set(i, sortArray[i]);
            arrayChanged |= newObjectAtPosition != oldObjectAtPosition;
        }
        this.isSorted = true;
        return arrayChanged;
    }

    public Object get(int index) {
        this.sortIfNeeded();
        return super.get(index);
    }

    public int indexOf(Object o) {
        this.sortIfNeeded();
        return super.indexOf(o);
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException("not supported in SortedArrayList");
    }

    public ListIterator listIterator(int index) {
        throw new UnsupportedOperationException("not supported in SortedArrayList");
    }

    public int lastIndexOf(Object o) {
        this.sortIfNeeded();
        return super.lastIndexOf(o);
    }

    public Object remove(int index) {
        this.sortIfNeeded();
        return super.remove(index);
    }

    public void removeRange(int fromIndex, int toIndex) {
        this.sortIfNeeded();
        super.removeRange(fromIndex, toIndex);
    }

    public List subList(int fromIndex, int toIndex) {
        this.sortIfNeeded();
        return super.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        this.sortIfNeeded();
        return super.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.sortIfNeeded();
        return super.toArray(a);
    }

    public Object[] toArrayUnsorted() {
        return super.toArray();
    }

    public Object[] toArrayUnsorted(Object[] a) {
        return super.toArray(a);
    }

    private final void sortIfBusySorting() {
        if (!this.isLazySorting()) {
            this.sort();
        }
    }

    private final void sortIfNeeded() {
        if (!this.isSorted) {
            this.sort();
        }
    }

    public static SortedList synchronizedSortedArrayList(SortedList s) {
        return new SynchronizedSortedArrayList(s);
    }

    static class SynchronizedList
    extends SynchronizedCollection
    implements List {
        private List list;

        SynchronizedList(List list) {
            super(list);
            this.list = list;
        }

        SynchronizedList(List list, Object mutex) {
            super(list, mutex);
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.list).equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.list).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int index, Object element) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.set(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, Object element) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.add(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.lastIndexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        public ListIterator listIterator() {
            return this.list.listIterator();
        }

        public ListIterator listIterator(int index) {
            return this.list.listIterator(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList(this.list.subList(fromIndex, toIndex), this.mutex);
            }
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        Collection c;
        Object mutex;

        SynchronizedCollection(Collection c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.c = c;
            this.mutex = this;
        }

        SynchronizedCollection(Collection c, Object mutex) {
            this.c = c;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(a);
            }
        }

        public Iterator iterator() {
            return this.c.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.add(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }
    }

    static class SynchronizedSortedArrayList
    extends SynchronizedList
    implements SortedList {
        private SortedList s;

        SynchronizedSortedArrayList(SortedList s) {
            super(s);
            this.s = s;
        }

        SynchronizedSortedArrayList(SortedList s, Object mutex) {
            super(s);
            this.s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComparator(Comparator newComparator) {
            Object object = this.mutex;
            synchronized (object) {
                this.s.setComparator(newComparator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator getComparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.getComparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean sort() {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArrayUnsorted() {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.toArrayUnsorted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArrayUnsorted(Object[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.toArrayUnsorted(a);
            }
        }
    }
}

