/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import javax.swing.SwingUtilities;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class WaitCursorEventQueue
extends EventQueue {
    private int delay;
    private WaitCursorTimer waitTimer;

    public WaitCursorEventQueue(int delay) {
        this.delay = delay;
        this.waitTimer = new WaitCursorTimer();
        this.waitTimer.setDaemon(true);
        this.waitTimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(AWTEvent event) {
        Object source = event.getSource();
        this.waitTimer.startTimer(source);
        try {
            super.dispatchEvent(event);
        }
        catch (IllegalThreadStateException thread) {
            Log.log(5, thread.getMessage(), (Throwable)thread);
        }
        catch (Exception e) {
            Log.logError("An exception occurred while dispatching the wait cursor event");
            Log.log(5, e.getMessage(), (Throwable)e);
        }
        finally {
            this.waitTimer.stopTimer();
        }
    }

    private class WaitCursorTimer
    extends Thread {
        private Object source;
        private Component parent;
        private Cursor savedCursor;
        private boolean timerStarted = false;

        private WaitCursorTimer() {
        }

        synchronized void startTimer(Object source) {
            if (!this.timerStarted) {
                this.source = source;
                this.notify();
            }
        }

        synchronized void stopTimer() {
            if (this.parent == null) {
                this.interrupt();
            } else {
                this.parent.setCursor(this.savedCursor);
                this.parent = null;
            }
        }

        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        MenuContainer mParent;
                        this.timerStarted = false;
                        this.wait();
                        this.timerStarted = true;
                        this.wait(WaitCursorEventQueue.this.delay);
                        if (this.source instanceof Component) {
                            this.parent = SwingUtilities.getRoot((Component)this.source);
                        } else if (this.source instanceof MenuComponent && (mParent = ((MenuComponent)this.source).getParent()) instanceof Component) {
                            this.parent = SwingUtilities.getRoot((Component)mParent);
                        }
                        if (this.parent == null) continue;
                        this.savedCursor = this.parent.getCursor();
                        if (!this.parent.isShowing()) continue;
                        this.parent.setCursor(Cursor.getPredefinedCursor(3));
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

