/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.LocaleChangeListener;

public class GenButton
extends JButton
implements LocaleChangeListener {
    private String myTag = null;
    private String myBundle = null;
    Locale myLocale = null;
    private ResourceBundle myResourceBundle = null;
    String toolTipBundle = null;
    String toolTipTag = null;
    String toolTipAddition = "";
    private static int MNEMONIC_INDICATOR = 38;

    public GenButton(String translations, String tag) {
        Log.traceFlow();
        this.myTag = tag;
        this.myBundle = translations;
        this.putClientProperty("LANGUAGE_CONTROLLED", "NT");
    }

    public GenButton(String tag) {
        super(tag);
        Log.traceFlow();
    }

    public void updateLocale(Locale locale) {
        Log.traceFlow();
        String text = "";
        try {
            ResourceBundle rb = GuilibResourceBundle.getBundle(this.myBundle, locale, this.getClass().getClassLoader());
            text = rb.getString(this.myTag);
        }
        catch (MissingResourceException mre) {
            this.setText(this.myTag);
        }
        Character charac = this.getMnemonic(text);
        if (null != charac) {
            text = this.stripString(text);
            this.setText(text);
            this.setMnemonic(charac.charValue());
        } else {
            this.setText(text);
        }
        this.translateTooltip(locale);
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        if (aListener != null) {
            this.addActionListener(aListener);
        }
        this.setActionCommand(aCommand);
    }

    public void setToolTip(String bundle, String tag) {
        Log.trace("setToolTip(" + tag + ")");
        this.toolTipBundle = bundle;
        this.toolTipTag = tag;
        if (this.myLocale != null) {
            this.translateTooltip(this.myLocale);
        }
    }

    public void setToolTip(String tag) {
        Log.trace("setToolTip(" + tag + ")");
        this.setToolTipText(tag);
    }

    public void setToolTip(String bundle, String tag, String additionalText) {
        this.toolTipAddition = additionalText;
        if (null == tag) {
            this.setToolTipText(this.toolTipAddition);
        } else {
            this.setToolTip(bundle, tag);
        }
    }

    void translateTooltip(Locale locale) {
        if (this.toolTipBundle != null) {
            ResourceBundle ttBundle = GuilibResourceBundle.getBundle(this.toolTipBundle, locale, this.getClass().getClassLoader());
            try {
                this.setToolTipText(ttBundle.getString(this.toolTipTag) + this.toolTipAddition);
            }
            catch (MissingResourceException mre) {
                this.setToolTipText(this.toolTipTag + this.toolTipAddition);
            }
        }
    }

    protected void invokeAction() {
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
    }

    private Character getMnemonic(String str) {
        Character amp = null;
        int ampIndex = str.indexOf(MNEMONIC_INDICATOR);
        if (ampIndex != -1 && str.length() > ampIndex + 1) {
            amp = new Character(str.charAt(ampIndex + 1));
        }
        return amp;
    }

    private String stripString(String str) {
        String tmpStr = "";
        int ampIndex = str.indexOf(MNEMONIC_INDICATOR);
        if (-1 == ampIndex) {
            return str;
        }
        if (ampIndex > 0) {
            tmpStr = str.substring(0, ampIndex);
        }
        if (str.length() > ampIndex + 1) {
            tmpStr = tmpStr + str.substring(ampIndex + 1);
        }
        return tmpStr;
    }
}

