/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JComboBox;
import se.ericsson.cello.support.gui.gengui.LabelledField;
import se.ericsson.cello.support.gui.gengui.SyntaxException;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class GenComboBox
extends LabelledField
implements ItemListener {
    private JComboBox boxes = null;
    private int width = 0;
    private ActionListener al = null;
    private String aCommand = null;
    private String[] unsorted = null;
    private String[] sorted = null;
    private boolean sortingOn = true;

    public GenComboBox(String translations, String tag, String[] bTags, boolean sorting) {
        super(translations, tag);
        Log.traceFlow();
        this.sortingOn = sorting;
        this.unsorted = bTags;
        this.copyAndSort(bTags);
        this.boxes = new JComboBox();
        for (int i = 0; i < this.sorted.length; ++i) {
            this.boxes.addItem(this.sorted[i]);
        }
        this.boxes.addItemListener(this);
        if (this.boxes.getItemCount() > 0) {
            this.boxes.setSelectedIndex(0);
        }
        this.add(this.boxes);
    }

    public GenComboBox(String translations, String tag, String[] bTags) {
        this(translations, tag, bTags, true);
    }

    public GenComboBox(String tag, String[] bTags, boolean sorting) {
        super(tag);
        Log.trace("Constructor()");
        this.sortingOn = sorting;
        this.unsorted = bTags;
        this.copyAndSort(bTags);
        this.boxes = new JComboBox();
        for (int i = 0; i < this.sorted.length; ++i) {
            this.boxes.addItem(this.sorted[i]);
        }
        if (this.boxes.getItemCount() > 0) {
            this.boxes.setSelectedIndex(0);
        }
        this.boxes.addItemListener(this);
        this.add(this.boxes);
    }

    public GenComboBox(String tag, String[] bTags) {
        this(tag, bTags, true);
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        this.al = aListener;
        this.aCommand = aCommand;
    }

    public void setWidth(int width) {
        Dimension myDim = this.boxes.getPreferredSize();
        myDim.width = width;
        this.width = width;
        this.boxes.setPreferredSize(myDim);
    }

    public void removeAllItems() {
        if (this.boxes.getItemCount() > 0) {
            this.boxes.removeAllItems();
            this.unsorted = null;
            this.sorted = null;
        }
    }

    public void addItems(String[] items) {
        this.boxes.removeItemListener(this);
        if (this.unsorted == null) {
            this.unsorted = items;
        } else {
            int i;
            this.boxes.removeAllItems();
            int newLength = items.length + this.unsorted.length;
            String[] dummy = this.unsorted;
            this.unsorted = new String[newLength];
            for (i = 0; i < dummy.length; ++i) {
                this.unsorted[i] = dummy[i];
            }
            for (i = dummy.length; i < newLength; ++i) {
                this.unsorted[i] = items[i - dummy.length];
            }
        }
        this.copyAndSort(this.unsorted);
        for (int i = 0; i < this.sorted.length; ++i) {
            this.boxes.addItem(this.sorted[i]);
        }
        if (this.boxes.getSelectedIndex() == -1 && this.boxes.getItemCount() > 0) {
            this.boxes.setSelectedIndex(0);
        }
        if (this.width != 0) {
            this.setWidth(this.width);
        }
        this.boxes.addItemListener(this);
    }

    public void setValue(String boxTag) throws SyntaxException {
        Log.trace("setValue()");
        boolean buttonNotDefined = false;
        this.boxes.removeItemListener(this);
        this.boxes.setSelectedItem(boxTag);
        this.boxes.addItemListener(this);
        if (buttonNotDefined) {
            throw new SyntaxException();
        }
    }

    public String getValue() {
        Log.trace("getValue()");
        return (String)this.boxes.getSelectedItem();
    }

    public int getSelectedIndex() {
        String myValue = this.getValue();
        for (int i = 0; i < this.unsorted.length; ++i) {
            if (!this.unsorted[i].equals(myValue)) continue;
            return i;
        }
        return -1;
    }

    public Object getFieldComponent() {
        Log.trace("getFieldComponent()");
        return this.boxes;
    }

    public void updateLocale(Locale locale) {
        super.updateLocale(locale);
        this.translateTooltip(locale);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && this.al != null) {
            this.al.actionPerformed(new ActionEvent(this, 0, this.aCommand));
        }
    }

    private void copyAndSort(String[] items) {
        this.sorted = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            this.sorted[i] = items[i];
        }
        if (this.sortingOn) {
            Arrays.sort(this.sorted, String.CASE_INSENSITIVE_ORDER);
        }
    }
}

