/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Component;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import se.ericsson.cello.support.gui.gengui.ComponentBoxLayout;
import se.ericsson.cello.support.gui.gengui.TabNotDefinedException;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.LocaleChangeListener;

public class GenTabbedPane
extends JTabbedPane
implements LocaleChangeListener {
    private String[] myTags = null;
    private String myBundle = null;

    public GenTabbedPane(String translations, String[] tags) {
        this(tags);
        this.myBundle = translations;
        this.putClientProperty("LANGUAGE_CONTROLLED", "NT");
    }

    public GenTabbedPane(String[] tags) {
        for (int i = 0; i < tags.length; ++i) {
            JPanel dummy = new JPanel();
            dummy.setLayout(new ComponentBoxLayout(dummy));
            this.addTab(tags[i], dummy);
        }
        this.myTags = tags;
    }

    public void addComponent(String nameTab, Component newComponent) throws TabNotDefinedException {
        boolean tabNotDefined = true;
        for (int i = 0; i < this.myTags.length; ++i) {
            if (!this.myTags[i].equals(nameTab)) continue;
            tabNotDefined = false;
            JPanel dummy = (JPanel)this.getComponentAt(i);
            dummy.add(newComponent);
        }
        if (tabNotDefined) {
            Log.logError("error tab not defined");
            throw new TabNotDefinedException();
        }
    }

    public JPanel getTab(String nameTab) throws TabNotDefinedException {
        boolean tabNotDefined = true;
        JPanel dummy = null;
        for (int i = 0; i < this.myTags.length; ++i) {
            if (!this.myTags[i].equals(nameTab)) continue;
            tabNotDefined = false;
            dummy = (JPanel)this.getComponentAt(i);
        }
        if (tabNotDefined) {
            Log.logError("error tab not defined");
            throw new TabNotDefinedException();
        }
        return dummy;
    }

    public JPanel addTab(String tag) {
        JPanel dummy = new JPanel();
        dummy.setLayout(new ComponentBoxLayout(dummy));
        this.addTab(tag, dummy);
        String[] temp = new String[this.myTags.length + 1];
        System.arraycopy(this.myTags, 0, temp, 0, this.myTags.length);
        temp[this.myTags.length] = tag;
        this.myTags = temp;
        return dummy;
    }

    public void removeTab(String tag) {
        int found = 0;
        String[] temp = new String[this.myTags.length - 1];
        for (int i = 0; i < this.myTags.length; ++i) {
            if (this.myTags[i].equals(tag) && found == 0) {
                this.removeTabAt(i);
                found = 1;
                continue;
            }
            try {
                temp[i - found] = this.myTags[i];
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.logWarning("Tab to remove is not defined: " + tag);
            }
        }
        if (found == 1) {
            this.myTags = temp;
        }
    }

    public void updateLocale(Locale locale) {
        ResourceBundle rb = GuilibResourceBundle.getBundle(this.myBundle, locale, this.getClass().getClassLoader());
        for (int i = 0; i < this.myTags.length; ++i) {
            try {
                this.setTitleAt(i, rb.getString(this.myTags[i]));
                continue;
            }
            catch (MissingResourceException mre) {
                this.setTitleAt(i, this.myTags[i]);
            }
        }
    }
}

