/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Locale;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.ericsson.cello.support.gui.gengui.ComponentLayout;
import se.ericsson.cello.support.gui.gengui.LabelledField;

public class GenTextAreaField
extends LabelledField
implements ComponentListener,
FocusListener,
KeyListener {
    private JTextArea myTextAreaField = null;
    private ActionListener actionListener = null;
    private String actionCommand = null;
    private JScrollPane myPane = null;
    private String text = "";
    private String value = "";

    public GenTextAreaField(String translations, String labelTag) {
        super(translations, labelTag);
        this.createTextArea();
    }

    public GenTextAreaField(String labelTag) {
        super(labelTag);
        this.createTextArea();
    }

    private void createTextArea() {
        this.myTextAreaField = new JTextArea();
        this.myTextAreaField.setLineWrap(true);
        this.myTextAreaField.setWrapStyleWord(true);
        this.myTextAreaField.addFocusListener(this);
        this.myTextAreaField.addKeyListener(this);
        this.addComponentListener(this);
        this.myPane = new JScrollPane(this.myTextAreaField, 20, 30);
        this.add(this.myPane);
        this.setUnderneath(true);
        ((ComponentLayout)this.getLayout()).setSizeAble(true);
    }

    public boolean isFilledIn() {
        return !this.myTextAreaField.getText().equals("");
    }

    public Object getFieldComponent() {
        return this.myTextAreaField;
    }

    public void setValue(String newValue) {
        this.myTextAreaField.setText(newValue);
        this.value = newValue;
    }

    public String getValue() {
        return this.value;
    }

    public void updateLocale(Locale locale) {
        super.updateLocale(locale);
        this.translateTooltip(locale);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void componentResized(ComponentEvent e) {
        this.remove(this.myPane);
        this.myPane = new JScrollPane(this.myTextAreaField, 20, 30);
        this.myPane.setPreferredSize(new Dimension(this.getSize().width - 8, this.getSize().height - this.getLabel().getSize().height - 8));
        this.add(this.myPane);
        this.updateUI();
    }

    public void focusGained(FocusEvent e) {
        this.text = this.myTextAreaField.getText();
    }

    public void focusLost(FocusEvent e) {
        if (!e.isTemporary() && !this.myTextAreaField.getText().equals(this.value)) {
            this.value = this.myTextAreaField.getText();
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 0, this.actionCommand));
            }
        }
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        this.actionListener = aListener;
        this.actionCommand = aCommand;
    }

    public void keyReleased(KeyEvent e) {
        if (this.actionListener != null && !this.myTextAreaField.getText().equals(this.text)) {
            this.text = this.myTextAreaField.getText();
            this.actionListener.actionPerformed(new ActionEvent(this, 0, "ENTRYFIELD_FILLEDIN"));
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }
}

