/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui.ui.date;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import se.ericsson.cello.support.gui.gengui.ui.date.Parser;

public class DateParser
extends Parser {
    private DateFormatSymbols formatSymbols;
    private Date date;
    private String[] patternList;
    private String[] yearList;
    private String[] monthList;
    private String[] dayList;
    private String[][] resourceList;
    private String[][] firstFieldList;
    private String[][] secondFieldList;
    private String[][] thirdFieldList;
    private static final boolean debug = false;

    public DateParser() {
        this(Locale.getDefault(), 3);
    }

    public DateParser(Locale loc) {
        this(loc, 3);
    }

    public DateParser(Locale loc, int dateStyle) {
        super(loc, dateStyle);
        this.dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(dateStyle, loc);
        this.setDefaultPatternString(this.dateFormat.toPattern());
        this.formatSymbols = new DateFormatSymbols(loc);
        this.yearList = new String[2];
        this.yearList[0] = "yy";
        this.yearList[1] = "yyyy";
        this.monthList = new String[4];
        this.monthList[3] = "M";
        this.monthList[0] = "MM";
        this.monthList[1] = "MMM";
        this.monthList[2] = "MMMM";
        this.dayList = new String[2];
        this.dayList[0] = "dd";
        this.dayList[1] = "d";
        this.resourceList = new String[3][4];
        this.setPatternOrder(this.getPattern());
        this.firstFieldList = this.resourceList;
        this.secondFieldList = this.resourceList;
        this.thirdFieldList = this.resourceList;
        this.patternList = new String[this.yearList.length * this.monthList.length * this.dayList.length * this.resourceList.length * (this.resourceList.length - 1)];
        int count = 0;
        for (int m = 0; m < this.firstFieldList.length; ++m) {
            for (int n = 0; n < this.secondFieldList.length; ++n) {
                for (int o = 0; o < this.thirdFieldList.length; ++o) {
                    for (int i = 0; i < this.firstFieldList[m].length; ++i) {
                        for (int j = 0; j < this.secondFieldList[n].length; ++j) {
                            for (int k = 0; k < this.thirdFieldList[o].length; ++k) {
                                if (m == n || n == o || m == o) continue;
                                this.patternList[count] = this.firstFieldList[m][i] + "-" + this.secondFieldList[n][j] + "-" + this.thirdFieldList[o][k];
                                ++count;
                            }
                        }
                    }
                }
            }
        }
    }

    public Date parseDate(String parseString) {
        this.date = null;
        if (!this.isDefinedPattern()) {
            if (this.containsCharAmount(parseString = this.strip(parseString), '-') != 2) {
                return null;
            }
            parseString = parseString.toUpperCase();
            int i = 0;
            this.dateFormat.applyPattern(this.patternList[i]);
            while (this.date == null && i < this.patternList.length) {
                try {
                    if (Character.isDigit(parseString.charAt(0)) && this.patternList[i].startsWith("MMM")) {
                        throw new ParseException("No month by words in beginning of parseString", 0);
                    }
                    this.date = this.dateFormat.parse(parseString);
                }
                catch (ParseException e) {
                    this.date = null;
                    this.dateFormat.applyPattern(this.patternList[i]);
                    ++i;
                }
            }
            return this.date;
        }
        try {
            this.date = this.dateFormat.parse(parseString);
        }
        catch (ParseException e) {
            return null;
        }
        return this.date;
    }

    public boolean isYearField(String parseString, int caretPosition) {
        return this.checkField(0, parseString, caretPosition);
    }

    public boolean isMonthField(String parseString, int caretPosition) {
        return this.checkField(1, parseString, caretPosition);
    }

    public boolean isDayField(String parseString, int caretPosition) {
        return this.checkField(2, parseString, caretPosition);
    }

    public int isMonth(String text) {
        String[] shortMonths = this.formatSymbols.getShortMonths();
        String[] longMonths = this.formatSymbols.getMonths();
        for (int i = 0; i < shortMonths.length - 1; ++i) {
            if (text.length() < shortMonths[i].length() || !text.toLowerCase().startsWith(shortMonths[i].toLowerCase()) && !text.toLowerCase().equals(longMonths[i].toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    public int[] getFieldPositions(int datePart, String parseString) {
        int[] fieldPositions = new int[]{-1, -1};
        if (parseString == null || parseString.equals("")) {
            return fieldPositions;
        }
        if (this.containsCharAmount(parseString = this.strip(parseString), '-') != 2) {
            return fieldPositions;
        }
        switch (this.getFieldNumber(datePart)) {
            case 0: {
                fieldPositions[0] = 0;
                fieldPositions[1] = parseString.indexOf(45);
                break;
            }
            case 1: {
                fieldPositions[0] = parseString.indexOf(45) + 1;
                fieldPositions[1] = parseString.lastIndexOf(45);
                break;
            }
            case 2: {
                fieldPositions[0] = parseString.lastIndexOf(45) + 1;
                fieldPositions[1] = parseString.length();
                break;
            }
            default: {
                return fieldPositions;
            }
        }
        return fieldPositions;
    }

    private void setPatternOrder(String patternString) {
        patternString = this.stripDatePattern(patternString);
        int indexY = patternString.indexOf(121);
        int indexM = patternString.indexOf(77);
        int indexD = patternString.indexOf(100);
        if (indexY < indexM) {
            if (indexY < indexD) {
                if (indexM < indexD) {
                    this.resourceList[0] = this.yearList;
                    this.resourceList[1] = this.monthList;
                    this.resourceList[2] = this.dayList;
                } else {
                    this.resourceList[0] = this.yearList;
                    this.resourceList[2] = this.monthList;
                    this.resourceList[1] = this.dayList;
                }
            } else {
                this.resourceList[1] = this.yearList;
                this.resourceList[2] = this.monthList;
                this.resourceList[0] = this.dayList;
            }
        } else if (indexM < indexD) {
            if (indexY < indexD) {
                this.resourceList[1] = this.yearList;
                this.resourceList[0] = this.monthList;
                this.resourceList[2] = this.dayList;
            } else {
                this.resourceList[2] = this.yearList;
                this.resourceList[0] = this.monthList;
                this.resourceList[1] = this.dayList;
            }
        } else {
            this.resourceList[2] = this.yearList;
            this.resourceList[1] = this.monthList;
            this.resourceList[0] = this.dayList;
        }
    }

    private String strip(String s) {
        String strippedString = "";
        String tempString = "";
        if (s == null) {
            return strippedString;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) {
                strippedString = strippedString + s.charAt(i);
                continue;
            }
            if (Character.isLetter(s.charAt(i))) {
                int j;
                for (j = i; j < s.length() && Character.isLetter(s.charAt(j)); ++j) {
                    tempString = tempString + s.charAt(j);
                }
                i = j - 1;
                if (this.isMonth(tempString) > -1) {
                    strippedString = strippedString + this.formatSymbols.getShortMonths()[this.isMonth(tempString)];
                }
                tempString = "";
                continue;
            }
            if (strippedString.length() <= 0 || strippedString.charAt(strippedString.length() - 1) == '-') continue;
            strippedString = this.containsCharAmount(strippedString, '-') < 2 ? strippedString + "-" : strippedString + " ";
        }
        return strippedString;
    }

    private boolean checkField(int datePart, String parseString, int startPos) {
        this.debug("checkField : parseString = " + parseString);
        this.debug("checkField : startPos = " + startPos);
        if (startPos < 0 || startPos > parseString.length()) {
            return false;
        }
        String temp = this.strip(parseString.substring(0, startPos));
        int fieldNumber = this.containsCharAmount(temp, '-');
        parseString = this.strip(parseString);
        this.debug("checkField : parseString = " + parseString);
        this.debug("checkField : fieldNumber = " + fieldNumber);
        if (this.containsCharAmount(parseString, '-') != 2 || fieldNumber < 0) {
            return false;
        }
        this.debug("checkField : datePart = " + datePart);
        this.debug("checkField : getFieldNumber() = " + this.getFieldNumber(datePart));
        return this.getFieldNumber(datePart) == fieldNumber;
    }

    private int getFieldNumber(int datePart) {
        int fieldPosition = 0;
        String pattern = this.dateFormat.toPattern();
        pattern = this.stripDatePattern(pattern);
        int indexY = pattern.indexOf(121);
        int indexM = pattern.indexOf(77);
        int indexD = pattern.indexOf(100);
        switch (datePart) {
            case 0: {
                fieldPosition = indexY < indexM ? (indexY < indexD ? 0 : 1) : (indexY < indexD ? 1 : 2);
                break;
            }
            case 1: {
                fieldPosition = indexM < indexY ? (indexM < indexD ? 0 : 1) : (indexM < indexD ? 1 : 2);
                break;
            }
            case 2: {
                fieldPosition = indexD < indexM ? (indexD < indexY ? 0 : 1) : (indexD < indexY ? 1 : 2);
            }
        }
        return fieldPosition;
    }

    private void debug(String string) {
    }
}

