/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.comp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicArrowButton;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class Spinner
extends JPanel {
    private JTextField spinnerTextField;
    private BasicArrowButton incrementButton;
    private BasicArrowButton decrementButton;
    private int extent = 1;
    private int min = 0;
    private int max = 100;
    private int value = 0;
    private int updateCount;
    private Listener listener;
    private ExtentModifier extentModifier;
    private ChangeEvent changeEvent = null;
    private EventListenerList listenerList = new EventListenerList();

    public Spinner() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.listener = new Listener();
        this.spinnerTextField = new JTextField();
        this.spinnerTextField.setText(Integer.toString(this.min));
        this.spinnerTextField.addKeyListener(this.listener);
        this.spinnerTextField.getDocument().addDocumentListener(this.listener);
        this.add((Component)this.spinnerTextField, new GridBagConstraints(0, 0, 1, 2, 1000.0, 1000.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.incrementButton = new ArrowButton(1);
        this.incrementButton.addMouseListener(this.listener);
        this.decrementButton = new ArrowButton(5);
        this.decrementButton.addMouseListener(this.listener);
        this.add((Component)this.incrementButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.decrementButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.updateValue(value);
    }

    public int getExtent() {
        return this.extent;
    }

    public void setExtent(int extent) {
        this.extent = extent;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        if (max > this.min) {
            this.max = max;
            if (this.value > max) {
                this.updateValue(max);
            }
        }
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        if (min < this.max) {
            this.min = min;
            if (this.value < min) {
                this.updateValue(min);
            }
        }
    }

    public boolean isEditable() {
        return this.spinnerTextField.isEditable();
    }

    public void setEditable(boolean b) {
        this.spinnerTextField.setEditable(b);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    private synchronized void startExtentModifier(boolean increment) {
        Log.assertion(this.extentModifier == null, "ExtentModifier exists");
        this.extentModifier = new ExtentModifier(increment);
    }

    private synchronized void stopExtentModifier() {
        Log.assertion(this.extentModifier != null, "ExtentModifier does not exist");
        this.extentModifier.interrupt();
        this.extentModifier = null;
    }

    private void increment() {
        this.updateValue(this.value + this.extent);
    }

    private void decrement() {
        this.updateValue(this.value - this.extent);
    }

    private synchronized void modifyUpdateCount(int value) {
        this.updateCount += value;
    }

    private synchronized void updateValue(String value) {
        int newValue = this.value;
        if (this.spinnerTextField.isEditable()) {
            try {
                newValue = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        SwingUtilities.invokeLater(new UpdateLater(newValue));
    }

    private synchronized void updateValue(int newValue) {
        int oldValue = this.value;
        if (newValue >= this.min && newValue <= this.max) {
            this.value = newValue;
        }
        this.synchronizeTextField();
        if (oldValue != this.value) {
            this.fireStateChanged();
        }
    }

    private void synchronizeTextField() {
        boolean needUpdate = true;
        try {
            String text = this.spinnerTextField.getText();
            int currentValue = Integer.parseInt(text);
            needUpdate = this.value != currentValue || text.startsWith("0") && text.length() > 1;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (needUpdate) {
            this.spinnerTextField.setText(new Integer(this.value).toString());
        }
    }

    private class UpdateLater
    implements Runnable {
        private int value;

        UpdateLater(int value) {
            this.value = value;
            Spinner.this.modifyUpdateCount(1);
        }

        public void run() {
            if (Spinner.this.updateCount <= 1) {
                Spinner.this.updateValue(this.value);
            }
            Spinner.this.modifyUpdateCount(-1);
        }
    }

    private class ExtentModifier
    implements Runnable {
        private boolean increment;
        private Thread modifyThread;

        ExtentModifier(boolean increment) {
            Spinner.this.setRequestFocusEnabled(false);
            this.increment = increment;
            this.start();
        }

        public boolean isFocusTraversable() {
            return false;
        }

        private void start() {
            this.modifyThread = new Thread(this);
            this.modifyThread.start();
        }

        void interrupt() {
            this.modifyThread.interrupt();
        }

        public void run() {
            try {
                int sleep = 500;
                while (true) {
                    if (this.increment) {
                        Spinner.this.increment();
                    } else {
                        Spinner.this.decrement();
                    }
                    Thread.sleep(sleep);
                    sleep = 30;
                }
            }
            catch (InterruptedException ie) {
            }
            catch (Throwable t) {
                Log.logError("Exception occurred.", t);
            }
        }
    }

    private class ArrowButton
    extends BasicArrowButton {
        public ArrowButton(int direction) {
            super(direction);
        }

        public Dimension getPreferredSize() {
            Dimension d = Spinner.this.spinnerTextField.getPreferredSize();
            return new Dimension(d.height, d.height / 2);
        }
    }

    private class Listener
    implements KeyListener,
    MouseListener,
    DocumentListener {
        private Listener() {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 38) {
                Spinner.this.increment();
            } else if (e.getKeyCode() == 40) {
                Spinner.this.decrement();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getSource() == Spinner.this.incrementButton) {
                Spinner.this.startExtentModifier(true);
            } else if (e.getSource() == Spinner.this.decrementButton) {
                Spinner.this.startExtentModifier(false);
            }
        }

        public void mouseReleased(MouseEvent e) {
            Spinner.this.stopExtentModifier();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            Spinner.this.updateValue(Spinner.this.spinnerTextField.getText());
        }

        public void removeUpdate(DocumentEvent e) {
            Spinner.this.updateValue(Spinner.this.spinnerTextField.getText());
        }

        public void changedUpdate(DocumentEvent e) {
            Spinner.this.updateValue(Spinner.this.spinnerTextField.getText());
        }
    }
}

