/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import javax.swing.JApplet;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.cello.support.gui.guilib.infra.AppletViewContainer;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationMenuBar;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationToolBar;
import se.ericsson.cello.support.gui.guilib.infra.MenuToolbarHandler;
import se.ericsson.cello.support.gui.guilib.infra.SDIViewContainer;
import se.ericsson.cello.support.gui.guilib.infra.ViewContainer;

class ApplicationPresenter
extends AbstractPresenter {
    private MenuToolbarHandler menuToolBarHandler = null;

    ApplicationPresenter() {
    }

    ViewContainer createViewContainer() {
        AbstractApplication application = this.getApplication();
        JApplet applet = application.getApplet();
        ViewContainer viewContainer = null;
        boolean showApplicationInApplet = "TRUE".equalsIgnoreCase(application.getEnvironment().getProperty("gsl.showapplicationinapplet"));
        if (this.getApplication().getApplicationManager().isInitialApplication(application) && applet != null && showApplicationInApplet) {
            viewContainer = new AppletViewContainer(applet);
        } else {
            boolean supportPresentation = "TRUE".equalsIgnoreCase(application.getEnvironment().getProperty("gsl.supportpresentation"));
            if (supportPresentation) {
                Class viewContainerClass = this.getClassForName("se.ericsson.cello.support.gui.guilib.infra.ApplicationViewContainerDelegator");
                try {
                    viewContainer = (ViewContainer)viewContainerClass.newInstance();
                }
                catch (Throwable t) {
                    String msg = "Could not create view container";
                    Log.logError(msg, t);
                    Log.assertion(false, msg);
                }
            } else {
                viewContainer = new SDIViewContainer();
            }
        }
        viewContainer.init(this);
        return viewContainer;
    }

    void init() {
        this.getApplication().setApplicationPresenter(this);
        this.getView().init();
        if (super.isDisposed()) {
            return;
        }
        this.getController().init();
        if (super.isDisposed()) {
            return;
        }
        this.menuToolBarHandler = new MenuToolbarHandler();
        this.menuToolBarHandler.init(this);
        this.getViewContainer().setMenuBar(this.getApplicationMenuBar());
        this.getViewContainer().setToolBar(this.getApplicationToolBar());
        this.getViewContainer().setView(this.getView());
    }

    void dispose() {
        if (this.menuToolBarHandler != null) {
            this.menuToolBarHandler.dispose();
            this.menuToolBarHandler = null;
        }
        super.dispose();
        super.setIsDisposed(true);
    }

    void replaceViewContainer() {
        ViewContainer viewContainer = this.createViewContainer();
        viewContainer.setView(this.getView());
        viewContainer.setMenuBar(this.getApplicationMenuBar());
        viewContainer.setToolBar(this.getApplicationToolBar());
        viewContainer.setTitle(this.getTitle());
        viewContainer.setStatus(this.getStatus());
        this.setViewContainer(viewContainer);
    }

    void changeMenuBar() {
        Log.logNotify("changeMenu");
        this.menuToolBarHandler.changeMenuBar();
        this.getViewContainer().setMenuBar(this.getApplicationMenuBar());
        this.getViewContainer().doValidate();
    }

    void changeToolBar() {
        this.menuToolBarHandler.changeToolBar();
        this.getViewContainer().setToolBar(this.getApplicationToolBar());
        this.getViewContainer().doValidate();
    }

    protected void updateLookAndFeel() {
        this.menuToolBarHandler.updateLookAndFeel();
        super.updateLookAndFeel();
    }

    MenuToolbarHandler getMenuToolBarHandler() {
        return this.menuToolBarHandler;
    }

    ApplicationMenuBar getApplicationMenuBar() {
        return this.menuToolBarHandler.getApplicationMenuBar();
    }

    ApplicationToolBar getApplicationToolBar() {
        return this.menuToolBarHandler.getApplicationToolBar();
    }
}

