/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractHelp;
import se.ericsson.cello.support.gui.guilib.infra.AbstractView;
import se.ericsson.cello.support.gui.guilib.infra.BrowserHelpMessageDialogController;
import se.ericsson.cello.support.gui.guilib.infra.BrowserHelpMessageDialogView;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.ResourceBundleDelegator;
import se.ericsson.cello.support.gui.guilib.infra.TimedSocket;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;

public class BrowserHelp
extends AbstractHelp {
    private static String DOCUMENT_ROOT_KEY = "gsl.help.docserver.documentroot";
    private static String HELP_DOCUMENT_BUNDLE_KEY = "gsl.help.documentmapping";
    private static String DEFAULT_HELP_MAPPING = "gsl.help.default.mapping";
    private static String HELP_TRACKING_ICON = "gsl.icon.helptracking";
    private static String ALEX_SEARCH_EXPRESSION = "ALEX_SEARCH_EXPRESSION";
    private static String EMT_HELPSERVICE = "EMT_HELPSERVICE";
    private ResourceBundleDelegator helpBundle;
    private Vector components = new Vector();
    private KeyPressedListener keyListener = new KeyPressedListener();
    private ButtonAction buttonListener = new ButtonAction();
    private TrackingListener trackingListener = new TrackingListener();
    private ResourceBundle documentMapping;
    private String preferredBrowser = null;
    private String helpServiceConfigFile = "";

    public BrowserHelp() {
        Log.traceFlow();
    }

    public void handleComponent(JComponent comp) {
        Log.trace("BrowserHelp.handleComponent(" + comp.getClass().getName() + ")");
        if (comp instanceof AbstractButton && comp.getClientProperty("HELP_ENABLE") != null) {
            ((AbstractButton)comp).addActionListener(this.buttonListener);
            Log.trace("ButtonListener added to help-enabling button");
            this.addF1Lister(comp);
        }
        if (comp.getClientProperty("HELP_TRACKING") != null) {
            Log.trace("TrackingListener added to help-tracker component");
            ((AbstractButton)comp).addActionListener(this.trackingListener);
        }
        comp.addKeyListener(this.keyListener);
        this.components.addElement(comp);
    }

    public void dispose() {
        for (int i = 0; i < this.components.size(); ++i) {
            JComponent comp = (JComponent)this.components.elementAt(i);
            comp.removeKeyListener(this.keyListener);
            if (comp.getClientProperty("HELP_ENABLE") == null) continue;
            ((AbstractButton)comp).removeActionListener(this.buttonListener);
            comp.unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0, false));
        }
        this.components.clear();
    }

    private String getEndOfString(String aString) {
        int index = aString.lastIndexOf(".");
        if (index != -1) {
            return aString.substring(index + 1);
        }
        return aString;
    }

    public void updateHelp(Locale locale) {
        ResourceBundle extendedBundles;
        String extendedHelpBundleName;
        ResourceBundle aHelpBundle;
        Log.traceFlow();
        Log.log(4, "locale = " + locale);
        this.helpBundle = new ResourceBundleDelegator();
        String defaultHelpBundleName = this.getApplication().getEnvironment().getProperty("gsl.help.default.bundle.name");
        Log.log(4, "Default help-bundle name : " + defaultHelpBundleName);
        this.helpBundle.add(GuilibResourceBundle.getBundle(defaultHelpBundleName, locale, this.getClass().getClassLoader()));
        String defaultHelpMappingBundleName = this.getApplication().getEnvironment().getProperty(DEFAULT_HELP_MAPPING, "se.ericsson.cello.support.gui.guilib.infra.resources.help.BrowserHelpMapping");
        Log.log(4, "Default helpmapping-bundle name : " + defaultHelpMappingBundleName);
        this.helpBundle.add(GuilibResourceBundle.getBundle(defaultHelpMappingBundleName, locale, this.getClass().getClassLoader()));
        try {
            String extendedHelpMappingBundleName = "resources.help." + this.getEndOfString(defaultHelpMappingBundleName) + "_ext";
            ResourceBundle extendedBundles2 = GuilibResourceBundle.getBundle(extendedHelpMappingBundleName, locale, this.getClass().getClassLoader());
            this.helpBundle.add(extendedBundles2);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        String helpBundleName = this.getApplication().getApplicationManager().getFirstInitialApplication().getHelpBundleName();
        Log.log(4, "help-bundle name of initial application : " + helpBundleName);
        if (helpBundleName != null && !helpBundleName.equals("")) {
            aHelpBundle = GuilibResourceBundle.getBundle(helpBundleName, locale, this.getClass().getClassLoader());
            this.helpBundle.add(aHelpBundle);
            try {
                extendedHelpBundleName = "resources.help." + this.getEndOfString(helpBundleName) + "_ext";
                extendedBundles = GuilibResourceBundle.getBundle(extendedHelpBundleName, locale, this.getClass().getClassLoader());
                this.helpBundle.add(extendedBundles);
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
            String helpmapping = this.getString(aHelpBundle, HELP_DOCUMENT_BUNDLE_KEY);
            Log.log(4, "helpmapping-bundle of initial application : " + helpmapping);
            if (helpmapping != null && !helpmapping.equals("")) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                ResourceBundle helpmappingBundle = GuilibResourceBundle.getBundle(helpmapping, locale, classLoader);
                this.helpBundle.add(helpmappingBundle);
            } else {
                Log.logNotify("No or empty helpmapping-bundle specified for initial app");
            }
        } else {
            Log.logNotify("No or empty help-bundle specified for initial app");
        }
        helpBundleName = this.getHelpBundleName();
        Log.log(4, "help-bundle name of current application=" + helpBundleName);
        if (helpBundleName != null && !helpBundleName.equals("")) {
            aHelpBundle = GuilibResourceBundle.getBundle(helpBundleName, locale, this.getClass().getClassLoader());
            this.helpBundle.add(aHelpBundle);
            try {
                extendedHelpBundleName = "resources.help." + this.getEndOfString(helpBundleName) + "_ext";
                extendedBundles = GuilibResourceBundle.getBundle(extendedHelpBundleName, locale, this.getClass().getClassLoader());
                this.helpBundle.add(extendedBundles);
            }
            catch (MissingResourceException mre) {}
        } else {
            Log.logNotify("No or empty help-bundle specified for current app :" + this.getApplication());
        }
        String documentMappingFile = this.getString(this.helpBundle, HELP_DOCUMENT_BUNDLE_KEY);
        Log.log(4, "helpmapping-bundle of current application : " + documentMappingFile);
        if (documentMappingFile != null && !documentMappingFile.equals("")) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.documentMapping = GuilibResourceBundle.getBundle(documentMappingFile, locale, classLoader);
            this.helpBundle.add(this.documentMapping);
        } else {
            Log.logNotify("No or empty helpmapping-bundle for current app : " + this.getApplication());
        }
    }

    private String getString(ResourceBundle bundle, String key) {
        try {
            Log.trace("getString() bundle = " + bundle);
            Log.trace("getString() key    = " + key);
            if (bundle != null && key != null) {
                String tmpStr = bundle.getString(key);
                return tmpStr;
            }
            Log.logWarning("Empty bundle or key! key=" + key);
        }
        catch (MissingResourceException mre) {
            Log.logWarning("Missing resource : " + key);
        }
        return null;
    }

    public String getAlexBook() {
        String retString = "";
        String docLiUser = "";
        String docLiSys = "";
        try {
            MOProxy managedElement = MOProxy.getRoot();
            MOProxy[] managedElementData = managedElement.getChildren(2, "ManagedElementData", "");
            docLiUser = ((String)managedElementData[0].getAttribute("docLibUserDefined")).trim();
            docLiSys = ((String)managedElementData[0].getAttribute("docLibSystemDefined")).trim();
        }
        catch (CSException cse) {
            Log.logWarning("Unable to retrieve document library from MO " + cse.toString());
            retString = "";
        }
        if (docLiUser.length() > 0) {
            retString = docLiUser;
        } else if (docLiSys.length() > 0) {
            retString = docLiSys;
        }
        return retString;
    }

    private void showDocument(String key) {
        Log.traceFlow();
        Log.logNotify("helpmapping-key = " + key);
        if (key == null || key.equals("")) {
            Log.logError("empty key passed! key=" + key);
            this.showMessageDialog("GSL_ERROR", "BROWSERHELP_INCORRECT_CONFIG_MSG", new String[]{"Empty key for document."});
            return;
        }
        String file = this.getString(this.helpBundle, key);
        Log.logNotify("help-document file = " + file);
        if (file == null || file.equals("")) {
            Object[] param = new String[]{"The key for the document was: " + key};
            this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIG_MSG", param);
            return;
        }
        URL docUrl = null;
        if (file.startsWith(DOCUMENT_ROOT_KEY)) {
            int index = DOCUMENT_ROOT_KEY.length();
            if (EmasSystemProperties.getProperty("application launched", "false").equalsIgnoreCase("true") || EmasSystemProperties.getProperty(EMT_HELPSERVICE, "false").equalsIgnoreCase("TRUE") || System.getProperty(EMT_HELPSERVICE, "false").equalsIgnoreCase("TRUE")) {
                this.callHelpServiceWithHalfUrl(file.substring(index));
                return;
            }
            String path = this.getDocServerAndLibrary();
            if (0 == path.length()) {
                return;
            }
            boolean windows = System.getProperties().getProperty("os.name").indexOf("Windows") > -1;
            path = windows ? path + this.getDocumentRoot() + "\"" + file.substring(index).trim() + "\"" : path + this.getDocumentRoot() + file.substring(index).trim();
            path = path.replace(' ', '+');
            Log.logNotify("path to help-document file (on docserver) = " + path);
            Socket con = null;
            try {
                docUrl = new URL(path);
                String remoteAddress = docUrl.getHost();
                int remotePort = docUrl.getPort();
                if (remotePort == -1) {
                    remotePort = 80;
                }
                Log.logNotify("Checking HTTP connection to docserver...");
                con = new Socket(remoteAddress, remotePort);
                Log.logNotify("HTTP connection OK.");
                con.close();
            }
            catch (MalformedURLException e) {
                Log.logWarning("MalformedURLException LaunchDocserver info page. ");
                this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIGURATION_MSG", null);
                return;
            }
            catch (InterruptedIOException ie) {
                Log.logWarning("InterruptedIOException LaunchDocserver info page.");
                this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIGURATION_MSG", null);
                return;
            }
            catch (IOException ie) {
                Log.logWarning("IOException LaunchDocserver info page.");
                this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIGURATION_MSG", null);
                return;
            }
        } else {
            Log.logWarning("Malformed URL to document server. " + file);
            Object[] param = new String[]{"The key for the document was: " + key + " URL: " + file};
            this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIG_MSG", param);
            return;
        }
        this.startBrowser(docUrl);
    }

    private void showMessageDialog(String headingTag, String messageTag, Object[] messageArguments) {
        Log.traceFlow();
        Object[][] parameters = new Object[][]{{new String("MESSAGEHEADING_TAG"), headingTag}, {new String("MESSAGE_TAG"), messageTag}, {new String("MESSAGE_ARGUMENTS"), messageArguments}};
        this.startDialog(false, "BROWSERHELP_MESSAGEDIALOG_TITLE", null, BrowserHelpMessageDialogView.class, BrowserHelpMessageDialogController.class, parameters);
    }

    private String getDocumentServerAddress() {
        try {
            MOProxy managedElement = MOProxy.getRoot();
            MOProxy[] managedElementData = managedElement.getChildren(2, "ManagedElementData", "");
            Log.trace("managedElementData[0]  " + managedElementData[0].getDN());
            MOProxy.beginTransaction();
            String docroot = (String)managedElementData[0].getAttribute("documentServerAddress");
            MOProxy.endTransaction(true);
            Log.logNotify("Retreived from MO: documentServerAddress = " + docroot);
            return docroot.trim();
        }
        catch (CSException cse) {
            Log.logWarning("Unable to retrieve documentroot from MO " + cse.toString());
            return null;
        }
    }

    private String getDocServerAndLibrary() {
        String path = this.getDocumentServerAddress();
        if (null == path) {
            path = "";
        }
        if (path.length() > 0 && path.toUpperCase().indexOf("LI=") == -1) {
            if (!path.endsWith("?")) {
                path = path + "?";
            }
            path = path + "LI=";
            String lib = this.getAlexBook();
            path = 0 == lib.length() ? "" : path + lib;
        }
        if (0 == path.length()) {
            this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIGURATION_MSG", null);
        }
        return path;
    }

    protected String chopBeginAndEndSlashes(String inputString) {
        Log.trace("inputString (before slash-chopping) = " + inputString);
        String outputString = inputString.trim();
        if (outputString.startsWith("/")) {
            outputString = outputString.substring(1, outputString.length());
        }
        if (outputString.endsWith("/")) {
            outputString = outputString.substring(0, outputString.length() - 1);
        }
        Log.trace("outputString (after slash-chopping) = " + outputString);
        return outputString;
    }

    private String getDocumentRoot() {
        String docRoot = this.getString(this.helpBundle, DOCUMENT_ROOT_KEY);
        if (docRoot == null) {
            docRoot = "";
        }
        docRoot = docRoot.trim();
        Log.log(4, "docserver docroot (from help-bundle)= " + docRoot);
        return docRoot;
    }

    private AbstractView getView() {
        return this.getPresenter().getView();
    }

    private void addF1Lister(JComponent comp) {
        comp.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    AbstractView view = BrowserHelp.this.getView();
                    String helptag = (String)view.getClientProperty("HELP_KEY");
                    Log.logNotify("F1 pressed. helptag = " + helptag + " , " + "window : " + view);
                    if (helptag != null) {
                        String docTitle = (String)view.getClientProperty("TITLE");
                        if (docTitle != null && docTitle.equals("YES")) {
                            BrowserHelp.this.showDocumentWithTitle(helptag);
                        } else {
                            String docLink = BrowserHelp.this.getString(BrowserHelp.this.helpBundle, helptag);
                            if (null == docLink || 0 == docLink.trim().length()) {
                                Object[] param = new String[]{"The key for the document was: " + helptag};
                                BrowserHelp.this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIG_MSG", param);
                                return;
                            }
                            BrowserHelp.this.showDocument(docLink);
                        }
                    }
                }
                catch (Exception e) {
                    Log.trace("BrowserHelp exception when invoking help on F1");
                    e.printStackTrace();
                }
            }
        }, "", KeyStroke.getKeyStroke(112, 0, false), 2);
    }

    public String convertTitle(String title) {
        return title;
    }

    private void showDocumentWithTitle(String title) {
        URL docUrl;
        if (EmasSystemProperties.getProperty("application launched", "false").equalsIgnoreCase("true") || EmasSystemProperties.getProperty(EMT_HELPSERVICE, "false").equalsIgnoreCase("TRUE") || System.getProperty(EMT_HELPSERVICE, "false").equalsIgnoreCase("TRUE")) {
            Properties prop = new Properties();
            prop.setProperty("DOC_TITLE", title);
            this.launchEmToolboxHelp(prop);
            return;
        }
        String docserv = this.getDocServerAndLibrary();
        if (0 == docserv.length()) {
            return;
        }
        String searchableTitle = this.convertTitle(title);
        String path = "";
        boolean windows = System.getProperties().getProperty("os.name").indexOf("Windows") > -1;
        path = windows ? docserv + "\"&AC=SEARCHEXT&ST=TITLE&PA=" + searchableTitle.replace(' ', '+') + "\"" : docserv + "&AC=SEARCHEXT&ST=TITLE&PA=" + searchableTitle.replace(' ', '+');
        Socket con = null;
        try {
            docUrl = new URL(path);
            String remoteAddress = docUrl.getHost();
            int remotePort = docUrl.getPort();
            if (remotePort == -1) {
                remotePort = 80;
            }
            Log.logNotify("Checking HTTP connection to docserver... ");
            con = TimedSocket.getSocket(remoteAddress, remotePort, 4000);
            Log.logNotify("HTTP connection OK.");
            con.close();
        }
        catch (MalformedURLException e) {
            Log.logWarning("MalformedURLException LaunchDocserver info page. ");
            this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIGURATION_MSG", null);
            return;
        }
        catch (InterruptedIOException ie) {
            Log.logWarning("InterruptedIOException LaunchDocserver info page.");
            this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIGURATION_MSG", null);
            return;
        }
        catch (IOException ie) {
            Log.logWarning("IOException LaunchDocserver info page.");
            this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIGURATION_MSG", null);
            return;
        }
        this.startBrowser(docUrl);
    }

    public void startBrowser(URL docUrl) {
        String osName;
        try {
            osName = System.getProperties().getProperty("os.name");
        }
        catch (Exception e0) {
            Log.logError("Exception in getProperty(os.name)");
            osName = null;
        }
        Log.trace("OS: " + osName);
        if (osName != null && (osName.equals("Windows 95") || osName.equals("Windows 98"))) {
            try {
                Runtime.getRuntime().exec("start " + docUrl);
            }
            catch (Exception e1) {
                Log.logError("An error occured while trying to launch browser for ALEX document: " + docUrl, e1);
            }
        } else if (osName != null && osName.equals("Windows NT")) {
            try {
                Runtime.getRuntime().exec("cmd /c start " + docUrl);
            }
            catch (Exception e) {
                Log.logError("An error occured while trying to launch browser for ALEX document: " + docUrl, e);
            }
        } else if (osName != null && osName.indexOf("Windows") > -1) {
            try {
                Runtime.getRuntime().exec("cmd /c start " + docUrl);
            }
            catch (Exception e) {
                Log.logError("An error occured while trying to launch browser for ALEX document: " + docUrl, e);
            }
        } else {
            if (null == this.preferredBrowser) {
                Object[] possibleValues = new Object[]{"mozilla", "firefox"};
                Object selectedValue = JOptionPane.showInputDialog(EmasGuilibMediator.getReference().getMainWindowReference().getMainWindowView(), "Browser application for display of help:", "Select Browser", 3, null, possibleValues, possibleValues[0]);
                this.preferredBrowser = (String)selectedValue;
                if (null == this.preferredBrowser) {
                    return;
                }
            }
            try {
                Runtime.getRuntime().exec(this.preferredBrowser + " " + docUrl);
            }
            catch (Exception e) {
                Log.logError("Was not able to launch the browser " + this.preferredBrowser + " with the page " + docUrl, e);
            }
        }
    }

    private void callHelpServiceWithHalfUrl(String searchExpressionFromHelpProperties) {
        boolean windows;
        searchExpressionFromHelpProperties = searchExpressionFromHelpProperties.trim();
        searchExpressionFromHelpProperties = searchExpressionFromHelpProperties.replace(' ', '+');
        boolean bl = windows = System.getProperties().getProperty("os.name").indexOf("Windows") > -1;
        if (windows) {
            searchExpressionFromHelpProperties = "\"" + searchExpressionFromHelpProperties + "\"";
        }
        Properties prop = new Properties();
        prop.setProperty(ALEX_SEARCH_EXPRESSION, searchExpressionFromHelpProperties);
        this.launchEmToolboxHelp(prop);
    }

    private void launchEmToolboxHelp(Properties props) {
        Log.logNotify("launchEmToolboxHelp");
        this.helpServiceConfigFile = EmasSystemProperties.getProperty("HELPSERVICE_CONFIG", "");
        if (0 == this.helpServiceConfigFile.length()) {
            Log.logWarning("BrowserHelp found no path to HelpService configuration file in EmasSystemProperties.");
            Object[] arr = new String[]{"The configuration file for Help Service was not available."};
            this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIG_MSG", arr);
            return;
        }
        String nodeServiceConfig = EmasSystemProperties.getProperty("NODESERVICES_CONFIG", "missing");
        String iconpath = EmasSystemProperties.getProperty("TOOL_ICON", "missing");
        Log.logNotify("launchEmToolboxHelp HELPSERVICE_CONFIG: " + this.helpServiceConfigFile);
        if (!"missing".equals(nodeServiceConfig)) {
            props.setProperty("NODESERVICES_CONFIG", nodeServiceConfig);
        }
        if (!"missing".equals(iconpath)) {
            props.setProperty("TOOL_ICON", iconpath);
        }
        MainWindowController mainWindow = EmasGuilibMediator.getReference().getMainWindowReference();
        Log.logNotify("launchEmToolboxHelp, calling launchResource");
        try {
            mainWindow.getApplicationManager().launchResource(this.helpServiceConfigFile, props);
        }
        catch (Exception e) {
            Log.logWarning("launchResource caused exception: " + e.getMessage());
        }
    }

    private class TrackingListener
    implements ActionListener {
        private Toolkit tk = Toolkit.getDefaultToolkit();
        private EventQueue eventQueue = null;
        private boolean firstClick = true;

        private TrackingListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object trackerObject = e.getSource();
            Log.logNotify("help-tracking activated: " + trackerObject);
            if (((JComponent)e.getSource()).getClientProperty("HELP_TRACKING") != null) {
                String icKey = null;
                icKey = BrowserHelp.this.getApplication().getApplicationManager().getFirstInitialApplication().getEnvironment().getProperty(HELP_TRACKING_ICON);
                Log.logNotify("Image loaded..: " + icKey);
                ClassLoader classLoader = this.getClass().getClassLoader();
                Image image = this.tk.createImage(classLoader.getResource(icKey));
                Cursor cur = this.tk.createCustomCursor(image, new Point(0, 0), "HelpTracker");
                Log.trace("The cursor: " + cur.toString());
                BrowserHelp.this.getApplication().setCursor(cur);
                try {
                    this.eventQueue = this.tk.getSystemEventQueue();
                }
                catch (Exception ex) {
                    Log.logWarning("Exception TrackingListener");
                    this.restoreCursor();
                    return;
                }
                while (true) {
                    try {
                        MouseEvent me;
                        Object src;
                        AWTEvent event;
                        while (true) {
                            int eID;
                            event = this.eventQueue.getNextEvent();
                            src = event.getSource();
                            if (!(event instanceof MouseEvent) || (eID = (me = (MouseEvent)event).getID()) != 501 && eID != 502 && eID != 500) continue;
                            if (!this.firstClick) break;
                            this.firstClick = false;
                            me.consume();
                        }
                        Object obj = this.getDeepestObjectAt(src, me.getX(), me.getY());
                        this.eventFired(obj, event);
                        this.firstClick = true;
                        me.consume();
                        return;
                    }
                    catch (InterruptedException ie) {
                        Log.logWarning("InterruptedException");
                        continue;
                    }
                    break;
                }
            }
        }

        private void restoreCursor() {
            BrowserHelp.this.getApplication().setCursor(Cursor.getDefaultCursor());
        }

        public void eventFired(Object src, AWTEvent ae) {
            this.restoreCursor();
            JComponent comp = null;
            if (src instanceof JComponent) {
                comp = (JComponent)src;
            }
            String key = null;
            String docTitle = null;
            if (comp != null) {
                key = (String)comp.getClientProperty("HELP_KEY");
                docTitle = (String)comp.getClientProperty("TITLE");
            }
            if (key != null) {
                Log.logNotify("helptag on component = " + key);
                if (docTitle != null && docTitle.equals("YES")) {
                    BrowserHelp.this.showDocumentWithTitle(docTitle);
                } else {
                    String docLink = BrowserHelp.this.getString(BrowserHelp.this.helpBundle, key);
                    if (null == docLink || 0 == docLink.trim().length()) {
                        Object[] param = new String[]{"The key for the document was: " + key};
                        BrowserHelp.this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIG_MSG", param);
                        return;
                    }
                    BrowserHelp.this.showDocument(docLink);
                }
            }
            int nCnt = 0;
            do {
                try {
                    AWTEvent event = this.eventQueue.getNextEvent();
                    Object srcObj = event.getSource();
                    if (src == srcObj && event instanceof MouseEvent) {
                        MouseEvent aev = (MouseEvent)event;
                        int eID = event.getID();
                        if (eID == 501 || eID == 502 || eID == 500) {
                            Log.trace("ActionEvent consumed: " + event.getClass().getName());
                            aev.consume();
                            return;
                        }
                    }
                }
                catch (InterruptedException ie) {
                    Log.logWarning("InterruptedException in TrackingListener");
                }
            } while (++nCnt <= 5);
        }

        private Object getDeepestObjectAt(Object parent, int x, int y) {
            Component child;
            if (parent != null && parent instanceof Container && (child = this.findComponentAt((Container)parent, x, y)) != null && child != parent) {
                if (child instanceof JRootPane) {
                    JLayeredPane lp = ((JRootPane)child).getLayeredPane();
                    Rectangle b = lp.getBounds();
                    child = (Component)this.getDeepestObjectAt(lp, x - b.x, y - b.y);
                    if (child != null) {
                        return child;
                    }
                } else {
                    return child;
                }
            }
            return parent;
        }

        private Component findComponentAt(Container cont, int x, int y) {
            if (!cont.contains(x, y)) {
                return null;
            }
            int ncomponents = cont.getComponentCount();
            Component[] component = cont.getComponents();
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = component[i];
                if (comp == null) continue;
                Point compp = comp.getLocation();
                if ((comp = comp instanceof Container ? this.findComponentAt((Container)comp, x - compp.x, y - compp.y) : comp.getComponentAt(x - compp.x, y - compp.y)) == null || !comp.isVisible()) continue;
                return comp;
            }
            return cont;
        }
    }

    private class KeyPressedListener
    implements KeyListener {
        private KeyPressedListener() {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            Log.traceFlow();
            if (e.getKeyCode() == 112) {
                String helptag = null;
                String titleHelp = null;
                if (e.getModifiers() == 1) {
                    JComponent component = (JComponent)e.getSource();
                    helptag = (String)component.getClientProperty("HELP_KEY");
                    titleHelp = (String)component.getClientProperty("TITLE");
                    Log.logNotify("Shift-F1 pressed. helptag = " + helptag + " , " + " component : " + component);
                    e.consume();
                    if (helptag != null) {
                        if (titleHelp != null && titleHelp.equals("YES")) {
                            BrowserHelp.this.showDocumentWithTitle(helptag);
                        } else {
                            BrowserHelp.this.showDocument(helptag);
                        }
                    }
                }
            }
        }
    }

    private class ButtonAction
    implements ActionListener {
        private ButtonAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Object buttonObject = e.getSource();
            Log.log(4, "Button pressed. button = " + buttonObject);
            String key = (String)((JComponent)buttonObject).getClientProperty("HELP_KEY");
            String titleKey = (String)((JComponent)buttonObject).getClientProperty("TITLE");
            if (titleKey != null && titleKey.equals("YES")) {
                BrowserHelp.this.showDocumentWithTitle(key);
                return;
            }
            Log.logNotify("Button pressed. helptag = " + key);
            String docLink = BrowserHelp.this.getString(BrowserHelp.this.helpBundle, key);
            if (null == docLink || 0 == docLink.trim().length()) {
                Object[] param = new String[]{"The key for the document was: " + key};
                BrowserHelp.this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIG_MSG", param);
                return;
            }
            BrowserHelp.this.showDocument(docLink);
        }
    }
}

