/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogView;
import se.ericsson.cello.support.gui.guilib.infra.AbstractHelp;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.ResourceBundleDelegator;

class HtmlHelp
extends AbstractHelp {
    private static String BACK_ICON_KEY = "gsl.icon.back";
    private static String FORWARD_ICON_KEY = "gsl.icon.forward";
    private static String DOCUMENT_ROOT_KEY = "gsl.help.html.documentroot";
    private static String HELP_DOCUMENT_BUNDLE_KEY = "gsl.help.documentmapping";
    private String documentRoot;
    private ResourceBundleDelegator helpBundle = new ResourceBundleDelegator();
    private Vector components = new Vector();
    private KeyPressedListener keyListener = new KeyPressedListener();
    private ButtonAction buttonListener = new ButtonAction();
    private AbstractDialogController dialogController = null;
    private ResourceBundle documentMapping;
    private Locale currentLocale = null;

    public void handleComponent(JComponent comp) {
        if (comp instanceof AbstractButton && comp.getClientProperty("HELP_ENABLE") != null) {
            ((AbstractButton)comp).addActionListener(this.buttonListener);
        }
        comp.addKeyListener(this.keyListener);
        this.components.addElement(comp);
    }

    public void dispose() {
        for (int i = 0; i < this.components.size(); ++i) {
            JComponent comp = (JComponent)this.components.elementAt(i);
            comp.removeKeyListener(this.keyListener);
            if (comp.getClientProperty("HELP_ENABLE") == null) continue;
            ((AbstractButton)comp).removeActionListener(this.buttonListener);
        }
        this.components.clear();
    }

    public void updateHelp(Locale locale) {
        if (this.currentLocale != locale) {
            this.currentLocale = locale;
            if (this.dialogController != null) {
                this.dialogController.stopDialog();
            }
        }
        this.helpBundle.add(GuilibResourceBundle.getBundle(this.getApplication().getEnvironment().getProperty("gsl.help.default.bundle.name"), locale, this.getClass().getClassLoader()));
        String helpBundleName = this.getHelpBundleName();
        if (helpBundleName != null && !helpBundleName.equals("")) {
            ResourceBundle aHelpBundle = GuilibResourceBundle.getBundle(helpBundleName, locale, this.getClass().getClassLoader());
            this.helpBundle.add(aHelpBundle);
            this.documentRoot = this.getString(this.helpBundle, DOCUMENT_ROOT_KEY);
            String documentMappingFile = this.getString(this.helpBundle, HELP_DOCUMENT_BUNDLE_KEY);
            if (documentMappingFile != null && !documentMappingFile.equals("")) {
                this.documentMapping = GuilibResourceBundle.getBundle(documentMappingFile, locale, this.getClass().getClassLoader());
                if (this.documentRoot == null) {
                    try {
                        URL root = this.getClass().getClassLoader().getResource(documentMappingFile + ".properties");
                        String tmpRoot = root.toString();
                        Log.logNotify("tmpRoot " + tmpRoot);
                        this.documentRoot = tmpRoot.substring(0, tmpRoot.lastIndexOf("/") + 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            this.documentRoot = this.getString(this.helpBundle, DOCUMENT_ROOT_KEY);
        }
    }

    void helpIsClosing() {
        this.dialogController = null;
    }

    private String getString(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private void showDocument(URL docUrl) {
        if (this.dialogController == null) {
            this.dialogController = this.startDialog(false, "GSL_HELP", null, HtmlHelpDialogView.class, HtmlHelpDialogController.class);
            ((HtmlHelpDialogController)this.dialogController).setParent(this);
        }
        ((HtmlHelpDialogController)this.dialogController).showDocument(docUrl);
    }

    private void showDocument(String key) {
        String file = this.getString(this.documentMapping, key);
        if (file != null) {
            URL docUrl = null;
            String path = file;
            if (!file.startsWith("http://")) {
                path = this.documentRoot + file;
            }
            try {
                Log.logNotify("Document path " + path);
                docUrl = new URL(path);
            }
            catch (Exception e) {
                Log.assertion(false, "Illegal url");
                return;
            }
            this.showDocument(docUrl);
        }
    }

    protected AbstractDialogController startDialog(boolean modal, String titleKey, Object[] titleArgs, Class dialogViewClass, Class dialogControllerClass) {
        return this.getPresenter().getController().startDialog(modal, titleKey, titleArgs, dialogViewClass, dialogControllerClass);
    }

    static class HtmlHelpDialogController
    extends AbstractDialogController {
        private Vector urls = new Vector();
        private int currentIndex = -1;
        private HtmlHelpDialogView view;
        private HtmlHelp parent;
        private BackAction back = new BackAction();
        private ForwardAction forward = new ForwardAction();
        private Hyperactive hyper = new Hyperactive();

        HtmlHelpDialogController() {
        }

        public void init() {
            this.view = (HtmlHelpDialogView)this.getView();
            this.view.docPane.addHyperlinkListener(this.hyper);
            this.view.backButton.addActionListener(this.back);
            this.view.forwardButton.addActionListener(this.forward);
        }

        public boolean canStop() {
            this.parent.helpIsClosing();
            return true;
        }

        public void stop() {
            this.view.backButton.removeActionListener(this.back);
            this.view.forwardButton.removeActionListener(this.forward);
            this.view.docPane.removeHyperlinkListener(this.hyper);
            this.urls.clear();
        }

        void setParent(HtmlHelp parent) {
            this.parent = parent;
        }

        void showDocument(URL document) {
            try {
                this.view.docPane.setPage(document);
                ++this.currentIndex;
                this.urls.addElement(document);
                this.updateButtons();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        private void clearFromCurrentIndex() {
            while (this.urls.size() > this.currentIndex + 1) {
                this.urls.remove(this.currentIndex + 1);
            }
        }

        private void updateButtons() {
            this.view.backButton.setEnabled(this.currentIndex != 0);
            this.view.forwardButton.setEnabled(this.currentIndex != this.urls.size() - 1);
        }

        private class Hyperactive
        implements HyperlinkListener {
            private Hyperactive() {
            }

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane pane = (JEditorPane)e.getSource();
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                        HTMLDocument doc = (HTMLDocument)pane.getDocument();
                        doc.processHTMLFrameHyperlinkEvent(evt);
                    } else {
                        try {
                            pane.setPage(e.getURL());
                            HtmlHelpDialogController.this.clearFromCurrentIndex();
                            HtmlHelpDialogController.this.urls.addElement(e.getURL());
                            HtmlHelpDialogController.this.currentIndex++;
                            HtmlHelpDialogController.this.updateButtons();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            }
        }

        private class ForwardAction
        extends BaseAction {
            private ForwardAction() {
            }

            public void actionPerformed(ActionEvent e) {
                HtmlHelpDialogController.this.currentIndex++;
                super.actionPerformed(e);
            }
        }

        private class BackAction
        extends BaseAction {
            private BackAction() {
            }

            public void actionPerformed(ActionEvent e) {
                HtmlHelpDialogController.this.currentIndex--;
                super.actionPerformed(e);
            }
        }

        private class BaseAction
        implements ActionListener {
            private BaseAction() {
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    ((HtmlHelpDialogController)HtmlHelpDialogController.this).view.docPane.setPage((URL)HtmlHelpDialogController.this.urls.elementAt(HtmlHelpDialogController.this.currentIndex));
                    HtmlHelpDialogController.this.updateButtons();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static class HtmlHelpDialogView
    extends AbstractDialogView {
        JEditorPane docPane = new JEditorPane();
        JButton backButton;
        JButton forwardButton;

        HtmlHelpDialogView() {
        }

        public void init() {
            this.docPane.setEditable(false);
            JScrollPane scrollP = new JScrollPane(this.docPane);
            this.setLayout(new BorderLayout());
            JPanel buttonPanel = new JPanel();
            this.backButton = new JButton(this.createIcon(this.getProperty(BACK_ICON_KEY)));
            this.backButton.setToolTipText("GSL_BACK");
            this.forwardButton = new JButton(this.createIcon(this.getProperty(FORWARD_ICON_KEY)));
            this.forwardButton.setToolTipText("GSL_FORWARD");
            buttonPanel.add(this.backButton);
            buttonPanel.add(this.forwardButton);
            this.add((Component)buttonPanel, "North");
            this.add((Component)scrollP, "Center");
        }

        public Dimension getPreferredSize() {
            return new Dimension(800, 600);
        }
    }

    private class KeyPressedListener
    implements KeyListener {
        private KeyPressedListener() {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 112) {
                String key = (String)((JComponent)e.getSource()).getClientProperty("HELP_KEY");
                HtmlHelp.this.showDocument(HtmlHelp.this.getString(HtmlHelp.this.helpBundle, key));
            }
        }
    }

    private class ButtonAction
    implements ActionListener {
        private ButtonAction() {
        }

        public void actionPerformed(ActionEvent e) {
            String key = (String)((JComponent)e.getSource()).getClientProperty("HELP_KEY");
            HtmlHelp.this.showDocument(HtmlHelp.this.getString(HtmlHelp.this.helpBundle, key));
        }
    }
}

