/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogController;
import se.ericsson.cello.support.gui.guilib.infra.Application;
import se.ericsson.cello.support.gui.guilib.infra.PrintPreviewView;
import se.ericsson.cello.support.gui.guilib.infra.Printout;
import se.ericsson.cello.support.gui.guilib.infra.PrintoutImpl;

class PrintPreviewController
extends AbstractDialogController {
    private int m_wPage;
    private int m_hPage;
    private int orientation;
    private Printable target;
    private Printout printout;
    private PrintPreviewView printPreviewView;
    private PrintListener printListener = new PrintListener();
    private CloseListener closeListener = new CloseListener();
    private RefreshListener refreshListener = new RefreshListener();
    private ComboScaleListener comboScaleListener = new ComboScaleListener();
    private ResolutionListener resolutionListener = new ResolutionListener();

    PrintPreviewController() {
    }

    public void init() {
        this.printPreviewView = (PrintPreviewView)this.getView();
        this.printPreviewView.printButton.addActionListener(this.printListener);
        this.printPreviewView.closeButton.addActionListener(this.closeListener);
        this.printPreviewView.refreshButton.addActionListener(this.refreshListener);
        String[] scales = new String[]{"10 %", "25 %", "50 %", "100 %"};
        for (int i = 0; i < scales.length; ++i) {
            this.printPreviewView.comboScale.addItem(scales[i]);
        }
        this.printPreviewView.comboScale.setSelectedItem(scales[3]);
        this.printPreviewView.comboScale.setEditable(true);
        this.printPreviewView.comboScale.addActionListener(this.comboScaleListener);
        this.printPreviewView.resolutionButton.addActionListener(this.resolutionListener);
    }

    public void afterVisible() {
        this.printout = (Printout)this.resolveObject("infra.printout.Printout");
        this.target = (PrintoutImpl)this.resolveObject("infra.printout.PrintoutImpl");
        this.orientation = (Integer)this.resolveObject("infra.printout.Orientation");
        PrinterJob prnJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = prnJob.defaultPage();
        pageFormat.setOrientation(this.orientation);
        if (pageFormat.getHeight() == 0.0 || pageFormat.getWidth() == 0.0) {
            this.stopDialog();
            return;
        }
        this.m_wPage = (int)pageFormat.getWidth();
        this.m_hPage = (int)pageFormat.getHeight();
        int scale = 10;
        int w = this.m_wPage * scale / 100;
        int h = this.m_hPage * scale / 100;
        int pageIndex = 0;
        try {
            while (true) {
                BufferedImage img = new BufferedImage(this.m_wPage, this.m_hPage, 1);
                Graphics g = img.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, this.m_wPage, this.m_hPage);
                if (this.target.print(g, pageFormat, pageIndex) == 0) {
                    PagePreview pp = new PagePreview(w, h, img);
                    this.printPreviewView.previewContainer.add(pp);
                    ++pageIndex;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
        }
        this.updatePreview();
        this.printout.previewStarted();
    }

    public void stop() {
        this.printPreviewView.printButton.removeActionListener(this.printListener);
        this.printPreviewView.closeButton.removeActionListener(this.closeListener);
        this.printPreviewView.refreshButton.removeActionListener(this.refreshListener);
        this.printPreviewView.comboScale.removeActionListener(this.comboScaleListener);
        this.printPreviewView.resolutionButton.removeActionListener(this.resolutionListener);
    }

    private void updatePreview() {
        this.printPreviewView.setCursor(Application.WAIT_CURSOR);
        int scale = 100;
        int resolution = this.printPreviewView.resolutionButton.isSelected() ? 4 : 1;
        String str = this.printPreviewView.comboScale.getSelectedItem().toString();
        if (str.endsWith("%")) {
            str = str.substring(0, str.length() - 1);
        }
        str = str.trim();
        try {
            scale = Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            return;
        }
        int w = this.m_wPage * scale / 100;
        int h = this.m_hPage * scale / 100;
        Component[] comps = this.printPreviewView.previewContainer.getComponents();
        for (int k = 0; k < comps.length; ++k) {
            if (!(comps[k] instanceof PagePreview)) continue;
            PagePreview pp = (PagePreview)comps[k];
            pp.setScaledSize(w, h, resolution);
        }
        this.printPreviewView.previewContainer.doLayout();
        this.printPreviewView.previewContainer.getParent().getParent().validate();
        this.printPreviewView.myPaint();
        this.printPreviewView.setCursor(Application.DEFAULT_CURSOR);
    }

    private class RefreshListener
    implements ActionListener {
        private RefreshListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PrintPreviewController.this.updatePreview();
        }
    }

    private static class ResolutionListener
    implements ActionListener {
        private ResolutionListener() {
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ComboScaleListener
    implements ActionListener {
        private ComboScaleListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PrintPreviewController.this.updatePreview();
        }
    }

    private class CloseListener
    implements ActionListener {
        private CloseListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PrintPreviewController.this.stopDialog();
        }
    }

    private class PrintListener
    implements ActionListener {
        private PrintListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Thread printThread = new Thread(){

                public void run() {
                    try {
                        PrinterJob prnJob = PrinterJob.getPrinterJob();
                        PageFormat pageFormat = prnJob.pageDialog(prnJob.defaultPage());
                        prnJob.setPrintable(PrintPreviewController.this.target, pageFormat);
                        if (!prnJob.printDialog()) {
                            return;
                        }
                        prnJob.print();
                    }
                    catch (PrinterException ex) {
                        ex.printStackTrace();
                    }
                }
            };
            printThread.start();
        }
    }

    static class PagePreview
    extends JPanel {
        private int width;
        private int height;
        private Image imageFullScale;
        private Image imageScaled;

        public PagePreview(int width, int height, Image source) {
            this.imageFullScale = source;
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
            this.setScaledSize(width, height, 1);
        }

        public void setScaledSize(int width, int height, int resolution) {
            this.width = width;
            this.height = height;
            this.imageScaled = this.imageFullScale.getScaledInstance(width, height, resolution);
            this.imageScaled.flush();
        }

        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(this.width + ins.left + ins.right, this.height + ins.top + ins.bottom);
        }

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.drawImage(this.imageScaled, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), this);
            this.paintBorder(g2);
        }
    }
}

