/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogView;

class PrintPreviewView
extends AbstractDialogView {
    PreviewContainer previewContainer;
    JPanel buttonPanel = new JPanel();
    JButton printButton = new JButton("GSL_PRINT");
    JButton closeButton = new JButton("GSL_CLOSE");
    JButton refreshButton = new JButton("GSL_REFRESH");
    JComboBox comboScale = new JComboBox();
    JCheckBox resolutionButton = new JCheckBox("GSL_HIGH_RESOLUTION");
    boolean beenVisible = false;

    PrintPreviewView() {
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.previewContainer = new PreviewContainer();
        JScrollPane ps = new JScrollPane(this.previewContainer);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.comboScale, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 10, 5, 0), 10, 0));
        this.buttonPanel.add((Component)this.resolutionButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.buttonPanel.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 1000.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.refreshButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.buttonPanel.add((Component)this.printButton, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.buttonPanel.add((Component)this.closeButton, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.add((Component)ps, "Center");
        this.add((Component)this.buttonPanel, "South");
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 400);
    }

    public void myPaint() {
        this.beenVisible = true;
        this.paint(this.getGraphics());
    }

    public void paint(Graphics g) {
        if (this.beenVisible) {
            super.paint(g);
        }
    }

    static class PreviewContainer
    extends JPanel {
        protected int H_GAP = 16;
        protected int V_GAP = 10;

        PreviewContainer() {
        }

        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int ww = nCol * (w + this.H_GAP) + this.H_GAP;
            int hh = nRow * (h + this.V_GAP) + this.V_GAP;
            Insets ins = this.getInsets();
            return new Dimension(ww + ins.left + ins.right, hh + ins.top + ins.bottom);
        }

        public void doLayout() {
            Insets ins = this.getInsets();
            int x = ins.left + this.H_GAP;
            int y = ins.top + this.V_GAP;
            int n = this.getComponentCount();
            if (n == 0) {
                return;
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int index = 0;
            for (int k = 0; k < nRow; ++k) {
                for (int m = 0; m < nCol; ++m) {
                    if (index >= n) {
                        return;
                    }
                    comp = this.getComponent(index++);
                    comp.setBounds(x, y, w, h);
                    x += w + this.H_GAP;
                }
                y += h + this.V_GAP;
                x = ins.left + this.H_GAP;
            }
        }
    }
}

