/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.KeyStroke;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogController;
import se.ericsson.cello.support.gui.guilib.infra.WindowsDialogView;

class WindowsDialogController
extends AbstractDialogController {
    private WindowsDialogView view;
    private ShowWindowAction showWindowAction = new ShowWindowAction();

    WindowsDialogController() {
    }

    protected void init() {
        this.view = (WindowsDialogView)this.getView();
        this.view.list.setModel(new ApplicationListModel());
        this.view.list.registerKeyboardAction(this.showWindowAction, KeyStroke.getKeyStroke(10, 0), 1);
        this.view.list.addMouseListener(new MouseListenerImpl());
        this.view.cancelButton.addActionListener(new CancelAction());
        this.view.okButton.addActionListener(this.showWindowAction);
    }

    private void cancel() {
        this.stopDialog();
    }

    private void showWindow() {
        this.stopDialog();
        ApplicationHolder applicationHolder = (ApplicationHolder)this.view.list.getSelectedValue();
        if (applicationHolder != null) {
            applicationHolder.getApplication().getApplicationPresenter().getViewContainer().bringToFront();
        }
    }

    private static class ApplicationHolder {
        private AbstractApplication application;

        public ApplicationHolder(AbstractApplication application) {
            this.application = application;
        }

        public AbstractApplication getApplication() {
            return this.application;
        }

        public String toString() {
            return this.application.getTitle();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent event) {
            WindowsDialogController.this.cancel();
        }
    }

    private class MouseListenerImpl
    extends MouseAdapter {
        private MouseListenerImpl() {
        }

        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() > 1) {
                WindowsDialogController.this.showWindow();
            }
        }
    }

    private class ShowWindowAction
    implements ActionListener {
        private ShowWindowAction() {
        }

        public void actionPerformed(ActionEvent event) {
            WindowsDialogController.this.showWindow();
        }
    }

    private class ApplicationListModel
    extends DefaultListModel {
        public ApplicationListModel() {
            Enumeration enume = WindowsDialogController.this.getApplication().getApplicationManager().getAllApplications();
            while (enume.hasMoreElements()) {
                this.addElement(new ApplicationHolder((AbstractApplication)enume.nextElement()));
            }
        }
    }
}

