/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.table;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ColumnGroup
extends JTableHeader {
    private TableCellRenderer renderer;
    private Vector columnVector;
    private int margin = 0;
    private String key;
    private String title = "";

    public ColumnGroup(String key) {
        this(null, key);
    }

    public ColumnGroup(TableCellRenderer renderer, String key) {
        this.renderer = renderer == null ? new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setHorizontalAlignment(0);
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        } : renderer;
        this.key = key;
        this.columnVector = new Vector();
    }

    public void add(Object obj) {
        if (obj == null) {
            return;
        }
        this.columnVector.addElement(obj);
    }

    Vector getColumnGroups(TableColumn c, Vector g) {
        g.addElement(this);
        if (this.columnVector.contains(c)) {
            return g;
        }
        Enumeration enume = this.columnVector.elements();
        while (enume.hasMoreElements()) {
            Vector groups;
            Object obj = enume.nextElement();
            if (!(obj instanceof ColumnGroup) || (groups = ((ColumnGroup)obj).getColumnGroups(c, (Vector)g.clone())) == null) continue;
            return groups;
        }
        return null;
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.renderer;
    }

    public void setHeaderRenderer(TableCellRenderer renderer) {
        if (renderer != null) {
            this.renderer = renderer;
        }
    }

    public Object getHeaderValue() {
        return this.title;
    }

    public String getHeaderKey() {
        return this.key;
    }

    public void setHeaderValue(String title) {
        this.title = title;
    }

    Dimension getSize(JTable table) {
        Component comp = this.renderer.getTableCellRendererComponent(table, this.getHeaderValue(), false, false, -1, -1);
        int height = comp.getPreferredSize().height;
        int width = 0;
        Enumeration enume = this.columnVector.elements();
        while (enume.hasMoreElements()) {
            Object obj = enume.nextElement();
            if (obj instanceof TableColumn) {
                TableColumn aColumn = (TableColumn)obj;
                width += aColumn.getWidth();
                width += this.margin;
                continue;
            }
            width += ((ColumnGroup)obj).getSize((JTable)table).width;
        }
        return new Dimension(width, height);
    }

    void setColumnMargin(int margin) {
        this.margin = margin;
        Enumeration enume = this.columnVector.elements();
        while (enume.hasMoreElements()) {
            Object obj = enume.nextElement();
            if (!(obj instanceof ColumnGroup)) continue;
            ((ColumnGroup)obj).setColumnMargin(margin);
        }
    }
}

