/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.table;

import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.table.Range;
import se.ericsson.cello.support.gui.guilib.table.SmartTableCell;

public class FloatTableCell
extends SmartTableCell {
    private String value;
    private Range[] ranges;
    private boolean valueMandatory = false;

    public FloatTableCell(Float value, boolean isEditable, float[][] ranges) {
        this.init(value, isEditable, ranges);
    }

    public FloatTableCell(float value) {
        this.init(new Float(value), false, null);
    }

    public FloatTableCell() {
        this.init(null, false, null);
    }

    public FloatTableCell(boolean isEditable) {
        this.init(null, isEditable, null);
    }

    public FloatTableCell(float value, boolean isEditable) {
        this.init(new Float(value), isEditable, null);
    }

    public FloatTableCell(boolean isEditable, float[][] ranges) {
        this.init(null, isEditable, ranges);
    }

    public FloatTableCell(float value, boolean isEditable, float[][] ranges) {
        this.init(new Float(value), isEditable, ranges);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(Float value, boolean isEditable, float[][] ranges) {
        if (ranges != null) {
            this.valueMandatory = true;
            this.ranges = new Range[ranges.length];
            for (int i = 0; i < ranges.length; ++i) {
                this.ranges[i] = new Range(new Float(ranges[i][0]), new Float(ranges[i][1]));
            }
        }
        this.setEditable(isEditable);
        if (value != null) {
            if (!this.checkRange(value.floatValue())) throw new RuntimeException("Value out of range");
            this.value = String.valueOf(value.floatValue());
            return;
        } else {
            this.value = null;
        }
    }

    private boolean checkRange(float theValue) {
        if (this.ranges == null) {
            return true;
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            float lower = ((Float)this.ranges[i].getLower()).floatValue();
            float higher = ((Float)this.ranges[i].getHigher()).floatValue();
            if (!(theValue >= lower) || !(theValue <= higher)) continue;
            return true;
        }
        return false;
    }

    public Range[] getRange() {
        return this.ranges;
    }

    public Object getValue() {
        return this;
    }

    public Object getCellValue() {
        if (this.value != null) {
            return new Float(this.value);
        }
        return null;
    }

    public String toString() {
        if (this.value != null) {
            return this.value;
        }
        return " ";
    }

    public void setValueMandatory(boolean valueMandatory) {
        this.valueMandatory = valueMandatory;
    }

    public boolean setValue(Object value) {
        float floatValue = 0.0f;
        if (value instanceof Float) {
            floatValue = ((Float)value).floatValue();
        } else if (value instanceof String) {
            try {
                if (((String)value).length() > 0) {
                    floatValue = Float.parseFloat((String)value);
                } else {
                    Log.logWarning("Before null in setValue FloatTableCell");
                    value = null;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (value == null) {
            if (this.valueMandatory) {
                return false;
            }
            this.value = null;
            return true;
        }
        if (!this.checkRange(floatValue)) {
            return false;
        }
        this.value = Float.toString(floatValue);
        return true;
    }

    public int compareTo(Object value) {
        if (this.value != null && ((FloatTableCell)value).getCellValue() != null) {
            return Float.valueOf(this.value).compareTo(Float.valueOf(value.toString()));
        }
        if (this.value != null && ((FloatTableCell)value).getCellValue() == null) {
            return 1;
        }
        if (this.value == null && ((FloatTableCell)value).getCellValue() == null) {
            return 0;
        }
        return -1;
    }
}

