/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.table;

import se.ericsson.cello.support.gui.guilib.table.Range;
import se.ericsson.cello.support.gui.guilib.table.SmartTableCell;

public class IntegerTableCell
extends SmartTableCell {
    private String value;
    private Range[] ranges;
    private boolean valueMandatory = false;

    public IntegerTableCell(Integer value, boolean isEditable, int[][] ranges) {
        this.init(value, isEditable, ranges);
    }

    public IntegerTableCell(int value) {
        this.init(new Integer(value), false, null);
    }

    public IntegerTableCell(boolean isEditable) {
        this.init(null, isEditable, null);
    }

    public IntegerTableCell(int value, boolean isEditable) {
        this.init(new Integer(value), isEditable, null);
    }

    public IntegerTableCell(boolean isEditable, int[][] ranges) {
        this.init(null, isEditable, ranges);
    }

    public IntegerTableCell(int value, boolean isEditable, int[][] ranges) {
        this.init(new Integer(value), isEditable, ranges);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(Integer value, boolean isEditable, int[][] ranges) {
        if (ranges != null) {
            this.valueMandatory = true;
            this.ranges = new Range[ranges.length];
            for (int i = 0; i < ranges.length; ++i) {
                this.ranges[i] = new Range(new Integer(ranges[i][0]), new Integer(ranges[i][1]));
            }
        }
        this.setEditable(isEditable);
        if (value != null) {
            if (!this.checkRange(value)) throw new RuntimeException("Value out of range");
            this.value = String.valueOf(value);
            return;
        } else {
            this.value = null;
        }
    }

    private boolean checkRange(int theValue) {
        if (this.ranges == null) {
            return true;
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            int lower = (Integer)this.ranges[i].getLower();
            int higher = (Integer)this.ranges[i].getHigher();
            if (theValue < lower || theValue > higher) continue;
            return true;
        }
        return false;
    }

    public Range[] getRange() {
        return this.ranges;
    }

    public Object getValue() {
        return this;
    }

    public Object getCellValue() {
        if (this.value != null) {
            return new Integer(this.value);
        }
        return null;
    }

    public String toString() {
        if (this.value != null) {
            return this.value;
        }
        return " ";
    }

    public void setValueMandatory(boolean valueMandatory) {
        this.valueMandatory = valueMandatory;
    }

    public boolean setValue(Object value) {
        int intValue = 0;
        if (value instanceof Integer) {
            intValue = (Integer)value;
        } else if (value instanceof String) {
            try {
                if (((String)value).length() > 0) {
                    intValue = Integer.parseInt((String)value);
                } else {
                    value = null;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (value == null) {
            if (this.valueMandatory) {
                return false;
            }
            this.value = null;
            return true;
        }
        if (!this.checkRange(intValue)) {
            return false;
        }
        this.value = Integer.toString(intValue);
        return true;
    }

    public int compareTo(Object value) {
        if (this.value != null && ((IntegerTableCell)value).getCellValue() != null) {
            return Integer.valueOf(this.value).compareTo(Integer.valueOf(value.toString()));
        }
        if (this.value != null && ((IntegerTableCell)value).getCellValue() == null) {
            return 1;
        }
        if (this.value == null && ((IntegerTableCell)value).getCellValue() == null) {
            return 0;
        }
        return -1;
    }
}

