/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.LogManager;
import se.ericsson.cello.support.logging.LogRecord;
import se.ericsson.cello.support.logging.SimpleFormatter;
import se.ericsson.cello.support.logging.StreamHandler;

public class ConsoleHandler
extends StreamHandler {
    private void configure() {
        LogManager manager = LogManager.getLogManager();
        String cname = ConsoleHandler.class.getName();
        Level handlerLevel = manager.getLevelProperty(cname + ".level", Level.INFO);
        System.out.println(" Level of consoler handler set to : " + handlerLevel);
        this.setLevel(handlerLevel);
        this.setFilter(manager.getFilterProperty(cname + ".filter", null));
        this.setFormatter(manager.getFormatterProperty(cname + ".formatter", new SimpleFormatter()));
        try {
            this.setEncoding(manager.getStringProperty(cname + ".encoding", null));
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
    }

    public ConsoleHandler() {
        this.sealed = false;
        this.configure();
        this.sealed = true;
        this.setOutputStream(System.err);
    }

    public void publish(LogRecord record) {
        super.publish(record);
        this.flush();
    }

    public void close() {
        this.flush();
    }
}

