/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.util.Enumeration;
import java.util.Vector;
import se.ericsson.cello.support.logging.Filter;
import se.ericsson.cello.support.logging.LogManager;
import se.ericsson.cello.support.logging.LogRecord;

public class LDNFilter
implements Filter {
    private static Vector ldnList;
    private static Vector wildCardList;

    private boolean isInWildCardList(String ldn) {
        boolean returnValue = false;
        Enumeration e = wildCardList.elements();
        while (e.hasMoreElements()) {
            if (!ldn.startsWith((String)e.nextElement())) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public boolean isLoggable(LogRecord record) {
        boolean loggable = false;
        if (!ldnList.isEmpty() || !wildCardList.isEmpty()) {
            Object[] params = record.getParameters();
            if (params == null || params.length == 0) {
                loggable = true;
            } else {
                String ldn = params[0].toString();
                if (ldnList.contains(ldn)) {
                    loggable = true;
                } else if (this.isInWildCardList(ldn)) {
                    loggable = true;
                }
            }
        } else {
            loggable = true;
        }
        return loggable;
    }

    static {
        LogManager manager = LogManager.getLogManager();
        String hands = manager.getProperty("filter.LDNFilter.ldn");
        hands = hands.trim();
        int ix = 0;
        ldnList = new Vector();
        wildCardList = new Vector();
        while (ix < hands.length()) {
            int end;
            for (end = ix; end < hands.length() && !Character.isWhitespace(hands.charAt(end)) && hands.charAt(end) != ';'; ++end) {
            }
            String word = hands.substring(ix, end);
            ix = end + 1;
            if ((word = word.trim()).length() == 0) continue;
            if (word.endsWith("*")) {
                wildCardList.add(word.substring(0, word.length() - 1));
                continue;
            }
            ldnList.add(word);
        }
    }
}

