/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.logging.Filter;
import se.ericsson.cello.support.logging.Formatter;
import se.ericsson.cello.support.logging.Handler;
import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.LogRecord;
import se.ericsson.cello.support.logging.Logger;
import se.ericsson.cello.support.logging.LoggingPermission;
import sun.security.action.GetPropertyAction;

public class LogManager {
    private static LogManager manager;
    private Vector handlers = new Vector();
    private Properties props = new LogProperties();
    private PropertyChangeSupport changes = new PropertyChangeSupport(LogManager.class);
    private LogNode root = new LogNode();
    private Permission ourPermission = new LoggingPermission("control", null);

    static void initialize() {
        String cname = null;
        try {
            GetPropertyAction a = new GetPropertyAction("se.ericsson.cello.support.logging.manager");
            cname = AccessController.doPrivileged(a);
            if (cname != null) {
                Class<?> clz = Class.forName(cname);
                manager = (LogManager)clz.newInstance();
            }
        }
        catch (Exception ex) {
            System.err.println("Could not load Logmanager \"" + cname + "\"");
            ex.printStackTrace();
        }
        if (manager == null) {
            manager = new LogManager();
        }
        try {
            manager.readConfiguration();
        }
        catch (Exception ex) {
            System.err.println("Can't read logging configuration:");
            System.err.println("" + ex);
        }
    }

    protected LogManager() {
    }

    public static LogManager getLogManager() {
        return manager;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) throws SecurityException {
        this.checkAccess();
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) throws SecurityException {
        this.checkAccess();
        this.changes.removePropertyChangeListener(l);
    }

    public synchronized boolean addLogger(Logger l) {
        l.getName().length();
        LogNode node = this.findNode(l.getName(), true);
        if (node.getLogger() == null) {
            node.setLogger(l);
            return true;
        }
        return false;
    }

    private LogNode findNode(String name, boolean create) {
        if (name == null || name.equals("")) {
            return this.root;
        }
        LogNode node = this.root;
        while (name.length() > 0) {
            LogNode child;
            String head;
            int ix = name.indexOf(".");
            if (ix > 0) {
                head = name.substring(0, ix);
                name = name.substring(ix + 1);
            } else {
                head = name;
                name = "";
            }
            if (node.children == null) {
                if (!create) {
                    return null;
                }
                node.children = new HashMap();
            }
            if ((child = (LogNode)node.children.get(head)) == null) {
                if (!create) {
                    return null;
                }
                child = new LogNode();
                node.children.put(head, child);
                child.level = node.level;
            }
            node = child;
        }
        return node;
    }

    public Logger getLogger(String name) {
        LogNode node = this.findNode(name, false);
        if (node == null) {
            return null;
        }
        return node.getLogger();
    }

    public synchronized void setLevel(String name, Level level) throws SecurityException {
        if (level == null || name == null) {
            throw new NullPointerException();
        }
        this.checkAccess();
        LogNode node = this.findNode(name, true);
        node.walkAndSet(level);
    }

    public synchronized Level getLevel(String name) {
        LogNode node = this.root;
        Level level = this.root.level;
        while (node != null && name.length() > 0) {
            String head;
            int ix = name.indexOf(".");
            if (ix > 0) {
                head = name.substring(0, ix);
                name = name.substring(ix + 1);
            } else {
                head = name;
                name = "";
            }
            if (node.children == null || (node = (LogNode)node.children.get(head)) == null) break;
            level = node.level;
        }
        return level;
    }

    public synchronized void addGlobalHandler(Handler handler) throws SecurityException {
        handler.getClass();
        this.checkAccess();
        this.handlers.add(handler);
    }

    public synchronized void removeGlobalHandler(Handler handler) throws SecurityException {
        this.checkAccess();
        this.handlers.remove(handler);
    }

    public synchronized void removeAllGlobalHandlers() throws SecurityException {
        this.checkAccess();
        this.handlers.clear();
    }

    public synchronized Handler[] getGlobalHandlers() throws SecurityException {
        this.checkAccess();
        Object[] result = new Handler[this.handlers.size()];
        this.handlers.copyInto(result);
        return result;
    }

    public synchronized Enumeration getLoggerNames() {
        return new LogEnumerator(this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration() throws IOException, SecurityException {
        InputStream in;
        String fname;
        this.checkAccess();
        this.reset();
        String cname = EmasSystemProperties.getProperty("se.ericsson.cello.support.logging.config.class");
        if (cname != null) {
            try {
                Class<?> clz = Class.forName(cname);
                clz.newInstance();
                return;
            }
            catch (Exception ex) {
                System.err.println("Logging configuration class \"" + cname + "\" failed");
                System.err.println("" + ex);
            }
        }
        if ((fname = EmasSystemProperties.getProperty("se.ericsson.cello.support.logging.config.file")) != null) {
            in = new FileInputStream(fname);
        } else {
            fname = "/se/ericsson/cello/support/logging/resources/logging.properties";
            in = this.getClass().getResourceAsStream(fname);
        }
        BufferedInputStream bin = new BufferedInputStream(in);
        try {
            this.readConfiguration(bin);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void reset() {
        this.props = new LogProperties();
        while (this.handlers.size() > 0) {
            Handler h = (Handler)this.handlers.elementAt(0);
            this.removeGlobalHandler(h);
            try {
                h.close();
            }
            catch (Exception exception) {}
        }
    }

    private String[] parseClassNames(String propertyName) {
        String hands = this.props.getProperty(propertyName, "");
        hands = hands.trim();
        int ix = 0;
        Vector<String> result = new Vector<String>();
        while (ix < hands.length()) {
            int end;
            for (end = ix; end < hands.length() && !Character.isWhitespace(hands.charAt(end)) && hands.charAt(end) != ','; ++end) {
            }
            String word = hands.substring(ix, end);
            ix = end + 1;
            if ((word = word.trim()).length() == 0) continue;
            result.add(word);
        }
        return result.toArray(new String[result.size()]);
    }

    public void readConfiguration(InputStream ins) throws IOException, SecurityException {
        Class<?> clz;
        String word;
        int i;
        this.checkAccess();
        this.reset();
        this.props.load(ins);
        String[] names = this.parseClassNames("handlers");
        for (i = 0; i < names.length; ++i) {
            word = names[i];
            try {
                clz = Class.forName(word);
                Handler h = (Handler)clz.newInstance();
                this.addGlobalHandler(h);
                try {
                    String levs = this.props.getProperty(word + ".level");
                    if (levs == null) continue;
                    h.setLevel(Level.parse(levs));
                }
                catch (Exception ex) {}
                continue;
            }
            catch (Exception ex) {
                System.err.println("Can't load log handler \"" + word + "\"");
                System.err.println("" + ex);
                ex.printStackTrace();
            }
        }
        names = this.parseClassNames("config");
        for (i = 0; i < names.length; ++i) {
            word = names[i];
            try {
                clz = Class.forName(word);
                clz.newInstance();
                continue;
            }
            catch (Exception ex) {
                System.err.println("Can't load config class \"" + word + "\"");
                System.err.println("" + ex);
            }
        }
        this.changes.firePropertyChange(null, null, null);
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    String getStringProperty(String name, String defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    int getIntProperty(String name, int defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    Level getLevelProperty(String name, Level defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    Filter getFilterProperty(String name, Filter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = Class.forName(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }

    Formatter getFormatterProperty(String name, Formatter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = Class.forName(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }

    public void publish(LogRecord record) {
        for (int i = 0; i < this.handlers.size(); ++i) {
            Handler h = (Handler)this.handlers.elementAt(i);
            h.publish(record);
        }
    }

    public void flush() {
        for (int i = 0; i < this.handlers.size(); ++i) {
            Handler h = (Handler)this.handlers.elementAt(i);
            h.flush();
        }
    }

    public static void dispose() {
        if (manager != null) {
            manager.cleanup();
            manager = null;
        }
    }

    public void cleanup() {
        this.flush();
        this.handlers.clear();
        this.handlers = null;
        this.props = null;
        this.root.dispose();
        this.root = null;
    }

    public void checkAccess() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        sm.checkPermission(this.ourPermission);
    }

    static {
        if (System.getSecurityManager() == null) {
            LogManager.initialize();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    LogManager.initialize();
                    return null;
                }
            });
        }
    }

    private class LogProperties
    extends Properties {
        private LogProperties() {
        }

        public Object put(Object keyObject, Object valueObject) {
            Level level;
            Object result = super.put(keyObject, valueObject);
            String key = (String)keyObject;
            if (!key.endsWith(".level")) {
                return result;
            }
            int ix = key.length() - 6;
            String name = key.substring(0, ix);
            String value = (String)valueObject;
            try {
                level = Level.parse(value);
            }
            catch (Exception ex) {
                System.err.println("Bad level value for property: " + key);
                return result;
            }
            LogManager.this.setLevel(name, level);
            return result;
        }
    }

    private static class LogEnumerator
    implements Enumeration {
        private Vector names = new Vector();
        private int index = 0;

        private LogEnumerator(LogNode root) {
            this.addTree(root, "");
        }

        private void addTree(LogNode node, String name) {
            if (node.getLogger() != null) {
                this.names.addElement(name);
            }
            if (node.children == null) {
                return;
            }
            for (String key : node.children.keySet()) {
                LogNode child = (LogNode)node.children.get(key);
                String cname = name.length() == 0 ? key : name + "." + key;
                this.addTree(child, cname);
            }
        }

        public boolean hasMoreElements() {
            return this.index < this.names.size();
        }

        public Object nextElement() {
            if (this.index >= this.names.size()) {
                throw new NoSuchElementException();
            }
            Object result = this.names.elementAt(this.index);
            ++this.index;
            return result;
        }
    }

    private static class LogNode {
        HashMap children;
        WeakReference loggerRef;
        Level level = Level.INFO;

        private LogNode() {
        }

        Logger getLogger() {
            if (this.loggerRef == null) {
                return null;
            }
            return (Logger)this.loggerRef.get();
        }

        void setLogger(Logger l) {
            this.loggerRef = new WeakReference<Logger>(l);
        }

        void walkAndSet(Level level) {
            this.level = level;
            Logger l = this.getLogger();
            if (l != null) {
                l.setLevel(level);
            }
            if (this.children == null) {
                return;
            }
            for (LogNode node : this.children.values()) {
                node.walkAndSet(level);
            }
        }

        public void dispose() {
            for (LogNode node : this.children.values()) {
                node.clean();
            }
            this.clean();
        }

        public void clean() {
            if (this.children != null) {
                this.children.clear();
            }
            this.loggerRef = null;
            this.children = null;
        }
    }

    private class Cleaner
    extends Thread {
        private Cleaner() {
        }

        public void run() {
            Handler[] handlers = new Handler[]{};
            try {
                handlers = LogManager.this.getGlobalHandlers();
                LogManager.this.removeAllGlobalHandlers();
            }
            catch (Exception ex) {
                // empty catch block
            }
            for (int i = 0; i < handlers.length; ++i) {
                try {
                    System.out.println("Closing handler: " + i);
                    handlers[i].close();
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            handlers = null;
        }
    }
}

