/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import se.ericsson.cello.support.logging.Formatter;
import se.ericsson.cello.support.logging.Handler;
import se.ericsson.cello.support.logging.LogRecord;

public class XMLFormatter
extends Formatter {
    private void a2(StringBuffer sb, int x) {
        if (x < 10) {
            sb.append('0');
        }
        sb.append(x);
    }

    private void appendISO8601(StringBuffer sb, long millis) {
        Date date = new Date(millis);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        sb.append(sdf.format(date));
    }

    public String format(LogRecord record) {
        StringBuffer sb;
        block13: {
            sb = new StringBuffer(500);
            sb.append("<record>\n");
            sb.append("  <date>");
            this.appendISO8601(sb, record.getMillis());
            sb.append("</date>\n");
            sb.append("  <millis>");
            sb.append(record.getMillis());
            sb.append("</millis>\n");
            sb.append("  <sequence>");
            sb.append(record.getSequenceNumber());
            sb.append("</sequence>\n");
            sb.append("  <logger>");
            sb.append(record.getLoggerName());
            sb.append("</logger>\n");
            sb.append("  <level>");
            sb.append(record.getLevel().toString());
            sb.append("</level>\n");
            if (record.getSourceClassName() != null) {
                sb.append("  <class>");
                sb.append(record.getSourceClassName());
                sb.append("</class>\n");
            }
            if (record.getSourceMethodName() != null) {
                sb.append("  <method>");
                sb.append(record.getSourceMethodName());
                sb.append("</method>\n");
            }
            sb.append("  <thread>");
            sb.append(record.getThreadID());
            sb.append("</thread>\n");
            if (record.getMessage() != null) {
                String message = this.formatMessage(record);
                sb.append("  <message>");
                sb.append(message);
                sb.append("</message>");
                sb.append("\n");
            }
            ResourceBundle bundle = record.getResourceBundle();
            try {
                if (bundle == null || bundle.getString(record.getMessage()) == null) break block13;
                sb.append("  <key>");
                sb.append(record.getMessage());
                sb.append("</key>\n");
                sb.append("  <catalog>");
                sb.append(record.getResourceBundleName());
                sb.append("</catalog>\n");
                Object[] parameters = record.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    sb.append("  <param>");
                    try {
                        sb.append(parameters[i].toString());
                    }
                    catch (Exception ex) {
                        sb.append("???");
                    }
                    sb.append("</param>\n");
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (record.getThrown() != null) {
            sb.append("  <exception>\n");
            try {
                int start;
                int end;
                Throwable th = record.getThrown();
                sb.append("    <message>");
                sb.append(th.toString());
                sb.append("</message>\n");
                String stack = record.getThrownBackTrace();
                int ix = 0;
                while (ix < stack.length() && (ix = stack.indexOf("at ", ix)) >= 0 && (end = stack.indexOf("(", start = ix + 3)) >= 0) {
                    int dot = stack.lastIndexOf(".", end);
                    sb.append("    <frame>\n");
                    sb.append("      <class>");
                    sb.append(stack.substring(start, dot));
                    sb.append("</class>\n");
                    sb.append("      <method>");
                    sb.append(stack.substring(dot + 1, end));
                    sb.append("</method>\n");
                    start = stack.indexOf(":", end);
                    end = stack.indexOf(")", end);
                    if (start > 0 && start < end) {
                        sb.append("      <line>");
                        sb.append(stack.substring(start + 1, end));
                        sb.append("</line>\n");
                    }
                    sb.append("    </frame>\n");
                    ix = end;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            sb.append("  </exception>\n");
        }
        sb.append("</record>\n");
        return sb.toString();
    }

    public String getHead(Handler h) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"");
        String encoding = h.getEncoding();
        if (encoding != null && encoding.equals("UTF8")) {
            encoding = "UTF-8";
        }
        if (encoding != null) {
            sb.append(" encoding=\"");
            sb.append(encoding);
            sb.append("\"");
        }
        sb.append(" standalone=\"no\"?>\n");
        sb.append("<!DOCTYPE log SYSTEM \"file:logger.dtd\">\n");
        sb.append("<log>\n");
        return sb.toString();
    }

    public String getTail(Handler h) {
        return "</log>\n";
    }
}

