/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.proxy.action;

import org.omg.CORBA.UserException;
import org.threegppsa5.AlarmIRPConstDefs.AlarmInformationIdSeqHolder;
import org.threegppsa5.AlarmIRPSystem.InvalidParameter;
import org.threegppsa5.AlarmIRPSystem.OperationNotSupported;
import org.threegppsa5.AlarmIRPSystem.ParameterNotSupported;
import org.threegppsa5.AlarmIRPSystem.UnacknowledgeAlarms;
import org.threegppsa5.AlarmIRPSystem._AlarmIRPOperations;
import org.threegppsa5.CommonIRPConstDefs.Signal;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractCorbaRequest;
import se.ericsson.cello.support.proxy.AlarmCorbaInterface;

public class UnAcknowledgeAlarmsCorbaCall
extends AbstractCorbaRequest {
    private _AlarmIRPOperations irpRef;
    private Signal result = null;
    private String[] setackidlist = null;
    private String setackuserid = null;
    private AlarmCorbaInterface myCorbaInterface = null;

    public UnAcknowledgeAlarmsCorbaCall(AlarmCorbaInterface corbaInterface, _AlarmIRPOperations irpRef, String[] idlist, String userId) {
        this.irpRef = irpRef;
        this.setackidlist = idlist;
        this.setackuserid = userId;
        this.myCorbaInterface = corbaInterface;
    }

    protected void invoke() throws UserException {
        String in_ids = "";
        in_ids = this.setackidlist[0];
        for (int i = 1; i < this.setackidlist.length; ++i) {
            in_ids = in_ids + ", " + this.setackidlist[i];
        }
        Log.log(6, "Unacknowlege alarms:\nAlarm ids: " + in_ids);
        AlarmInformationIdSeqHolder ununackedAlarms = new AlarmInformationIdSeqHolder();
        ununackedAlarms.value = null;
        this.result = this.irpRef.unacknowledge_alarms(this.setackidlist, this.setackuserid, "", ununackedAlarms);
    }

    protected void handleSuccesful() {
        this.myCorbaInterface.setStatus(0);
        if (this.result.equals(Signal.Failure)) {
            this.myCorbaInterface.showErrorDialog(24);
        }
        if (this.result.equals(Signal.PartialFailure)) {
            this.myCorbaInterface.showErrorDialog(25);
        }
    }

    protected boolean handleUserException(UserException ue) {
        this.myCorbaInterface.setStatus(0);
        if (ue instanceof UnacknowledgeAlarms) {
            Log.logError("Unacknowledge Alarms failed", ue);
            this.myCorbaInterface.showErrorDialog(24);
        } else if (ue instanceof ParameterNotSupported) {
            Log.logError("Unacknowledge Alarms failed", ue);
            this.myCorbaInterface.showErrorDialog(26);
        } else if (ue instanceof OperationNotSupported) {
            Log.logError("Unacknowledge Alarms failed", ue);
            this.myCorbaInterface.showErrorDialog(27);
        } else if (ue instanceof InvalidParameter) {
            Log.logError("Unacknowledge Alarms failed", ue);
            this.myCorbaInterface.showErrorDialog(27);
        } else {
            Log.logError("Unacknowledge Alarms failed", ue);
            this.myCorbaInterface.showErrorDialog(14);
        }
        return false;
    }
}

