/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmreporter.proxy;

import enea.ose.system.AttachSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import se.ericsson.cello.pmreporter.PmReporterAdmin;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterDeregisterCounterNamesCfm;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterDeregisterCounterNamesReq;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterDeregisterLdnsCfm;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterDeregisterLdnsReq;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterInitiateServiceCfm;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterInitiateServiceReq;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterNotificationSubscribeReq;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterPushXMLInd;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterRegisterCounterNamesCfm;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterRegisterCounterNamesReq;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterRegisterLdnsCfm;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterRegisterLdnsReq;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterRegisterPdfCountersCfm;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterRegisterPdfCountersReq;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterSetFilePathCfm;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterSetFilePathReq;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterSetMaxNoOfFilesCfm;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterSetMaxNoOfFilesReq;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterSetMibPrefixCfm;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterSetMibPrefixReq;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterSetNESwVersionCfm;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterSetNESwVersionReq;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterSetNEUserNameCfm;
import se.ericsson.cello.pmreporter.proxy.OmsPmReporterSetNEUserNameReq;
import se.ericsson.cello.pms.generic.PmReporterRecoveryHandler;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;

public class PmReporterProxy
implements SubscriptionObserver {
    private SignalPort signalPort = PortManager.instance();
    private static OseProcess op = null;
    private static final String PMR_SERVICE_NAME = "Oms_pm_reporter_service";
    private static final int PV_FIRST = 1;
    private static final int PV_SECOND = 1;
    private static final int PV_THIRD = 1;
    private static final int OMS_PMR_OK = 0;
    private static final int OMS_PMR_INIT_SERVICE_CFM = 1;
    private static boolean initiated = false;
    private static int MAX_NO_OF_RETRIES = 5;
    public static final int REGISTER = 0;
    public static final int DEREGISTER = 1;
    private static PmReporterProxy instance;
    private static final int TRACEGROUP = 8;
    private static final int CPP_MAX_NUMBER_OF_COUNTERS_IN_SIGNAL = 200;
    private static final int CPP_MAX_NUMBER_OF_LDNS_IN_SIGNAL = 50;
    private static final int RECEIVE_TIMEOUT = 30000;
    private PmReporterRecoveryHandler recoveryHandler = null;
    private boolean recoveryRequired = false;
    private String recoveryMibPrefix = "";
    private String recoveryFilePath = "";
    private int recoveryMaxNoOfFiles = 0;
    private String recoveryNeUserName = "";
    private String recoveryNESoftwareVersion = "";

    public static PmReporterProxy getInstance() {
        if (instance == null) {
            instance = new PmReporterProxy();
        }
        return instance;
    }

    private PmReporterProxy() {
        OseNameServer.addSubscriptionObserver((String)PMR_SERVICE_NAME, (SubscriptionObserver)this);
        this.recoveryMibPrefix = "";
        this.recoveryFilePath = "";
        this.recoveryMaxNoOfFiles = 0;
        this.recoveryNeUserName = "";
        this.recoveryNESoftwareVersion = "";
    }

    public synchronized void serviceAdded(String string) {
        MessageLog.trace((int)8, this.getClass(), (String)"serviceAdded = OMS_PM_REPORTER_SERVICE");
        if (op != null) {
            if (op.equals((Object)OseNameServer.lookup((String)PMR_SERVICE_NAME))) {
                MessageLog.trace((int)8, this.getClass(), (String)("In serviceAdded(). Current op = " + op + "equals new op = " + OseNameServer.lookup((String)PMR_SERVICE_NAME)));
                return;
            }
        }
        if (!initiated) {
            initiated = this.init();
            if (initiated) {
                MessageLog.trace((int)8, this.getClass(), (String)"init() called successfully.");
            } else {
                MessageLog.trace((int)8, this.getClass(), (String)"init() returned false, retrying.");
                initiated = this.retryNegotiation();
                if (!initiated) {
                    MessageLog.traceError(this.getClass(), (String)"Failed to intiate PmReporter service.");
                }
            }
        }
        if (initiated) {
            if (this.recoveryRequired) {
                if (this.recoveryHandler != null) {
                    this.sendRecoveryData();
                    MessageLog.trace((int)8, this.getClass(), (String)"Performing Pmr recovery");
                    this.recoveryHandler.performPmrRecovery();
                } else {
                    MessageLog.info(this.getClass(), (String)"No recovery handler instance");
                }
            } else {
                MessageLog.trace((int)8, this.getClass(), (String)"Setting recoveryRequired to true");
                this.recoveryRequired = true;
            }
        }
    }

    private synchronized void sendRecoveryData() {
        MessageLog.trace((int)8, this.getClass(), (String)"sendRecoveryData()");
        this.setMibPrefix(this.recoveryMibPrefix);
        this.setFilePath(this.recoveryFilePath);
        this.setMaxNoOfFiles(this.recoveryMaxNoOfFiles);
        this.setNeUserName(this.recoveryNeUserName);
        this.setNESoftwareVersion(this.recoveryNESoftwareVersion);
    }

    public synchronized void serviceRemoved(String string) {
        block3: {
            block2: {
                MessageLog.trace((int)8, this.getClass(), (String)"serviceRemoved: Oms_pm_reporter_service");
                if (op == null) break block2;
                if (op.equals((Object)OseNameServer.lookup((String)PMR_SERVICE_NAME))) break block3;
            }
            op = null;
            PmReporterProxy.setInitiated(false);
        }
    }

    private static void setInitiated(boolean bl) {
        initiated = bl;
    }

    private synchronized boolean init() {
        boolean bl = true;
        OseProcess oseProcess = null;
        oseProcess = OseNameServer.lookup((String)PMR_SERVICE_NAME);
        op = oseProcess;
        MessageLog.trace((int)8, this.getClass(), (String)("In init(), op = : " + op));
        if (oseProcess == null) {
            MessageLog.trace((int)8, this.getClass(), (String)"init(), op == null");
            bl = false;
        } else {
            bl = this.sendOmsPmReporterInitiateServiceReq();
            if (bl) {
                this.sendOmsPmReporterNotificationSubscribeReq();
            }
        }
        return bl;
    }

    private synchronized boolean retryNegotiation() {
        MessageLog.trace((int)8, this.getClass(), (String)"In retryNegotiation()");
        boolean bl = this.init();
        for (int i = 0; !bl && i < MAX_NO_OF_RETRIES; ++i) {
            try {
                Thread.sleep(5000L);
                bl = this.init();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return bl;
    }

    public void registerRecoveryHandler(PmReporterRecoveryHandler pmReporterRecoveryHandler) {
        this.recoveryHandler = pmReporterRecoveryHandler;
    }

    protected boolean sendOmsPmReporterInitiateServiceReq() {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        OmsPmReporterInitiateServiceReq omsPmReporterInitiateServiceReq = new OmsPmReporterInitiateServiceReq(1, 1, 1);
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)omsPmReporterInitiateServiceReq, (Class)OmsPmReporterInitiateServiceCfm.class, (int)30000);
        if (signal != null) {
            if (signal instanceof OmsPmReporterInitiateServiceCfm) {
                MessageLog.trace((int)8, this.getClass(), (String)(" sendOmsPmReporterInitiateServiceReq() confirmed, pv = : " + ((OmsPmReporterInitiateServiceCfm)signal).getPreferredPV()));
                n2 = ((OmsPmReporterInitiateServiceCfm)signal).getPreferredPV();
                n = ((OmsPmReporterInitiateServiceCfm)signal).getResult();
                if (n != 1) {
                    bl = false;
                    MessageLog.trace((int)8, this.getClass(), (String)(" sendOmsPmReporterInitiateServiceReq(), received result = : " + ((OmsPmReporterInitiateServiceCfm)signal).getResult() + " ,preferred PV = : " + n2));
                }
            } else if (signal instanceof AttachSignal) {
                bl = false;
                MessageLog.trace((int)8, this.getClass(), (String)" sendOmsPmReporterInitiateServiceReq(), receiver process terminated: Oms_pm_reporter_service");
            } else {
                MessageLog.info(this.getClass(), (String)(" sendOmsPmReporterInitiateServiceReq(), received rspSig:  " + signal.getClass()));
                bl = false;
            }
        } else {
            MessageLog.info(this.getClass(), (String)" sendOmsPmReporterInitiateServiceReq(). No response signal, rspSig == null.");
            bl = false;
        }
        return bl;
    }

    private void sendOmsPmReporterNotificationSubscribeReq() {
        OmsPmReporterNotificationSubscribeReq omsPmReporterNotificationSubscribeReq = new OmsPmReporterNotificationSubscribeReq();
        OseProcess oseProcess = this.signalPort.getOseProcess();
        SignalHelper.sendWithSender((OseProcess)op, (OseProcess)oseProcess, (Signal)omsPmReporterNotificationSubscribeReq);
    }

    public void setNeUserName(String string) {
        MessageLog.trace((int)8, this.getClass(), (String)("setNeUserName: " + string));
        OmsPmReporterSetNEUserNameReq omsPmReporterSetNEUserNameReq = new OmsPmReporterSetNEUserNameReq(string);
        if (op == null && !this.init()) {
            return;
        }
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)omsPmReporterSetNEUserNameReq, (Class)OmsPmReporterSetNEUserNameCfm.class, (int)30000);
        if (signal != null) {
            if (signal instanceof OmsPmReporterSetNEUserNameCfm) {
                int n = ((OmsPmReporterSetNEUserNameCfm)signal).getResult();
                if (n != 0) {
                    MessageLog.trace((int)8, this.getClass(), (String)(" setNeUserName, received result = : " + n));
                }
            } else if (signal instanceof AttachSignal) {
                MessageLog.trace((int)8, this.getClass(), (String)" setNeUserName(), receiver process terminated: Oms_pm_reporter_service");
            } else {
                MessageLog.info(this.getClass(), (String)(" setNeUserName(), received rspSig:  " + signal.getClass()));
            }
        } else {
            MessageLog.info(this.getClass(), (String)" setNeUserName(). No response signal, rspSig == null");
        }
        this.recoveryNeUserName = string;
    }

    public void setNESoftwareVersion(String string) {
        MessageLog.trace((int)8, this.getClass(), (String)("setNESoftwareVersion: " + string));
        OmsPmReporterSetNESwVersionReq omsPmReporterSetNESwVersionReq = new OmsPmReporterSetNESwVersionReq(string);
        if (op == null && !this.init()) {
            return;
        }
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)omsPmReporterSetNESwVersionReq, (Class)OmsPmReporterSetNESwVersionCfm.class, (int)30000);
        if (signal != null) {
            if (signal instanceof OmsPmReporterSetNESwVersionCfm) {
                int n = ((OmsPmReporterSetNESwVersionCfm)signal).getResult();
                if (n != 0) {
                    MessageLog.trace((int)8, this.getClass(), (String)(" setNeSoftwareVersion(), received result = : " + n));
                }
            } else if (signal instanceof AttachSignal) {
                MessageLog.trace((int)8, this.getClass(), (String)" setNeSoftwareVersion(), receiver process terminated: Oms_pm_reporter_service");
            } else {
                MessageLog.info(this.getClass(), (String)(" setNeSoftwareVersion(), received rspSig:  " + signal.getClass()));
            }
        } else {
            MessageLog.info(this.getClass(), (String)" setNeSoftwareVersion(). No response signal, rspSig == null");
        }
        this.recoveryNESoftwareVersion = string;
    }

    public void setMaxNoOfFiles(int n) {
        MessageLog.trace((int)8, this.getClass(), (String)("setMaxNoOfPmFiles: " + n));
        OmsPmReporterSetMaxNoOfFilesReq omsPmReporterSetMaxNoOfFilesReq = new OmsPmReporterSetMaxNoOfFilesReq(n);
        if (op == null && !this.init()) {
            return;
        }
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)omsPmReporterSetMaxNoOfFilesReq, (Class)OmsPmReporterSetMaxNoOfFilesCfm.class, (int)30000);
        if (signal != null) {
            if (signal instanceof OmsPmReporterSetMaxNoOfFilesCfm) {
                int n2 = ((OmsPmReporterSetMaxNoOfFilesCfm)signal).getResult();
                if (n2 != 0) {
                    MessageLog.trace((int)8, this.getClass(), (String)(" setMaxNoOfFiles, received result = : " + n2));
                }
            } else if (signal instanceof AttachSignal) {
                MessageLog.trace((int)8, this.getClass(), (String)" setMaxNoOfFiles(), receiver process terminated: Oms_pm_reporter_service");
            } else {
                MessageLog.info(this.getClass(), (String)(" setMaxNoOfFiles(), received rspSig:  " + signal.getClass()));
            }
        } else {
            MessageLog.info(this.getClass(), (String)" setMaxNoOfFiles(). No response signal, rspSig == null");
        }
        this.recoveryMaxNoOfFiles = n;
    }

    public void setMibPrefix(String string) {
        MessageLog.trace((int)8, this.getClass(), (String)("setMibPrefix: " + string));
        OmsPmReporterSetMibPrefixReq omsPmReporterSetMibPrefixReq = new OmsPmReporterSetMibPrefixReq(string);
        if (op == null && !this.init()) {
            return;
        }
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)omsPmReporterSetMibPrefixReq, (Class)OmsPmReporterSetMibPrefixCfm.class, (int)30000);
        if (signal != null) {
            if (signal instanceof OmsPmReporterSetMibPrefixCfm) {
                int n = ((OmsPmReporterSetMibPrefixCfm)signal).getResult();
                if (n != 0) {
                    MessageLog.trace((int)8, this.getClass(), (String)(" setMibPrefix, received result = : " + n));
                }
            } else if (signal instanceof AttachSignal) {
                MessageLog.trace((int)8, this.getClass(), (String)" setMibPrefix(), receiver process terminated: Oms_pm_reporter_service");
            } else {
                MessageLog.info(this.getClass(), (String)(" setMibPrefix(), received rspSig:  " + signal.getClass()));
            }
        } else {
            MessageLog.info(this.getClass(), (String)" setMibPrefix(). No response signal, rspSig == null");
        }
        this.recoveryMibPrefix = string;
    }

    public void setFilePath(String string) {
        MessageLog.trace((int)8, this.getClass(), (String)("setFilePath: " + string));
        OmsPmReporterSetFilePathReq omsPmReporterSetFilePathReq = new OmsPmReporterSetFilePathReq(string);
        if (op == null && !this.init()) {
            return;
        }
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)omsPmReporterSetFilePathReq, (Class)OmsPmReporterSetFilePathCfm.class, (int)30000);
        if (signal != null) {
            if (signal instanceof OmsPmReporterSetFilePathCfm) {
                int n = ((OmsPmReporterSetFilePathCfm)signal).getResult();
                if (n != 0) {
                    MessageLog.trace((int)8, this.getClass(), (String)(" setFilePath, received result = : " + n));
                }
            } else if (signal instanceof AttachSignal) {
                MessageLog.trace((int)8, this.getClass(), (String)" setFilePath(), receiver process terminated: Oms_pm_reporter_service");
            } else {
                MessageLog.info(this.getClass(), (String)(" setFilePath(), received rspSig:  " + signal.getClass()));
            }
        } else {
            MessageLog.info(this.getClass(), (String)" setFilePath(). No response signal, rspSig == null");
        }
        this.recoveryFilePath = string;
    }

    public void updateCounterNames(int n, int n2, int n3, int[] nArray, String[] stringArray) {
        int n4;
        int n5;
        MessageLog.trace((int)8, this.getClass(), (String)("updateCounterNames: length = " + nArray.length));
        String[] stringArray2 = new String[200];
        int[] nArray2 = new int[200];
        int n6 = nArray.length / 200 + 1;
        for (n5 = 0; n5 < n6 - 1; ++n5) {
            for (n4 = 0; n4 < 200; ++n4) {
                nArray2[n4] = nArray[n4 + n5 * 200];
                stringArray2[n4] = stringArray[n4 + n5 * 200];
            }
            if (n == 0) {
                this.sendOmsPmReporterRegisterCounterNamesReq(n2, n3, nArray2, stringArray2);
                continue;
            }
            if (n != 1) continue;
            this.sendOmsPmReporterDeregisterCounterNamesReq(n2, n3, nArray2, stringArray2);
        }
        n5 = (n6 - 1) * 200;
        n4 = stringArray.length - n5;
        if (n4 != 0) {
            nArray2 = new int[n4];
            stringArray2 = new String[n4];
            for (int i = 0; i < n4; ++i) {
                nArray2[i] = nArray[i + n5];
                stringArray2[i] = stringArray[i + n5];
            }
            if (n == 0) {
                this.sendOmsPmReporterRegisterCounterNamesReq(n2, n3, nArray2, stringArray2);
            } else if (n == 1) {
                this.sendOmsPmReporterDeregisterCounterNamesReq(n2, n3, nArray2, stringArray2);
            }
        }
    }

    private void sendOmsPmReporterRegisterCounterNamesReq(int n, int n2, int[] nArray, String[] stringArray) {
        OmsPmReporterRegisterCounterNamesReq omsPmReporterRegisterCounterNamesReq = new OmsPmReporterRegisterCounterNamesReq(n, n2, nArray, stringArray);
        if (op == null && !this.init()) {
            return;
        }
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)omsPmReporterRegisterCounterNamesReq, (Class)OmsPmReporterRegisterCounterNamesCfm.class, (int)30000);
        if (signal != null) {
            if (signal instanceof OmsPmReporterRegisterCounterNamesCfm) {
                int n3 = ((OmsPmReporterRegisterCounterNamesCfm)signal).getResult();
                if (n3 != 0) {
                    MessageLog.trace((int)8, this.getClass(), (String)(" registerCounterNames, received result = : " + n3));
                }
            } else if (signal instanceof AttachSignal) {
                MessageLog.trace((int)8, this.getClass(), (String)" registerCounterNames(), receiver process terminated: Oms_pm_reporter_service");
            } else {
                MessageLog.info(this.getClass(), (String)(" registerCounterNames(), received rspSig:  " + signal.getClass()));
            }
        } else {
            MessageLog.info(this.getClass(), (String)" registerCounterNames(). No response signal, rspSig == null");
        }
    }

    private void sendOmsPmReporterDeregisterCounterNamesReq(int n, int n2, int[] nArray, String[] stringArray) {
        OmsPmReporterDeregisterCounterNamesReq omsPmReporterDeregisterCounterNamesReq = new OmsPmReporterDeregisterCounterNamesReq(n, n2, nArray, stringArray);
        if (op == null && !this.init()) {
            return;
        }
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)omsPmReporterDeregisterCounterNamesReq, (Class)OmsPmReporterDeregisterCounterNamesCfm.class, (int)30000);
        if (signal != null) {
            if (signal instanceof OmsPmReporterDeregisterCounterNamesCfm) {
                int n3 = ((OmsPmReporterDeregisterCounterNamesCfm)signal).getResult();
                if (n3 != 0) {
                    MessageLog.trace((int)8, this.getClass(), (String)(" deregisterCounterNames, received result = : " + n3));
                }
            } else if (signal instanceof AttachSignal) {
                MessageLog.trace((int)8, this.getClass(), (String)" deregisterCounterNames(), receiver process terminated: Oms_pm_reporter_service");
            } else {
                MessageLog.info(this.getClass(), (String)(" deregisterCounterNames(), received rspSig:  " + signal.getClass()));
            }
        } else {
            MessageLog.info(this.getClass(), (String)" deregisterCounterNames(). No response signal, rspSig == null");
        }
    }

    public void updateLdns(int n, int n2, int n3, int[] nArray, String[] stringArray) {
        int n4;
        int n5;
        MessageLog.trace((int)8, this.getClass(), (String)("updateLdns: length = " + nArray.length));
        String[] stringArray2 = new String[50];
        int[] nArray2 = new int[50];
        int n6 = nArray.length / 50 + 1;
        for (n5 = 0; n5 < n6 - 1; ++n5) {
            for (n4 = 0; n4 < 50; ++n4) {
                nArray2[n4] = nArray[n4 + n5 * 50];
                stringArray2[n4] = stringArray[n4 + n5 * 50];
            }
            if (n == 0) {
                this.sendOmsPmReporterRegisterLdnsReq(n2, n3, nArray2, stringArray2);
                continue;
            }
            if (n != 1) continue;
            this.sendOmsPmReporterDeregisterLdnsReq(n2, n3, nArray2, stringArray2);
        }
        n5 = (n6 - 1) * 50;
        n4 = stringArray.length - n5;
        if (n4 != 0) {
            nArray2 = new int[n4];
            stringArray2 = new String[n4];
            for (int i = 0; i < n4; ++i) {
                nArray2[i] = nArray[i + n5];
                stringArray2[i] = stringArray[i + n5];
            }
            if (n == 0) {
                this.sendOmsPmReporterRegisterLdnsReq(n2, n3, nArray2, stringArray2);
            } else if (n == 1) {
                this.sendOmsPmReporterDeregisterLdnsReq(n2, n3, nArray2, stringArray2);
            }
        }
    }

    public void sendOmsPmReporterRegisterPdfCountersReq(int n, int n2, PmReporterAdmin.PdfIndexInfo[] pdfIndexInfoArray) {
        OmsPmReporterRegisterPdfCountersReq omsPmReporterRegisterPdfCountersReq = new OmsPmReporterRegisterPdfCountersReq(n, n2, pdfIndexInfoArray);
        if (op == null && !this.init()) {
            return;
        }
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)omsPmReporterRegisterPdfCountersReq, (Class)OmsPmReporterRegisterPdfCountersCfm.class, (int)30000);
        if (signal != null) {
            if (signal instanceof OmsPmReporterRegisterPdfCountersCfm) {
                int n3 = ((OmsPmReporterRegisterPdfCountersCfm)signal).getResult();
                if (n3 != 0) {
                    MessageLog.trace((int)8, this.getClass(), (String)(" registerPdfCounters, received result = : " + n3));
                }
            } else if (signal instanceof AttachSignal) {
                MessageLog.trace((int)8, this.getClass(), (String)" registerPdfCounters(), receiver process terminated: Oms_pm_reporter_service");
            } else {
                MessageLog.info(this.getClass(), (String)(" registerPdfCounters(), received rspSig:  " + signal.getClass()));
            }
        } else {
            MessageLog.info(this.getClass(), (String)" registerPdfCounters(). No response signal, rspSig == null");
        }
    }

    public void pushXML(int n, String string) {
        OmsPmReporterPushXMLInd omsPmReporterPushXMLInd = new OmsPmReporterPushXMLInd(n, string);
        if (op == null && !this.init()) {
            return;
        }
        SignalHelper.send((OseProcess)op, (Signal)omsPmReporterPushXMLInd);
    }

    private void sendOmsPmReporterRegisterLdnsReq(int n, int n2, int[] nArray, String[] stringArray) {
        OmsPmReporterRegisterLdnsReq omsPmReporterRegisterLdnsReq = new OmsPmReporterRegisterLdnsReq(n, n2, nArray, stringArray);
        if (op == null && !this.init()) {
            return;
        }
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)omsPmReporterRegisterLdnsReq, (Class)OmsPmReporterRegisterLdnsCfm.class, (int)30000);
        if (signal != null) {
            if (signal instanceof OmsPmReporterRegisterLdnsCfm) {
                int n3 = ((OmsPmReporterRegisterLdnsCfm)signal).getResult();
                if (n3 != 0) {
                    MessageLog.trace((int)8, this.getClass(), (String)(" registerLdns, received result = : " + n3));
                }
            } else if (signal instanceof AttachSignal) {
                MessageLog.trace((int)8, this.getClass(), (String)" registerLdns(), receiver process terminated: Oms_pm_reporter_service");
            } else {
                MessageLog.info(this.getClass(), (String)(" registerLdns(), received rspSig:  " + signal.getClass()));
            }
        } else {
            MessageLog.info(this.getClass(), (String)" registerLdns(). No response signal, rspSig == null");
        }
    }

    private void sendOmsPmReporterDeregisterLdnsReq(int n, int n2, int[] nArray, String[] stringArray) {
        OmsPmReporterDeregisterLdnsReq omsPmReporterDeregisterLdnsReq = new OmsPmReporterDeregisterLdnsReq(n, n2, nArray, stringArray);
        if (op == null && !this.init()) {
            return;
        }
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)omsPmReporterDeregisterLdnsReq, (Class)OmsPmReporterDeregisterLdnsCfm.class, (int)30000);
        if (signal != null) {
            if (signal instanceof OmsPmReporterDeregisterLdnsCfm) {
                int n3 = ((OmsPmReporterDeregisterLdnsCfm)signal).getResult();
                if (n3 != 0) {
                    MessageLog.trace((int)8, this.getClass(), (String)(" deregisterLdns, received result = : " + n3));
                }
            } else if (signal instanceof AttachSignal) {
                MessageLog.trace((int)8, this.getClass(), (String)" deregisterLdns(), receiver process terminated: Oms_pm_reporter_service");
            } else {
                MessageLog.info(this.getClass(), (String)(" deregisterLdns(), received rspSig:  " + signal.getClass()));
            }
        } else {
            MessageLog.info(this.getClass(), (String)" deregisterLdns(). No response signal, rspSig == null");
        }
    }
}

