
/*
 *  COPYRIGHT
 *  ---------
 *  Ericsson AB 2008-2010 All rights reserved.
 *
 * The information in this document is the property of Ericsson.
 * Except as specifically authorized in writing by Ericsson, the
 * receiver of this document shall keep the information contained
 * herein confidential and shall protect the same in whole or in
 * part from disclosure and dissemination to third parties.
 * Disclosure and disseminations to the receiver's employees shall
 * only be made on a strict need to know basis.
 *
 *
 *  REVISION HISTORY
 *  ----------------
 *
 *  Revised: Johan Flinck 14 Feb 2008
 *  Changes: First revision.
 *
 *  Revised: 20090319 uabflik
 *  Changes: WRNae39937 - The class has been changed to create the viewlist.txt and CPPClientConfig.xml instead
 *                    of creating a listener for Forcerestore
 *
 *  Revised: 2010-09-01 ehsake
 *  Changes: HM11102 - Refactored to separate ViewFile and CPPClientConfig creation
 *
 *  Revised: 2011-04-13 Mats Hellberg
 *  Changes: HN83916
 */

package se.ericsson.cello.viewfilecreator.mao;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.Mopplet;
import se.ericsson.cello.viewfilecreator.log.Logger;
import se.ericsson.cello.viewfilecreator.mao.LoadModuleCollector.LoadModuleCollectionException;
import se.ericsson.cello.viewfilecreator.mao.ViewFileProducer;



/**
 * This is the main class for the the creating of a file that contains all jar files
 * containing views for NEX and to update the CPPClientconfig.xml.
 */
public class ViewfileCreator implements Mopplet
{




	public ViewfileCreator()
	{
	    Logger.trace(this.getClass(),"ViewfileCreator");
	}
	/**
	 * Initializes the Configuration Management Application.
	 *
	 */
	public void init()
	{
	    Logger.trace(this.getClass(),"init");
	}


	/**
	 * Starts the ViewfileCreator
	 *
	 *
	 */
	public void start()
	{
	    Logger.info(this.getClass(),"Start creating CPPClientConfig and ViewList");
		try {
			LoadModuleCollector loadModuleCollector = new LoadModuleCollector();
			ViewFileProducer viewFileProducer = new ViewFileProducer();
			CPPClientProducer cppClientProducer = new CPPClientProducer();

			ManagedObject[] loadModules = loadModuleCollector.getLoadModules();
			cppClientProducer.createCPPClient(loadModules);
			viewFileProducer.createViewFileList(loadModules);

			Logger.trace(this.getClass(),"ViewListCreator mopplet finished");
		}
		catch (NoUpException e) {
			Logger.info(this.getClass(), "No UP available. Not possible to create CPPClientConfig and ViewList");
		}
		catch (LoadModuleCollectionException e) {
		    Logger.info(this.getClass(), "Could not fetch LoadModules from Upgrade Package. Not possible to create CPPClientConfig and ViewList");
		}
		catch (CPPClientException e) {
		    Logger.info(this.getClass(), "Unable to create the CPPClientConfig file. Possible cause: The template LM is missing");
		}
		catch(Exception e)
		{
		    Logger.traceError(this.getClass(),"Unable to collect viewfile LMs",e);
		}
	}
}
