<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<!-- Identity template -->
	<xsl:template match="node() | @*">
		<xsl:copy>
			<xsl:apply-templates select="node() | @*" />
		</xsl:copy>
	</xsl:template>

	<!-- Deprecated Attributes with dtd specified default values -->
	<xsl:template match= "Cell/@cellCreated"/>
	<xsl:template match= "TmaSector/@currentLowSupervision_C"/>
	<xsl:template match= "TmaSector/@currentLowSupervision_D"/>

	
	<xsl:template match="HsdpaSettings/HsdpaSlot[1]">
		<xsl:call-template name="generate-transformed-slot-Hsdpa">
			<xsl:with-param name="all-slot-elements-set" select="../HsdpaSlot"/>
			<xsl:with-param name="output-slot-number" select="1"/>
			<xsl:with-param name="first-slot" select="10"/>
			<xsl:with-param name="second-slot" select="11"/>
		</xsl:call-template>

		<xsl:call-template name="generate-transformed-slot-Hsdpa">
			<xsl:with-param name="all-slot-elements-set" select="../HsdpaSlot"/>
			<xsl:with-param name="output-slot-number" select="2"/>
			<xsl:with-param name="first-slot" select="14"/>
			<xsl:with-param name="second-slot" select="15"/>
		</xsl:call-template>
	</xsl:template>

	<!-- Ignore hsdpa slots on index > 1 -->
	<xsl:template match="HsdpaSettings/HsdpaSlot[position() > 1]"/>
	
	<xsl:template match="EulSettings/EulSlot[1]">
		<xsl:call-template name="generate-transformed-slot-Eul">
			<xsl:with-param name="all-slot-elements-set" select="../EulSlot"/>
			<xsl:with-param name="output-slot-number" select="1"/>
			<xsl:with-param name="first-slot" select="10"/>
			<xsl:with-param name="second-slot" select="11"/>
		</xsl:call-template>

		<xsl:call-template name="generate-transformed-slot-Eul">
			<xsl:with-param name="all-slot-elements-set" select="../EulSlot"/>
			<xsl:with-param name="output-slot-number" select="2"/>
			<xsl:with-param name="first-slot" select="14"/>
			<xsl:with-param name="second-slot" select="15"/>
		</xsl:call-template>
	</xsl:template>

	<!-- Ignore eul slots on index > 1 -->
	<xsl:template match="EulSettings/EulSlot[position() > 1]"/>
	
	<xsl:template name="generate-transformed-slot-Hsdpa">
		<xsl:param name="all-slot-elements-set"/>
		<xsl:param name="output-slot-number"/>
		<xsl:param name="first-slot"/>
		<xsl:param name="second-slot"/>
		<!-- 
         | The following variables state which old slots that are to be converted into the new slot.
         | Valid values are 1, 2, 3 and 4, reperesenting slot A, B, C and D (see conversion rules)
         | Notice that these paramaters are not the actual value of the slot attributes,
         | It is only a representation of the order of the slots (as described by this pseuodo inequality):
         | slotA/@slot < slotB/@slot < slotC/@slot < slotD/@slot 
         +-->
		
		<!-- Find the index of devices in the specified bbpool -->
		<xsl:variable name="first-input-slot">
			<xsl:choose>
				<xsl:when test="$all-slot-elements-set[1]/@slot=$first-slot">1</xsl:when>
				<xsl:when test="$all-slot-elements-set[2]/@slot=$first-slot">2</xsl:when>
				<xsl:when test="$all-slot-elements-set[3]/@slot=$first-slot">3</xsl:when>
				<xsl:when test="$all-slot-elements-set[4]/@slot=$first-slot">4</xsl:when>
				<xsl:otherwise>-1</xsl:otherwise>
			</xsl:choose>
			
		</xsl:variable>
		<xsl:variable name="second-input-slot">
			<xsl:choose>
				<xsl:when test="$all-slot-elements-set[1]/@slot=$second-slot">1</xsl:when>
				<xsl:when test="$all-slot-elements-set[2]/@slot=$second-slot">2</xsl:when>
				<xsl:when test="$all-slot-elements-set[3]/@slot=$second-slot">3</xsl:when>
				<xsl:when test="$all-slot-elements-set[4]/@slot=$second-slot">4</xsl:when>
				<xsl:otherwise>-1</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		
		<!-- Get numHsCodeResources from first slot if it exists -->
		<xsl:variable name="input-resource-sum-first">
			<xsl:choose>
				<xsl:when test="$first-input-slot &gt; 0">
					<xsl:value-of select="$all-slot-elements-set[position() = $first-input-slot]/@numHsCodeResources"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="0"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!-- Get numHsCodeResources from second slot if it exists -->
		<xsl:variable name="input-resource-sum-second">
			<xsl:choose>
				<xsl:when test="$second-input-slot &gt; 0 ">
					<xsl:value-of select="$all-slot-elements-set[position() = $second-input-slot]/@numHsCodeResources"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="0"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<!-- Calculate the sum of first and second slot -->
		<xsl:variable name="input-resource-sum" select="$input-resource-sum-first + $input-resource-sum-second"/>
		
		<!-- Generate the new slot element if it should exist -->
		<xsl:if test="$input-resource-sum &gt; 0">									
			<xsl:copy>
				<xsl:attribute name="slot">
					<xsl:value-of select="$output-slot-number"/>
				</xsl:attribute>
				<xsl:attribute name="numHsCodeResources">
					<xsl:choose>
						<xsl:when test="$input-resource-sum &lt; 2">1</xsl:when>
						<xsl:when test="$input-resource-sum &lt; 4">2</xsl:when>
						<xsl:when test="$input-resource-sum &lt; 7">3</xsl:when>
						<!-- TODO Otherwise? Uncompatible value? What action? -->
					</xsl:choose>
				</xsl:attribute>
			</xsl:copy>
		</xsl:if>			
	</xsl:template>

	<xsl:template name="generate-transformed-slot-Eul">
		<xsl:param name="all-slot-elements-set"/>
		<xsl:param name="output-slot-number"/>
		<xsl:param name="first-slot"/>
		<xsl:param name="second-slot"/>

		<!-- Find the index of device in the specified bbpool -->
		<xsl:variable name="first-input-slot">
			<xsl:choose>
				<xsl:when test="$all-slot-elements-set[1]/@slot=$first-slot or $all-slot-elements-set[1]/@slot=$second-slot">1</xsl:when>
				<xsl:when test="$all-slot-elements-set[2]/@slot=$first-slot or $all-slot-elements-set[2]/@slot=$second-slot">2</xsl:when>
				<xsl:otherwise>-1</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<!-- Generate the new slot element -->
		<xsl:if test="$first-input-slot &gt; 0">
			
			<xsl:variable name="input-resource-sum">
				<xsl:value-of select="$all-slot-elements-set[position() = $first-input-slot]/@numEulResources"/>
			</xsl:variable>

			<xsl:copy>
				<xsl:attribute name="slot">
					<xsl:value-of select="$output-slot-number"/>
				</xsl:attribute>
				<xsl:attribute name="numEulResources">

					<!-- Choose min(1,$input-resource-sum) -->
					<xsl:choose>
						<xsl:when test="$input-resource-sum &lt; 1">
							<xsl:value-of select="$input-resource-sum"/>
						</xsl:when>
						<xsl:otherwise>1</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</xsl:copy>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="SectorCapability">
	 <xsl:copy>
	 <xsl:apply-templates select="node() | @*[not(name()='configurationGroup')]" />
	  <xsl:if test="@radioBuildingBlock = 'RRB02B'">
	    <xsl:attribute name="radioBuildingBlock">RBB12_1A</xsl:attribute>
	  </xsl:if>
	  <xsl:if test="@radioBuildingBlock = 'RRB03'">
	    <xsl:attribute name="radioBuildingBlock">RBB22_1A</xsl:attribute>
	  </xsl:if>	  
      <xsl:if test ="@sectorNumber &gt; 6">
	   	<xsl:attribute name="primaryPortId">
	       <xsl:value-of select="concat('BU2_',@primaryPortId)"/>
		</xsl:attribute>
		<xsl:attribute name= "cpriLineRate">Ox2</xsl:attribute>
	  </xsl:if>
	 </xsl:copy>
	</xsl:template>
</xsl:transform>
