/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.mibmgr;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.ncli.mao.MibManagerMoImpl;
import se.ericsson.cello.ncli.mibmgr.DumpFileWriter;
import se.ericsson.cello.ncli.server.logging.Log;

public class DiskCleaner {
    private Timer timer = null;
    private static DiskCleaner instance = null;
    private final long HOURS_24 = 86400000L;
    private final long DELAY = this.getDelay();

    private DiskCleaner() {
    }

    public static DiskCleaner getInstance() {
        if (instance == null) {
            instance = new DiskCleaner();
        }
        return instance;
    }

    private long getDelay() {
        try {
            return Long.parseLong(System.getProperty("se.ericsson.cello.oms.mibdump.delay", new Long(86400000L).toString()));
        }
        catch (NumberFormatException numberFormatException) {
            Log.info(this.getClass(), "non-numeric character can't be parsed to long", numberFormatException);
            return 86400000L;
        }
    }

    public void removeAllDumpFiles(String string) {
        GenericExtFilter genericExtFilter;
        String string2 = new DumpFileWriter().getPath();
        File file = new File(string2);
        File[] fileArray = file.listFiles(genericExtFilter = new GenericExtFilter(".gz"));
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].getAbsolutePath().equalsIgnoreCase(string)) continue;
                Log.trace(this.getClass(), fileArray[i].getAbsolutePath() + " deleted");
                fileArray[i].delete();
            }
        } else {
            Log.trace(this.getClass(), "No MibDump generated file found");
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public String getLatestFile() {
        GenericExtFilter genericExtFilter;
        String string = new DumpFileWriter().getPath();
        File file = new File(string);
        List<File> list = Arrays.asList(file.listFiles(genericExtFilter = new GenericExtFilter(".gz")));
        if (list.isEmpty()) {
            Log.trace(this.getClass(), "No MibDump files is in the directory");
            return null;
        }
        if (list.size() == 1) {
            return list.get(0).getAbsolutePath();
        }
        Collections.sort(list, new FileComparator());
        return list.get(list.size() - 1).getAbsolutePath();
    }

    public String getOldFile() {
        try {
            String string = MibManagerMoImpl.instance().getDumpFile(null);
            if (string == null || string.equalsIgnoreCase("")) {
                return "";
            }
            File file = new File(string);
            if (file.exists()) {
                return string;
            }
            return "";
        }
        catch (MoAccessException moAccessException) {
            return "";
        }
    }

    public void startScheduleClean(String string) {
        File file = new File(string);
        if (file.exists()) {
            long l = new Date(file.lastModified() + this.DELAY).getTime() - new Date().getTime();
            this.timer = new Timer();
            Log.info(this.getClass(), "Delete schedule started with delay : " + l);
            if (l > 0L) {
                this.timer.schedule((TimerTask)new RemoveFile(file), l);
            } else {
                this.timer.schedule((TimerTask)new RemoveFile(file), 0L);
                Log.trace(this.getClass(), "Delay is in minus. File Deleted");
            }
        }
    }

    private class FileComparator
    implements Comparator {
        private FileComparator() {
        }

        public int compare(Object object, Object object2) {
            long l;
            File file = (File)object;
            File file2 = (File)object2;
            long l2 = file.lastModified();
            if (l2 > (l = file2.lastModified())) {
                return 1;
            }
            if (l > l2) {
                return -1;
            }
            return 0;
        }
    }

    private class RemoveFile
    extends TimerTask {
        File file;

        public RemoveFile(File file) {
            this.file = file;
        }

        public void run() {
            this.file.delete();
        }
    }

    private class GenericExtFilter
    implements FilenameFilter {
        private String ext;

        public GenericExtFilter(String string) {
            this.ext = string;
        }

        public boolean accept(File file, String string) {
            return string.startsWith("MIBDUMP_") && string.endsWith(this.ext);
        }
    }
}

