/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.mibmgr;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.regexp.RE;
import se.ericsson.cello.ncli.mao.MibManagerInputFileException;
import se.ericsson.cello.ncli.mibmgr.MoAttribute;

public class InputFileReader {
    String fileName;
    private BufferedReader stream;
    private static final RE RDN_REGEXP = new RE("([a-zA-Z0-9]+)(=){1}(.)+");
    private static final RE COMMA_REGEXP = new RE("(,){2,}");
    private static final RE MOTYPE_REGEXP = new RE("[a-zA-Z0-9]+");
    private static final String ROOT = "ManagedElement=1";
    private int lineNumber = 0;

    public InputFileReader(String string) {
        this.fileName = string;
        this.stream = null;
    }

    public void closeFile() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public MoAttribute getNextEntry() throws IOException {
        String string;
        if (this.stream == null) {
            this.openFileStream();
        }
        MoAttribute moAttribute = null;
        while ((string = this.stream.readLine()) != null && string.startsWith("#")) {
        }
        if (string != null) {
            try {
                moAttribute = new MoAttribute(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return this.getNextEntry();
            }
        }
        return moAttribute;
    }

    public String getNextKey() throws MibManagerInputFileException, IOException {
        StringTokenizer stringTokenizer;
        String string = null;
        if (this.stream == null) {
            this.openFileStream();
        }
        String string2 = null;
        do {
            string2 = this.stream.readLine();
            ++this.lineNumber;
        } while (string2 != null && string2.startsWith("#"));
        if (string2 != null && (stringTokenizer = new StringTokenizer(string2, ":")).hasMoreTokens()) {
            if (stringTokenizer.countTokens() > 1) {
                string = stringTokenizer.nextToken();
            } else {
                throw new MibManagerInputFileException("Element <" + string2 + ">  has no attributes");
            }
        }
        return string;
    }

    public void validateFile() throws MibManagerInputFileException {
        String string = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            while ((string = this.getNextKey()) != null) {
                if (hashMap.get(string) == null) {
                    if (!this.checkValidMo(string)) {
                        throw new MibManagerInputFileException("Input file has faulty syntax on line: " + this.lineNumber);
                    }
                    hashMap.put(string, "");
                    continue;
                }
                throw new MibManagerInputFileException("Element <" + string + "> exists more than once in input file");
            }
            if (hashMap.size() == 0) {
                throw new MibManagerInputFileException("Input file is empty");
            }
        }
        catch (IOException iOException) {
            throw new MibManagerInputFileException("Exception while reading input file: " + iOException.toString());
        }
    }

    private void openFileStream() throws FileNotFoundException {
        this.stream = new BufferedReader(new InputStreamReader(new FileInputStream(this.fileName)));
    }

    private boolean checkValidMo(String string) {
        boolean bl = true;
        if (string.indexOf("=") != -1) {
            if (COMMA_REGEXP.match(string)) {
                bl = false;
            }
            if (string.startsWith(ROOT)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = "";
                while (stringTokenizer.hasMoreElements()) {
                    string2 = stringTokenizer.nextToken();
                    if (RDN_REGEXP.match(string2) && string2 == RDN_REGEXP.getParen(0)) continue;
                    bl = false;
                }
            } else {
                bl = false;
            }
        } else if (!MOTYPE_REGEXP.match(string) || string != MOTYPE_REGEXP.getParen(0)) {
            bl = false;
        }
        return bl;
    }
}

